/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.ec2.Activity;
import com.xerox.amazonws.ec2.AutoScalingException;
import com.xerox.amazonws.ec2.AutoScalingGroup;
import com.xerox.amazonws.ec2.BlockDeviceMapping;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import com.xerox.amazonws.ec2.ScalingTrigger;
import com.xerox.amazonws.monitoring.StandardUnit;
import com.xerox.amazonws.monitoring.Statistics;
import com.xerox.amazonws.typica.autoscale.jaxb.CreateAutoScalingGroupResponse;
import com.xerox.amazonws.typica.autoscale.jaxb.CreateLaunchConfigurationResponse;
import com.xerox.amazonws.typica.autoscale.jaxb.CreateOrUpdateScalingTriggerResponse;
import com.xerox.amazonws.typica.autoscale.jaxb.DeleteAutoScalingGroupResponse;
import com.xerox.amazonws.typica.autoscale.jaxb.DeleteLaunchConfigurationResponse;
import com.xerox.amazonws.typica.autoscale.jaxb.DeleteTriggerResponse;
import com.xerox.amazonws.typica.autoscale.jaxb.DescribeAutoScalingGroupsResponse;
import com.xerox.amazonws.typica.autoscale.jaxb.DescribeLaunchConfigurationsResponse;
import com.xerox.amazonws.typica.autoscale.jaxb.DescribeScalingActivitiesResponse;
import com.xerox.amazonws.typica.autoscale.jaxb.DescribeScalingActivitiesResult;
import com.xerox.amazonws.typica.autoscale.jaxb.DescribeTriggersResponse;
import com.xerox.amazonws.typica.autoscale.jaxb.Dimension;
import com.xerox.amazonws.typica.autoscale.jaxb.Instance;
import com.xerox.amazonws.typica.autoscale.jaxb.SetDesiredCapacityResponse;
import com.xerox.amazonws.typica.autoscale.jaxb.TerminateInstanceInAutoScalingGroupResponse;
import com.xerox.amazonws.typica.autoscale.jaxb.TerminateInstanceInAutoScalingGroupResult;
import com.xerox.amazonws.typica.autoscale.jaxb.Trigger;
import com.xerox.amazonws.typica.autoscale.jaxb.UpdateAutoScalingGroupResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoScaling
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(AutoScaling.class);

    public AutoScaling(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public AutoScaling(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "autoscaling.amazonaws.com");
    }

    public AutoScaling(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public AutoScaling(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2009-05-15");
        this.headers.put("Version", vals);
    }

    public void createLaunchConfiguration(LaunchConfiguration config) throws AutoScalingException {
        int i;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LaunchConfigurationName", config.getConfigName());
        params.put("ImageId", config.getImageId());
        byte[] userData = config.getUserData();
        if (userData != null && userData.length > 0) {
            params.put("UserData", new String(Base64.encodeBase64((byte[])userData)));
        }
        params.put("AddressingType", "public");
        String keyName = config.getKeyName();
        if (keyName != null && !keyName.trim().equals("")) {
            params.put("KeyName", keyName);
        }
        if (config.getSecurityGroup() != null) {
            for (i = 0; i < config.getSecurityGroup().size(); ++i) {
                params.put("SecurityGroup." + (i + 1), config.getSecurityGroup().get(i));
            }
        }
        params.put("InstanceType", config.getInstanceType().getTypeId());
        if (config.getAvailabilityZone() != null && !config.getAvailabilityZone().trim().equals("")) {
            params.put("Placement.AvailabilityZone", config.getAvailabilityZone());
        }
        if (config.getKernelId() != null && !config.getKernelId().trim().equals("")) {
            params.put("KernelId", config.getKernelId());
        }
        if (config.getRamdiskId() != null && !config.getRamdiskId().trim().equals("")) {
            params.put("RamdiskId", config.getRamdiskId());
        }
        if (config.getBlockDevicemappings() != null) {
            for (i = 0; i < config.getBlockDevicemappings().size(); ++i) {
                BlockDeviceMapping bdm = config.getBlockDevicemappings().get(i);
                params.put("BlockDeviceMapping." + (i + 1) + ".VirtualName", bdm.getVirtualName());
                params.put("BlockDeviceMapping." + (i + 1) + ".DeviceName", bdm.getDeviceName());
            }
        }
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "CreateLaunchConfiguration", params, CreateLaunchConfigurationResponse.class);
    }

    public void deleteLaunchConfiguration(String configName) throws AutoScalingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LaunchConfigurationName", configName);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "DeleteLaunchConfiguration", params, DeleteLaunchConfigurationResponse.class);
    }

    public List<LaunchConfiguration> describeLaunchConfigurations(List<String> configNames) throws AutoScalingException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (configNames != null && configNames.size() > 0) {
            int i = 0;
            for (String name : configNames) {
                params.put("LaunchConfigurationNames.member." + (i + 1), name);
                ++i;
            }
        }
        HttpGet method = new HttpGet();
        DescribeLaunchConfigurationsResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeLaunchConfigurations", params, DescribeLaunchConfigurationsResponse.class);
        List<com.xerox.amazonws.typica.autoscale.jaxb.LaunchConfiguration> result = response.getDescribeLaunchConfigurationsResult().getLaunchConfigurations().getMembers();
        ArrayList<LaunchConfiguration> ret = new ArrayList<LaunchConfiguration>();
        for (com.xerox.amazonws.typica.autoscale.jaxb.LaunchConfiguration config : result) {
            LaunchConfiguration newConfig = new LaunchConfiguration(config.getLaunchConfigurationName(), config.getImageId(), 1, 1);
            newConfig.setKeyName(config.getKeyName());
            newConfig.setSecurityGroup(config.getSecurityGroups().getMembers());
            newConfig.setUserData(config.getUserData().getBytes());
            newConfig.setInstanceType(InstanceType.getTypeFromString(config.getInstanceType()));
            newConfig.setKernelId(config.getKernelId());
            newConfig.setRamdiskId(config.getRamdiskId());
            ArrayList<BlockDeviceMapping> mappings = new ArrayList<BlockDeviceMapping>();
            for (com.xerox.amazonws.typica.autoscale.jaxb.BlockDeviceMapping mapping : config.getBlockDeviceMappings().getMembers()) {
                mappings.add(new BlockDeviceMapping(mapping.getVirtualName(), mapping.getDeviceName()));
            }
            newConfig.setBlockDevicemappings(mappings);
            ret.add(newConfig);
        }
        return ret;
    }

    public Activity terminateInstancesInAutoScalingGroup(String instanceId, boolean shouldDecrement) throws AutoScalingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        params.put("ShouldDecrementDesiredCapacity", shouldDecrement ? "true" : "false");
        HttpGet method = new HttpGet();
        TerminateInstanceInAutoScalingGroupResponse response = this.makeRequestInt((HttpRequestBase)method, "TerminateInstanceInAutoScalingGroup", params, TerminateInstanceInAutoScalingGroupResponse.class);
        TerminateInstanceInAutoScalingGroupResult result = response.getTerminateInstanceInAutoScalingGroupResult();
        com.xerox.amazonws.typica.autoscale.jaxb.Activity activity = result.getActivity();
        Activity ret = new Activity(activity.getActivityId(), activity.getDescription(), activity.getCause(), activity.getStartTime().toString(), activity.getEndTime().toString(), activity.getStatusCode(), activity.getStatusMessage(), activity.getProgress().intValue());
        return ret;
    }

    public List<Activity> describeScalingActivities(List<String> activityIds, String autoScalingGroupName) throws AutoScalingException {
        DescribeScalingActivitiesResult result;
        HashMap<String, String> params = new HashMap<String, String>();
        if (activityIds != null && activityIds.size() > 0) {
            int i = 0;
            for (String id : activityIds) {
                params.put("ActivityIds.member." + (i + 1), id);
                ++i;
            }
        }
        params.put("AutoScalingGroupName", autoScalingGroupName);
        HttpGet method = new HttpGet();
        ArrayList<Activity> ret = new ArrayList<Activity>();
        String nextToken = null;
        do {
            if (nextToken != null) {
                params.put("NextToken", nextToken);
            }
            DescribeScalingActivitiesResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeScalingActivities", params, DescribeScalingActivitiesResponse.class);
            result = response.getDescribeScalingActivitiesResult();
            List<com.xerox.amazonws.typica.autoscale.jaxb.Activity> activities = result.getActivities().getMembers();
            for (com.xerox.amazonws.typica.autoscale.jaxb.Activity activity : activities) {
                Activity newActivity = new Activity(activity.getActivityId(), activity.getDescription(), activity.getCause(), activity.getStartTime().toString(), activity.getEndTime().toString(), activity.getStatusCode(), activity.getStatusMessage(), activity.getProgress().intValue());
                ret.add(newActivity);
            }
        } while ((nextToken = result.getNextToken()) != null);
        return ret;
    }

    public void createOrUpdateScalingTrigger(ScalingTrigger trigger) throws AutoScalingException {
        String tmp;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TriggerName", trigger.getName());
        params.put("AutoScalingGroupName", trigger.getAutoScalingGroupName());
        params.put("MeasureName", trigger.getMeasureName());
        params.put("Statistic", trigger.getStatistic().getStatId());
        Map<String, String> dimensions = trigger.getDimensions();
        if (dimensions != null && dimensions.size() > 0) {
            int i = 0;
            for (String key : dimensions.keySet()) {
                String value = dimensions.get(key);
                params.put("Dimensions.member." + (i + 1) + ".Name", key);
                params.put("Dimensions.member." + (i + 1) + ".Value", value);
                ++i;
            }
        }
        params.put("Period", "" + trigger.getPeriod());
        if (trigger.getUnit() != null) {
            params.put("Unit", trigger.getUnit().getUnitId());
        }
        if ((tmp = trigger.getCustomUnit()) != null && !tmp.equals("")) {
            params.put("CustomUnit", tmp);
        }
        params.put("LowerThreshold", "" + trigger.getLowerThreshold());
        params.put("LowerBreachScaleIncrement", trigger.getLowerBreachScaleIncrement());
        params.put("UpperThreshold", "" + trigger.getUpperThreshold());
        params.put("UpperBreachScaleIncrement", trigger.getUpperBreachScaleIncrement());
        params.put("BreachDuration", "" + trigger.getBreachDuration());
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "CreateOrUpdateScalingTrigger", params, CreateOrUpdateScalingTriggerResponse.class);
    }

    public void deleteTrigger(String triggerName, String autoScalingGroupName) throws AutoScalingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TriggerName", triggerName);
        params.put("AutoScalingGroupName", autoScalingGroupName);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "DeleteTrigger", params, DeleteTriggerResponse.class);
    }

    public List<ScalingTrigger> describeTriggers(String autoScalingGroupName) throws AutoScalingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("AutoScalingGroupName", autoScalingGroupName);
        HttpGet method = new HttpGet();
        DescribeTriggersResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeTriggers", params, DescribeTriggersResponse.class);
        List<Trigger> result = response.getDescribeTriggersResult().getTriggers().getMembers();
        ArrayList<ScalingTrigger> ret = new ArrayList<ScalingTrigger>();
        for (Trigger trigger : result) {
            HashMap<String, String> dimensions = new HashMap<String, String>();
            List<Dimension> dims = trigger.getDimensions().getMembers();
            for (Dimension dim : dims) {
                dimensions.put(dim.getName(), dim.getValue());
            }
            ScalingTrigger newTrigger = new ScalingTrigger(trigger.getTriggerName(), trigger.getAutoScalingGroupName(), trigger.getMeasureName(), Statistics.getTypeFromString(trigger.getStatistic()), dimensions, trigger.getPeriod().intValue(), StandardUnit.getTypeFromString(trigger.getUnit()), trigger.getCustomUnit(), trigger.getLowerThreshold(), trigger.getLowerBreachScaleIncrement(), trigger.getUpperThreshold(), trigger.getUpperBreachScaleIncrement(), trigger.getBreachDuration().intValue(), trigger.getStatus(), trigger.getCreatedTime().toGregorianCalendar());
            ret.add(newTrigger);
        }
        return ret;
    }

    public void createAutoScalingGroup(String autoScalingGroupName, String launchConfigurationName, int minSize, int maxSize, int cooldown, List<String> availabilityZones) throws AutoScalingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("AutoScalingGroupName", autoScalingGroupName);
        params.put("LaunchConfigurationName", launchConfigurationName);
        params.put("MinSize", "" + minSize);
        params.put("MaxSize", "" + maxSize);
        params.put("Cooldown", "" + cooldown);
        int i = 0;
        for (String zone : availabilityZones) {
            params.put("AvailabilityZones.member." + (i + 1), zone);
            ++i;
        }
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "CreateAutoScalingGroup", params, CreateAutoScalingGroupResponse.class);
    }

    public void deleteAutoScalingGroup(String autoScalingGroupName) throws AutoScalingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("AutoScalingGroupName", autoScalingGroupName);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "DeleteAutoScalingGroup", params, DeleteAutoScalingGroupResponse.class);
    }

    public List<AutoScalingGroup> describeAutoScalingGroups(List<String> autoScalingGroupNames) throws AutoScalingException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (autoScalingGroupNames != null && autoScalingGroupNames.size() > 0) {
            int i = 0;
            for (String name : autoScalingGroupNames) {
                params.put("AutoScalingGroupNames.member." + (i + 1), name);
                ++i;
            }
        }
        HttpGet method = new HttpGet();
        DescribeAutoScalingGroupsResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeAutoScalingGroups", params, DescribeAutoScalingGroupsResponse.class);
        List<com.xerox.amazonws.typica.autoscale.jaxb.AutoScalingGroup> result = response.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMembers();
        ArrayList<AutoScalingGroup> ret = new ArrayList<AutoScalingGroup>();
        for (com.xerox.amazonws.typica.autoscale.jaxb.AutoScalingGroup group : result) {
            ArrayList<String> zones = new ArrayList<String>();
            for (String zone : group.getAvailabilityZones().getMembers()) {
                zones.add(zone);
            }
            AutoScalingGroup newGroup = new AutoScalingGroup(group.getAutoScalingGroupName(), group.getLaunchConfigurationName(), group.getMinSize().intValue(), group.getMaxSize().intValue(), group.getDesiredCapacity().intValue(), group.getCooldown().intValue(), zones, group.getCreatedTime().toGregorianCalendar());
            List<Instance> instList = group.getInstances().getMembers();
            for (Instance inst : instList) {
                newGroup.addInstance(inst.getInstanceId(), inst.getLifecycleState());
            }
            ret.add(newGroup);
        }
        return ret;
    }

    public void setDesiredCapacity(String autoScalingGroupName, int desiredCapacity) throws AutoScalingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("AutoScalingGroupName", autoScalingGroupName);
        params.put("DesiredCapacity", "" + desiredCapacity);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "SetDesiredCapacity", params, SetDesiredCapacityResponse.class);
    }

    public void updateAutoScalingGroup(String autoScalingGroupName, String launchConfigurationName, int minSize, int maxSize, int defaultCooldown) throws AutoScalingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("AutoScalingGroupName", autoScalingGroupName);
        params.put("LaunchConfigurationName", launchConfigurationName);
        params.put("MinSize", "" + minSize);
        params.put("MaxSize", "" + maxSize);
        params.put("DefaultCooldown", "" + defaultCooldown);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "UpdateAutoScalingGroup", params, UpdateAutoScalingGroupResponse.class);
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws AutoScalingException {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new AutoScalingException(ex);
        }
        catch (JAXBException ex) {
            throw new AutoScalingException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new AutoScalingException("Problem parsing returned message.", ex);
        }
        catch (MalformedURLException ex) {
            throw new AutoScalingException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new AutoScalingException(ex.getMessage(), ex);
        }
        catch (HttpException ex) {
            throw new AutoScalingException(ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

