/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import com.xerox.amazonws.ec2.UploadPolicy;
import com.xerox.amazonws.typica.jaxb.BundleInstanceTaskErrorType;
import com.xerox.amazonws.typica.jaxb.BundleInstanceTaskStorageType;
import java.util.Calendar;

public class BundleInstanceInfo {
    private String requestId;
    private String instanceId;
    private String bundleId;
    private String state;
    private Calendar startTime;
    private Calendar updateTime;
    private StorageInfo storage;
    private String progress;
    private String error;

    public BundleInstanceInfo(String requestId, String instanceId, String bundleId, String state, Calendar startTime, Calendar updateTime, BundleInstanceTaskStorageType storage, String progress, BundleInstanceTaskErrorType error) {
        this.requestId = requestId;
        this.instanceId = instanceId;
        this.bundleId = bundleId;
        this.state = state;
        this.startTime = startTime;
        this.updateTime = updateTime;
        if (storage != null) {
            this.storage = new StorageInfo(storage);
        }
        this.progress = progress;
        if (error != null) {
            this.error = "(" + error.getCode() + ")" + error.getMessage();
        }
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public String getState() {
        return this.state;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public Calendar getUpdateTime() {
        return this.updateTime;
    }

    public StorageInfo getStorage() {
        return this.storage;
    }

    public String getProgress() {
        return this.progress;
    }

    public String getError() {
        return this.error;
    }

    public String toString() {
        return "BundleInstance[bundleId=" + this.bundleId + ", instanceId=" + this.instanceId + ", state=" + this.state + ", progress=" + this.progress + ", startTime=" + this.startTime + ", updateTime=" + this.updateTime + ", storage=" + this.storage.toString() + ", error=" + this.error + "]";
    }

    public class StorageInfo {
        private String bucket;
        private String prefix;
        private String accessId;
        private UploadPolicy policy;

        StorageInfo(BundleInstanceTaskStorageType storage) {
            this.bucket = storage.getS3().getBucket();
            this.prefix = storage.getS3().getPrefix();
            this.accessId = storage.getS3().getAwsAccessKeyId();
            this.policy = new UploadPolicy(storage.getS3().getUploadPolicy());
        }

        public StorageInfo(String bucket, String prefix, String accessId, UploadPolicy policy) {
            this.bucket = bucket;
            this.prefix = prefix;
            this.accessId = accessId;
            this.policy = policy;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String accessId() {
            return this.accessId;
        }

        public UploadPolicy getUploadPolicy() {
            return this.policy;
        }

        public String toString() {
            return "[bucket=" + this.bucket + ", prefix=" + this.prefix + ", accessId=" + this.accessId + ", policy=" + this.policy.toString() + "]";
        }
    }
}

