/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.ec2.AddressInfo;
import com.xerox.amazonws.ec2.AttachmentInfo;
import com.xerox.amazonws.ec2.AvailabilityZone;
import com.xerox.amazonws.ec2.BlockDeviceMapping;
import com.xerox.amazonws.ec2.BundleInstanceInfo;
import com.xerox.amazonws.ec2.ConsoleOutput;
import com.xerox.amazonws.ec2.DescribeImageAttributeResult;
import com.xerox.amazonws.ec2.DescribeInstanceAttributeResult;
import com.xerox.amazonws.ec2.DescribeSnapshotAttributeResult;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.ImageAttribute;
import com.xerox.amazonws.ec2.ImageDescription;
import com.xerox.amazonws.ec2.ImageListAttribute;
import com.xerox.amazonws.ec2.ImageListAttributeItem;
import com.xerox.amazonws.ec2.InstanceStateChangeDescription;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import com.xerox.amazonws.ec2.LaunchPermissionAttribute;
import com.xerox.amazonws.ec2.MonitoredInstanceInfo;
import com.xerox.amazonws.ec2.OperationType;
import com.xerox.amazonws.ec2.PlacementGroupInfo;
import com.xerox.amazonws.ec2.ProductCodesAttribute;
import com.xerox.amazonws.ec2.ProductDescription;
import com.xerox.amazonws.ec2.ProductInstanceInfo;
import com.xerox.amazonws.ec2.RegionInfo;
import com.xerox.amazonws.ec2.ReservationDescription;
import com.xerox.amazonws.ec2.ReservedInstances;
import com.xerox.amazonws.ec2.SnapshotInfo;
import com.xerox.amazonws.ec2.SpotDatafeedSubscription;
import com.xerox.amazonws.ec2.SpotInstanceCancellationResponse;
import com.xerox.amazonws.ec2.SpotInstanceRequest;
import com.xerox.amazonws.ec2.SpotInstanceRequestConfiguration;
import com.xerox.amazonws.ec2.SpotPriceHistoryItem;
import com.xerox.amazonws.ec2.UploadPolicy;
import com.xerox.amazonws.ec2.VolumeInfo;
import com.xerox.amazonws.typica.jaxb.AllocateAddressResponse;
import com.xerox.amazonws.typica.jaxb.AssociateAddressResponse;
import com.xerox.amazonws.typica.jaxb.AttachVolumeResponse;
import com.xerox.amazonws.typica.jaxb.AttachmentSetItemResponseType;
import com.xerox.amazonws.typica.jaxb.AttachmentSetResponseType;
import com.xerox.amazonws.typica.jaxb.AuthorizeSecurityGroupIngressResponse;
import com.xerox.amazonws.typica.jaxb.AvailabilityZoneItemType;
import com.xerox.amazonws.typica.jaxb.AvailabilityZoneMessageType;
import com.xerox.amazonws.typica.jaxb.AvailabilityZoneSetType;
import com.xerox.amazonws.typica.jaxb.BlockDeviceMappingItemType;
import com.xerox.amazonws.typica.jaxb.BlockDeviceMappingType;
import com.xerox.amazonws.typica.jaxb.BundleInstanceResponse;
import com.xerox.amazonws.typica.jaxb.BundleInstanceTaskType;
import com.xerox.amazonws.typica.jaxb.CancelBundleTaskResponse;
import com.xerox.amazonws.typica.jaxb.CancelSpotInstanceRequestsResponse;
import com.xerox.amazonws.typica.jaxb.CancelSpotInstanceRequestsResponseSetItemType;
import com.xerox.amazonws.typica.jaxb.ConfirmProductInstanceResponse;
import com.xerox.amazonws.typica.jaxb.CreateImageResponse;
import com.xerox.amazonws.typica.jaxb.CreateKeyPairResponse;
import com.xerox.amazonws.typica.jaxb.CreatePlacementGroupResponse;
import com.xerox.amazonws.typica.jaxb.CreateSecurityGroupResponse;
import com.xerox.amazonws.typica.jaxb.CreateSnapshotResponse;
import com.xerox.amazonws.typica.jaxb.CreateSpotDatafeedSubscriptionResponse;
import com.xerox.amazonws.typica.jaxb.CreateVolumePermissionItemType;
import com.xerox.amazonws.typica.jaxb.CreateVolumeResponse;
import com.xerox.amazonws.typica.jaxb.DeleteKeyPairResponse;
import com.xerox.amazonws.typica.jaxb.DeletePlacementGroupResponse;
import com.xerox.amazonws.typica.jaxb.DeleteSecurityGroupResponse;
import com.xerox.amazonws.typica.jaxb.DeleteSnapshotResponse;
import com.xerox.amazonws.typica.jaxb.DeleteSpotDatafeedSubscriptionResponse;
import com.xerox.amazonws.typica.jaxb.DeleteVolumeResponse;
import com.xerox.amazonws.typica.jaxb.DeregisterImageResponse;
import com.xerox.amazonws.typica.jaxb.DescribeAddressesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeAddressesResponseInfoType;
import com.xerox.amazonws.typica.jaxb.DescribeAddressesResponseItemType;
import com.xerox.amazonws.typica.jaxb.DescribeAvailabilityZonesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeBundleTasksResponse;
import com.xerox.amazonws.typica.jaxb.DescribeImageAttributeResponse;
import com.xerox.amazonws.typica.jaxb.DescribeImagesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeImagesResponseInfoType;
import com.xerox.amazonws.typica.jaxb.DescribeImagesResponseItemType;
import com.xerox.amazonws.typica.jaxb.DescribeInstanceAttributeResponse;
import com.xerox.amazonws.typica.jaxb.DescribeInstancesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeKeyPairsResponse;
import com.xerox.amazonws.typica.jaxb.DescribeKeyPairsResponseInfoType;
import com.xerox.amazonws.typica.jaxb.DescribeKeyPairsResponseItemType;
import com.xerox.amazonws.typica.jaxb.DescribePlacementGroupsResponse;
import com.xerox.amazonws.typica.jaxb.DescribeRegionsResponse;
import com.xerox.amazonws.typica.jaxb.DescribeReservedInstancesOfferingsResponse;
import com.xerox.amazonws.typica.jaxb.DescribeReservedInstancesOfferingsResponseSetItemType;
import com.xerox.amazonws.typica.jaxb.DescribeReservedInstancesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeReservedInstancesResponseSetItemType;
import com.xerox.amazonws.typica.jaxb.DescribeSecurityGroupsResponse;
import com.xerox.amazonws.typica.jaxb.DescribeSnapshotAttributeResponse;
import com.xerox.amazonws.typica.jaxb.DescribeSnapshotsResponse;
import com.xerox.amazonws.typica.jaxb.DescribeSnapshotsSetItemResponseType;
import com.xerox.amazonws.typica.jaxb.DescribeSnapshotsSetResponseType;
import com.xerox.amazonws.typica.jaxb.DescribeSpotDatafeedSubscriptionResponse;
import com.xerox.amazonws.typica.jaxb.DescribeSpotInstanceRequestsResponse;
import com.xerox.amazonws.typica.jaxb.DescribeSpotPriceHistoryResponse;
import com.xerox.amazonws.typica.jaxb.DescribeVolumesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeVolumesSetItemResponseType;
import com.xerox.amazonws.typica.jaxb.DescribeVolumesSetResponseType;
import com.xerox.amazonws.typica.jaxb.DetachVolumeResponse;
import com.xerox.amazonws.typica.jaxb.DisassociateAddressResponse;
import com.xerox.amazonws.typica.jaxb.EbsBlockDeviceType;
import com.xerox.amazonws.typica.jaxb.GetConsoleOutputResponse;
import com.xerox.amazonws.typica.jaxb.GetPasswordDataResponse;
import com.xerox.amazonws.typica.jaxb.InstanceStateChangeSetType;
import com.xerox.amazonws.typica.jaxb.InstanceStateChangeType;
import com.xerox.amazonws.typica.jaxb.IpPermissionSetType;
import com.xerox.amazonws.typica.jaxb.IpPermissionType;
import com.xerox.amazonws.typica.jaxb.IpRangeItemType;
import com.xerox.amazonws.typica.jaxb.LaunchPermissionItemType;
import com.xerox.amazonws.typica.jaxb.LaunchPermissionListType;
import com.xerox.amazonws.typica.jaxb.ModifyImageAttributeResponse;
import com.xerox.amazonws.typica.jaxb.ModifyInstanceAttributeResponse;
import com.xerox.amazonws.typica.jaxb.ModifySnapshotAttributeResponse;
import com.xerox.amazonws.typica.jaxb.MonitorInstancesResponseSetItemType;
import com.xerox.amazonws.typica.jaxb.MonitorInstancesResponseType;
import com.xerox.amazonws.typica.jaxb.NullableAttributeValueType;
import com.xerox.amazonws.typica.jaxb.PlacementGroupInfoType;
import com.xerox.amazonws.typica.jaxb.ProductCodeItemType;
import com.xerox.amazonws.typica.jaxb.ProductCodeListType;
import com.xerox.amazonws.typica.jaxb.ProductCodesSetItemType;
import com.xerox.amazonws.typica.jaxb.ProductCodesSetType;
import com.xerox.amazonws.typica.jaxb.PurchaseReservedInstancesOfferingResponse;
import com.xerox.amazonws.typica.jaxb.RebootInstancesResponse;
import com.xerox.amazonws.typica.jaxb.RegionItemType;
import com.xerox.amazonws.typica.jaxb.RegionSetType;
import com.xerox.amazonws.typica.jaxb.RegisterImageResponse;
import com.xerox.amazonws.typica.jaxb.ReleaseAddressResponse;
import com.xerox.amazonws.typica.jaxb.RequestSpotInstancesResponse;
import com.xerox.amazonws.typica.jaxb.ReservationInfoType;
import com.xerox.amazonws.typica.jaxb.ReservationSetType;
import com.xerox.amazonws.typica.jaxb.ResetImageAttributeResponse;
import com.xerox.amazonws.typica.jaxb.ResetInstanceAttributeResponse;
import com.xerox.amazonws.typica.jaxb.ResetSnapshotAttributeResponse;
import com.xerox.amazonws.typica.jaxb.RevokeSecurityGroupIngressResponse;
import com.xerox.amazonws.typica.jaxb.RunInstancesResponse;
import com.xerox.amazonws.typica.jaxb.SecurityGroupItemType;
import com.xerox.amazonws.typica.jaxb.SecurityGroupSetType;
import com.xerox.amazonws.typica.jaxb.SpotInstanceRequestSetItemType;
import com.xerox.amazonws.typica.jaxb.SpotPriceHistorySetItemType;
import com.xerox.amazonws.typica.jaxb.StartInstancesResponse;
import com.xerox.amazonws.typica.jaxb.StopInstancesResponse;
import com.xerox.amazonws.typica.jaxb.TerminateInstancesResponse;
import com.xerox.amazonws.typica.jaxb.UserIdGroupPairType;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jec2
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(Jec2.class);

    public Jec2(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public Jec2(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "ec2.amazonaws.com");
    }

    public Jec2(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public Jec2(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2010-06-15");
        this.headers.put("Version", vals);
    }

    public String createImage(String instanceId, String name, String description, boolean noReboot) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        params.put("Name", name);
        if (description != null && !description.trim().equals("")) {
            params.put("Description", description);
        }
        if (noReboot) {
            params.put("NoReboot", "true");
        }
        HttpGet method = new HttpGet();
        CreateImageResponse response = this.makeRequestInt((HttpRequestBase)method, "CreateImage", params, CreateImageResponse.class);
        return response.getImageId();
    }

    public String registerImage(String imageLocation) throws EC2Exception {
        return this.registerImage(imageLocation, null, null, null, null, null, null, null);
    }

    public String registerImage(String name, String description, String architecture, String kernelId, String ramdiskId, String rootDeviceName, List<BlockDeviceMapping> blockDeviceMappings) throws EC2Exception {
        return this.registerImage(null, name, description, architecture, kernelId, ramdiskId, rootDeviceName, blockDeviceMappings);
    }

    protected String registerImage(String imageLocation, String name, String description, String architecture, String kernelId, String ramdiskId, String rootDeviceName, List<BlockDeviceMapping> blockDeviceMappings) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (imageLocation != null && !imageLocation.trim().equals("")) {
            params.put("ImageLocation", imageLocation);
        }
        if (name != null && !name.trim().equals("")) {
            params.put("Name", name);
        }
        if (description != null && !description.trim().equals("")) {
            params.put("Description", description);
        }
        if (architecture != null && !architecture.trim().equals("")) {
            params.put("Architecture", architecture);
        }
        if (kernelId != null && !kernelId.trim().equals("")) {
            params.put("KernelId", kernelId);
        }
        if (ramdiskId != null && !ramdiskId.trim().equals("")) {
            params.put("RamdiskId", ramdiskId);
        }
        if (rootDeviceName != null && !rootDeviceName.trim().equals("")) {
            params.put("RootDeviceName", rootDeviceName);
        }
        if (blockDeviceMappings != null) {
            for (int i = 0; i < blockDeviceMappings.size(); ++i) {
                BlockDeviceMapping bdm = blockDeviceMappings.get(i);
                params.put("BlockDeviceMapping." + (i + 1) + ".DeviceName", bdm.getDeviceName());
                if (bdm.getVirtualName() != null) {
                    params.put("BlockDeviceMapping." + (i + 1) + ".VirtualName", bdm.getVirtualName());
                    continue;
                }
                if (bdm.getSnapshotId() != null) {
                    params.put("BlockDeviceMapping." + (i + 1) + ".Ebs.SnapshotId", bdm.getSnapshotId());
                }
                if (bdm.getVolumeSize() > 0) {
                    params.put("BlockDeviceMapping." + (i + 1) + ".Ebs.VolumeSize", "" + bdm.getVolumeSize());
                }
                params.put("BlockDeviceMapping." + (i + 1) + ".Ebs.DeleteOnTermination", bdm.isDeleteOnTerminate() ? "true" : "false");
            }
        }
        HttpGet method = new HttpGet();
        RegisterImageResponse response = this.makeRequestInt((HttpRequestBase)method, "RegisterImage", params, RegisterImageResponse.class);
        return response.getImageId();
    }

    public void deregisterImage(String imageId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageId", imageId);
        HttpGet method = new HttpGet();
        DeregisterImageResponse response = this.makeRequestInt((HttpRequestBase)method, "DeregisterImage", params, DeregisterImageResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not deregister image : " + imageId + ". No reason given.");
        }
    }

    public List<ImageDescription> describeImages(String[] imageIds) throws EC2Exception {
        return this.describeImages(Arrays.asList(imageIds));
    }

    public List<ImageDescription> describeImages(List<String> imageIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < imageIds.size(); ++i) {
            params.put("ImageId." + (i + 1), imageIds.get(i));
        }
        return this.describeImages(params);
    }

    public List<ImageDescription> describeImagesByOwner(List<String> owners) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < owners.size(); ++i) {
            params.put("Owner." + (i + 1), owners.get(i));
        }
        return this.describeImages(params);
    }

    public List<ImageDescription> describeImagesByExecutability(List<String> users) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < users.size(); ++i) {
            params.put("ExecutableBy." + (i + 1), users.get(i));
        }
        return this.describeImages(params);
    }

    public List<ImageDescription> describeImages(List<String> imageIds, List<String> owners, List<String> users) throws EC2Exception {
        int i;
        HashMap<String, String> params = new HashMap<String, String>();
        for (i = 0; i < imageIds.size(); ++i) {
            params.put("ImageId." + (i + 1), imageIds.get(i));
        }
        for (i = 0; i < owners.size(); ++i) {
            params.put("Owner." + (i + 1), owners.get(i));
        }
        for (i = 0; i < users.size(); ++i) {
            params.put("ExecutableBy." + (i + 1), users.get(i));
        }
        return this.describeImages(params);
    }

    protected List<ImageDescription> describeImages(Map<String, String> params) throws EC2Exception {
        HttpGet method = new HttpGet();
        DescribeImagesResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeImages", params, DescribeImagesResponse.class);
        ArrayList<ImageDescription> result = new ArrayList<ImageDescription>();
        DescribeImagesResponseInfoType set = response.getImagesSet();
        for (DescribeImagesResponseItemType item : set.getItems()) {
            ArrayList<String> codes = new ArrayList<String>();
            ProductCodesSetType code_set = item.getProductCodes();
            if (code_set != null) {
                for (ProductCodesSetItemType code : code_set.getItems()) {
                    codes.add(code.getProductCode());
                }
            }
            ArrayList<BlockDeviceMapping> bdm = new ArrayList<BlockDeviceMapping>();
            BlockDeviceMappingType bdmType = item.getBlockDeviceMapping();
            if (bdmType != null) {
                for (BlockDeviceMappingItemType mapping : bdmType.getItems()) {
                    if (mapping.getVirtualName() != null) {
                        bdm.add(new BlockDeviceMapping(mapping.getVirtualName(), mapping.getDeviceName()));
                        continue;
                    }
                    if (mapping.getEbs() != null) {
                        EbsBlockDeviceType ebs = mapping.getEbs();
                        bdm.add(new BlockDeviceMapping(mapping.getDeviceName(), ebs.getSnapshotId(), ebs.getVolumeSize(), ebs.isDeleteOnTermination()));
                        continue;
                    }
                    bdm.add(new BlockDeviceMapping("", mapping.getDeviceName()));
                }
            }
            String reason = "";
            if (item.getStateReason() != null) {
                reason = item.getStateReason().getMessage();
            }
            result.add(new ImageDescription(item.getImageId(), item.getImageLocation(), item.getImageOwnerId(), item.getImageState(), item.isIsPublic(), codes, item.getArchitecture(), item.getImageType(), item.getKernelId(), item.getRamdiskId(), item.getPlatform(), reason, item.getImageOwnerAlias(), item.getName(), item.getDescription(), item.getRootDeviceType(), item.getRootDeviceName(), bdm, item.getVirtualizationType()));
        }
        return result;
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName) throws EC2Exception {
        return this.runInstances(imageId, minCount, maxCount, groupSet, userData, keyName, true, InstanceType.DEFAULT);
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName, boolean publicAddr) throws EC2Exception {
        return this.runInstances(imageId, minCount, maxCount, groupSet, userData, keyName, publicAddr, InstanceType.DEFAULT);
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName, InstanceType type) throws EC2Exception {
        return this.runInstances(imageId, minCount, maxCount, groupSet, userData, keyName, true, type);
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName, boolean publicAddr, InstanceType type) throws EC2Exception {
        return this.runInstances(imageId, minCount, maxCount, groupSet, userData, keyName, publicAddr, type, null, null, null, null);
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName, boolean publicAddr, InstanceType type, String availabilityZone, String kernelId, String ramdiskId, List<BlockDeviceMapping> blockDeviceMappings) throws EC2Exception {
        LaunchConfiguration lc = new LaunchConfiguration(imageId);
        lc.setMinCount(minCount);
        lc.setMaxCount(maxCount);
        lc.setSecurityGroup(groupSet);
        if (userData != null) {
            lc.setUserData(userData.getBytes());
        }
        lc.setKeyName(keyName);
        lc.setInstanceType(type);
        lc.setAvailabilityZone(availabilityZone);
        lc.setKernelId(kernelId);
        lc.setRamdiskId(ramdiskId);
        lc.setBlockDevicemappings(blockDeviceMappings);
        lc.setPublicAddressing(publicAddr);
        return this.runInstances(lc);
    }

    public ReservationDescription runInstances(LaunchConfiguration lc) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        lc.prepareQueryParams("", true, params);
        HttpPost method = new HttpPost();
        RunInstancesResponse response = this.makeRequestInt((HttpRequestBase)method, "RunInstances", params, RunInstancesResponse.class);
        ReservationDescription res = new ReservationDescription(response.getRequestId(), response.getOwnerId(), response.getReservationId(), response.getRequesterId(), response.getGroupSet(), response.getInstancesSet());
        return res;
    }

    public List<InstanceStateChangeDescription> startInstances(String[] instanceIds) throws EC2Exception {
        return this.startInstances(Arrays.asList(instanceIds));
    }

    public List<InstanceStateChangeDescription> startInstances(List<String> instanceIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < instanceIds.size(); ++i) {
            params.put("InstanceId." + (i + 1), instanceIds.get(i));
        }
        HttpGet method = new HttpGet();
        StartInstancesResponse response = this.makeRequestInt((HttpRequestBase)method, "StartInstances", params, StartInstancesResponse.class);
        ArrayList<InstanceStateChangeDescription> res = new ArrayList<InstanceStateChangeDescription>();
        InstanceStateChangeSetType set = response.getInstancesSet();
        for (InstanceStateChangeType rsp_item : set.getItems()) {
            res.add(new InstanceStateChangeDescription(rsp_item.getInstanceId(), rsp_item.getPreviousState().getName(), rsp_item.getPreviousState().getCode(), rsp_item.getCurrentState().getName(), rsp_item.getCurrentState().getCode()));
        }
        return res;
    }

    public List<InstanceStateChangeDescription> stopInstances(String[] instanceIds, boolean force) throws EC2Exception {
        return this.stopInstances(Arrays.asList(instanceIds), force);
    }

    public List<InstanceStateChangeDescription> stopInstances(List<String> instanceIds, boolean force) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < instanceIds.size(); ++i) {
            params.put("InstanceId." + (i + 1), instanceIds.get(i));
        }
        HttpGet method = new HttpGet();
        StopInstancesResponse response = this.makeRequestInt((HttpRequestBase)method, "StopInstances", params, StopInstancesResponse.class);
        ArrayList<InstanceStateChangeDescription> res = new ArrayList<InstanceStateChangeDescription>();
        InstanceStateChangeSetType set = response.getInstancesSet();
        for (InstanceStateChangeType rsp_item : set.getItems()) {
            res.add(new InstanceStateChangeDescription(rsp_item.getInstanceId(), rsp_item.getPreviousState().getName(), rsp_item.getPreviousState().getCode(), rsp_item.getCurrentState().getName(), rsp_item.getCurrentState().getCode()));
        }
        return res;
    }

    public List<InstanceStateChangeDescription> terminateInstances(String[] instanceIds) throws EC2Exception {
        return this.terminateInstances(Arrays.asList(instanceIds));
    }

    public List<InstanceStateChangeDescription> terminateInstances(List<String> instanceIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < instanceIds.size(); ++i) {
            params.put("InstanceId." + (i + 1), instanceIds.get(i));
        }
        HttpPost method = new HttpPost();
        TerminateInstancesResponse response = this.makeRequestInt((HttpRequestBase)method, "TerminateInstances", params, TerminateInstancesResponse.class);
        ArrayList<InstanceStateChangeDescription> res = new ArrayList<InstanceStateChangeDescription>();
        InstanceStateChangeSetType set = response.getInstancesSet();
        for (InstanceStateChangeType rsp_item : set.getItems()) {
            res.add(new InstanceStateChangeDescription(rsp_item.getInstanceId(), rsp_item.getPreviousState().getName(), rsp_item.getPreviousState().getCode(), rsp_item.getCurrentState().getName(), rsp_item.getCurrentState().getCode()));
        }
        return res;
    }

    public List<ReservationDescription> describeInstances(String[] instanceIds) throws EC2Exception {
        return this.describeInstances(Arrays.asList(instanceIds));
    }

    public List<ReservationDescription> describeInstances(List<String> instanceIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < instanceIds.size(); ++i) {
            params.put("InstanceId." + (i + 1), instanceIds.get(i));
        }
        HttpGet method = new HttpGet();
        DescribeInstancesResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeInstances", params, DescribeInstancesResponse.class);
        ArrayList<ReservationDescription> result = new ArrayList<ReservationDescription>();
        ReservationSetType res_set = response.getReservationSet();
        for (ReservationInfoType item : res_set.getItems()) {
            ReservationDescription res = new ReservationDescription(response.getRequestId(), item.getOwnerId(), item.getReservationId(), item.getRequesterId(), item.getGroupSet(), item.getInstancesSet());
            result.add(res);
        }
        return result;
    }

    public void rebootInstances(String[] instanceIds) throws EC2Exception {
        this.rebootInstances(Arrays.asList(instanceIds));
    }

    public void rebootInstances(List<String> instanceIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < instanceIds.size(); ++i) {
            params.put("InstanceId." + (i + 1), instanceIds.get(i));
        }
        HttpGet method = new HttpGet();
        RebootInstancesResponse response = this.makeRequestInt((HttpRequestBase)method, "RebootInstances", params, RebootInstancesResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not reboot instances. No reason given.");
        }
    }

    public void modifyInstanceAttribute(String instanceId, String attribute, String value) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        params.put("Attribute", attribute);
        params.put("Value", value);
        HttpPost method = new HttpPost();
        ModifyInstanceAttributeResponse response = this.makeRequestInt((HttpRequestBase)method, "ModifyInstanceAttribute", params, ModifyInstanceAttributeResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not modify instance attribute : " + attribute + ". No reason given.");
        }
    }

    public void resetInstanceAttribute(String instanceId, String attribute) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        params.put("Attribute", attribute);
        HttpGet method = new HttpGet();
        ResetInstanceAttributeResponse response = this.makeRequestInt((HttpRequestBase)method, "ResetInstanceAttribute", params, ResetInstanceAttributeResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not reset instance attribute. No reason given.");
        }
    }

    public DescribeInstanceAttributeResult describeInstanceAttribute(String instanceId, String attribute) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        params.put("Attribute", attribute);
        HttpGet method = new HttpGet();
        DescribeInstanceAttributeResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeInstanceAttribute", params, DescribeInstanceAttributeResponse.class);
        return new DescribeInstanceAttributeResult(response);
    }

    public ConsoleOutput getConsoleOutput(String instanceId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        HttpGet method = new HttpGet();
        GetConsoleOutputResponse response = this.makeRequestInt((HttpRequestBase)method, "GetConsoleOutput", params, GetConsoleOutputResponse.class);
        return new ConsoleOutput(response.getRequestId(), response.getInstanceId(), response.getTimestamp().toGregorianCalendar(), new String(Base64.decodeBase64((byte[])response.getOutput().getBytes())));
    }

    public String getPasswordData(String instanceId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        HttpGet method = new HttpGet();
        GetPasswordDataResponse response = this.makeRequestInt((HttpRequestBase)method, "GetPasswordData", params, GetPasswordDataResponse.class);
        return response.getPasswordData();
    }

    public void createSecurityGroup(String name, String desc) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", name);
        params.put("GroupDescription", desc);
        HttpGet method = new HttpGet();
        CreateSecurityGroupResponse response = this.makeRequestInt((HttpRequestBase)method, "CreateSecurityGroup", params, CreateSecurityGroupResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not create security group : " + name + ". No reason given.");
        }
    }

    public void deleteSecurityGroup(String name) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", name);
        HttpGet method = new HttpGet();
        DeleteSecurityGroupResponse response = this.makeRequestInt((HttpRequestBase)method, "DeleteSecurityGroup", params, DeleteSecurityGroupResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not delete security group : " + name + ". No reason given.");
        }
    }

    public List<GroupDescription> describeSecurityGroups(String[] groupNames) throws EC2Exception {
        return this.describeSecurityGroups(Arrays.asList(groupNames));
    }

    public List<GroupDescription> describeSecurityGroups(List<String> groupNames) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < groupNames.size(); ++i) {
            params.put("GroupName." + (i + 1), groupNames.get(i));
        }
        HttpGet method = new HttpGet();
        DescribeSecurityGroupsResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeSecurityGroups", params, DescribeSecurityGroupsResponse.class);
        ArrayList<GroupDescription> result = new ArrayList<GroupDescription>();
        SecurityGroupSetType rsp_set = response.getSecurityGroupInfo();
        for (SecurityGroupItemType item : rsp_set.getItems()) {
            GroupDescription group = new GroupDescription(item.getGroupName(), item.getGroupDescription(), item.getOwnerId());
            IpPermissionSetType perms = item.getIpPermissions();
            for (IpPermissionType perm : perms.getItems()) {
                GroupDescription.IpPermission group_perms = group.addPermission(perm.getIpProtocol(), perm.getFromPort(), perm.getToPort());
                for (UserIdGroupPairType uid_group : perm.getGroups().getItems()) {
                    group_perms.addUserGroupPair(uid_group.getUserId(), uid_group.getGroupName());
                }
                for (IpRangeItemType range : perm.getIpRanges().getItems()) {
                    group_perms.addIpRange(range.getCidrIp());
                }
            }
            result.add(group);
        }
        return result;
    }

    public void authorizeSecurityGroupIngress(String groupName, String secGroupName, String secGroupOwnerId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", groupName);
        params.put("SourceSecurityGroupOwnerId", secGroupOwnerId);
        params.put("SourceSecurityGroupName", secGroupName);
        HttpGet method = new HttpGet();
        AuthorizeSecurityGroupIngressResponse response = this.makeRequestInt((HttpRequestBase)method, "AuthorizeSecurityGroupIngress", params, AuthorizeSecurityGroupIngressResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not authorize security ingress : " + groupName + ". No reason given.");
        }
    }

    public void authorizeSecurityGroupIngress(String groupName, String ipProtocol, int fromPort, int toPort, String cidrIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", groupName);
        params.put("IpProtocol", ipProtocol);
        params.put("FromPort", "" + fromPort);
        params.put("ToPort", "" + toPort);
        params.put("CidrIp", cidrIp);
        HttpGet method = new HttpGet();
        AuthorizeSecurityGroupIngressResponse response = this.makeRequestInt((HttpRequestBase)method, "AuthorizeSecurityGroupIngress", params, AuthorizeSecurityGroupIngressResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not authorize security ingress : " + groupName + ". No reason given.");
        }
    }

    public void revokeSecurityGroupIngress(String groupName, String secGroupName, String secGroupOwnerId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", groupName);
        params.put("SourceSecurityGroupOwnerId", secGroupOwnerId);
        params.put("SourceSecurityGroupName", secGroupName);
        HttpGet method = new HttpGet();
        RevokeSecurityGroupIngressResponse response = this.makeRequestInt((HttpRequestBase)method, "RevokeSecurityGroupIngress", params, RevokeSecurityGroupIngressResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not revoke security ingress : " + groupName + ". No reason given.");
        }
    }

    public void revokeSecurityGroupIngress(String groupName, String ipProtocol, int fromPort, int toPort, String cidrIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", groupName);
        params.put("IpProtocol", ipProtocol);
        params.put("FromPort", "" + fromPort);
        params.put("ToPort", "" + toPort);
        params.put("CidrIp", cidrIp);
        HttpGet method = new HttpGet();
        RevokeSecurityGroupIngressResponse response = this.makeRequestInt((HttpRequestBase)method, "RevokeSecurityGroupIngress", params, RevokeSecurityGroupIngressResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not revoke security ingress : " + groupName + ". No reason given.");
        }
    }

    public KeyPairInfo createKeyPair(String keyName) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("KeyName", keyName);
        HttpGet method = new HttpGet();
        CreateKeyPairResponse response = this.makeRequestInt((HttpRequestBase)method, "CreateKeyPair", params, CreateKeyPairResponse.class);
        return new KeyPairInfo(response.getKeyName(), response.getKeyFingerprint(), response.getKeyMaterial());
    }

    public List<KeyPairInfo> describeKeyPairs(String[] keyIds) throws EC2Exception {
        return this.describeKeyPairs(Arrays.asList(keyIds));
    }

    public List<KeyPairInfo> describeKeyPairs(List<String> keyIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < keyIds.size(); ++i) {
            params.put("KeyName." + (i + 1), keyIds.get(i));
        }
        HttpGet method = new HttpGet();
        DescribeKeyPairsResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeKeyPairs", params, DescribeKeyPairsResponse.class);
        ArrayList<KeyPairInfo> result = new ArrayList<KeyPairInfo>();
        DescribeKeyPairsResponseInfoType set = response.getKeySet();
        for (DescribeKeyPairsResponseItemType item : set.getItems()) {
            result.add(new KeyPairInfo(item.getKeyName(), item.getKeyFingerprint(), null));
        }
        return result;
    }

    public void deleteKeyPair(String keyName) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("KeyName", keyName);
        HttpGet method = new HttpGet();
        DeleteKeyPairResponse response = this.makeRequestInt((HttpRequestBase)method, "DeleteKeyPair", params, DeleteKeyPairResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not delete keypair : " + keyName + ". No reason given.");
        }
    }

    public void modifyImageAttribute(String imageId, ImageListAttribute attribute, ImageListAttributeOperationType operationType) throws EC2Exception {
        HashMap<String, String> params;
        block13: {
            block12: {
                params = new HashMap<String, String>();
                params.put("ImageId", imageId);
                if (!attribute.getType().equals((Object)ImageAttribute.ImageAttributeType.launchPermission)) break block12;
                params.put("Attribute", "launchPermission");
                switch (operationType) {
                    case add: {
                        params.put("OperationType", "add");
                        break block13;
                    }
                    case remove: {
                        params.put("OperationType", "remove");
                        break block13;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown attribute operation.");
                    }
                }
            }
            if (attribute.getType().equals((Object)ImageAttribute.ImageAttributeType.productCodes)) {
                params.put("Attribute", "productCodes");
            }
        }
        int gNum = 1;
        int iNum = 1;
        int pNum = 1;
        block9: for (ImageListAttributeItem item : attribute.getImageListAttributeItems()) {
            switch (item.getType()) {
                case group: {
                    params.put("UserGroup." + gNum, item.getValue());
                    ++gNum;
                    continue block9;
                }
                case userId: {
                    params.put("UserId." + iNum, item.getValue());
                    ++iNum;
                    continue block9;
                }
                case productCode: {
                    params.put("ProductCode." + pNum, item.getValue());
                    ++pNum;
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Unknown item type.");
        }
        HttpGet method = new HttpGet();
        ModifyImageAttributeResponse response = this.makeRequestInt((HttpRequestBase)method, "ModifyImageAttribute", params, ModifyImageAttributeResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not reset image attribute. No reason given.");
        }
    }

    public void resetImageAttribute(String imageId, ImageAttribute.ImageAttributeType imageAttribute) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageId", imageId);
        if (imageAttribute.equals((Object)ImageAttribute.ImageAttributeType.launchPermission)) {
            params.put("Attribute", "launchPermission");
        } else if (imageAttribute.equals((Object)ImageAttribute.ImageAttributeType.productCodes)) {
            throw new IllegalArgumentException("Cannot reset productCodes attribute");
        }
        HttpGet method = new HttpGet();
        ResetImageAttributeResponse response = this.makeRequestInt((HttpRequestBase)method, "ResetImageAttribute", params, ResetImageAttributeResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not reset image attribute. No reason given.");
        }
    }

    public DescribeImageAttributeResult describeImageAttribute(String imageId, ImageAttribute.ImageAttributeType imageAttribute) throws EC2Exception {
        NullableAttributeValueType val;
        Object item;
        ListIterator<Object> i;
        Object list;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageId", imageId);
        if (imageAttribute.equals((Object)ImageAttribute.ImageAttributeType.launchPermission)) {
            params.put("Attribute", "launchPermission");
        } else if (imageAttribute.equals((Object)ImageAttribute.ImageAttributeType.productCodes)) {
            params.put("Attribute", "productCodes");
        }
        HttpGet method = new HttpGet();
        DescribeImageAttributeResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeImageAttribute", params, DescribeImageAttributeResponse.class);
        ImageListAttribute attribute = null;
        if (response.getLaunchPermission() != null) {
            list = response.getLaunchPermission();
            attribute = new LaunchPermissionAttribute();
            i = ((LaunchPermissionListType)list).getItems().listIterator();
            while (i.hasNext()) {
                item = (LaunchPermissionItemType)i.next();
                if (((LaunchPermissionItemType)item).getGroup() != null) {
                    attribute.addImageListAttributeItem(ImageListAttribute.ImageListAttributeItemType.group, ((LaunchPermissionItemType)item).getGroup());
                    continue;
                }
                if (((LaunchPermissionItemType)item).getUserId() == null) continue;
                attribute.addImageListAttributeItem(ImageListAttribute.ImageListAttributeItemType.userId, ((LaunchPermissionItemType)item).getUserId());
            }
        } else if (response.getProductCodes() != null) {
            list = response.getProductCodes();
            attribute = new ProductCodesAttribute();
            i = ((ProductCodeListType)list).getItems().listIterator();
            while (i.hasNext()) {
                item = (ProductCodeItemType)i.next();
                if (((ProductCodeItemType)item).getProductCode() == null) continue;
                attribute.addImageListAttributeItem(ImageListAttribute.ImageListAttributeItemType.productCode, ((ProductCodeItemType)item).getProductCode());
            }
        }
        ArrayList<String> codes = new ArrayList<String>();
        ProductCodeListType set = response.getProductCodes();
        if (set != null) {
            for (ProductCodeItemType code : set.getItems()) {
                codes.add(code.getProductCode());
            }
        }
        String kernel = (val = response.getKernel()) != null ? val.getValue() : "";
        val = response.getRamdisk();
        String ramdisk = val != null ? val.getValue() : "";
        ArrayList<BlockDeviceMapping> bdm = new ArrayList<BlockDeviceMapping>();
        BlockDeviceMappingType bdmSet = response.getBlockDeviceMapping();
        if (bdmSet != null) {
            for (BlockDeviceMappingItemType mapping : bdmSet.getItems()) {
                bdm.add(new BlockDeviceMapping(mapping.getVirtualName(), mapping.getDeviceName()));
            }
        }
        return new DescribeImageAttributeResult(response.getImageId(), attribute, codes, kernel, ramdisk, bdm);
    }

    public ProductInstanceInfo confirmProductInstance(String instanceId, String productCode) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        params.put("ProductCode", productCode);
        HttpGet method = new HttpGet();
        ConfirmProductInstanceResponse response = this.makeRequestInt((HttpRequestBase)method, "ConfirmProductInstance", params, ConfirmProductInstanceResponse.class);
        if (response.isReturn()) {
            return new ProductInstanceInfo(instanceId, productCode, response.getOwnerId());
        }
        return null;
    }

    public List<AvailabilityZone> describeAvailabilityZones(List<String> zones) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (zones != null && zones.size() > 0) {
            for (int i = 0; i < zones.size(); ++i) {
                params.put("ZoneName." + (i + 1), zones.get(i));
            }
        }
        HttpGet method = new HttpGet();
        DescribeAvailabilityZonesResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeAvailabilityZones", params, DescribeAvailabilityZonesResponse.class);
        ArrayList<AvailabilityZone> ret = new ArrayList<AvailabilityZone>();
        AvailabilityZoneSetType set = response.getAvailabilityZoneInfo();
        for (AvailabilityZoneItemType item : set.getItems()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (AvailabilityZoneMessageType msg : item.getMessageSet().getItems()) {
                messages.add(msg.getMessage());
            }
            ret.add(new AvailabilityZone(item.getZoneName(), item.getZoneState(), item.getRegionName(), messages));
        }
        return ret;
    }

    public List<AddressInfo> describeAddresses(List<String> addresses) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (addresses != null && addresses.size() > 0) {
            for (int i = 0; i < addresses.size(); ++i) {
                params.put("PublicIp." + (i + 1), addresses.get(i));
            }
        }
        HttpGet method = new HttpGet();
        DescribeAddressesResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeAddresses", params, DescribeAddressesResponse.class);
        ArrayList<AddressInfo> ret = new ArrayList<AddressInfo>();
        DescribeAddressesResponseInfoType set = response.getAddressesSet();
        for (DescribeAddressesResponseItemType item : set.getItems()) {
            ret.add(new AddressInfo(item.getPublicIp(), item.getInstanceId()));
        }
        return ret;
    }

    public String allocateAddress() throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        HttpGet method = new HttpGet();
        AllocateAddressResponse response = this.makeRequestInt((HttpRequestBase)method, "AllocateAddress", params, AllocateAddressResponse.class);
        return response.getPublicIp();
    }

    public void associateAddress(String instanceId, String publicIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        params.put("PublicIp", publicIp);
        HttpGet method = new HttpGet();
        AssociateAddressResponse response = this.makeRequestInt((HttpRequestBase)method, "AssociateAddress", params, AssociateAddressResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not associate address with instance (no reason given).");
        }
    }

    public void disassociateAddress(String publicIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PublicIp", publicIp);
        HttpGet method = new HttpGet();
        DisassociateAddressResponse response = this.makeRequestInt((HttpRequestBase)method, "DisassociateAddress", params, DisassociateAddressResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not disassociate address with instance (no reason given).");
        }
    }

    public void releaseAddress(String publicIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PublicIp", publicIp);
        HttpGet method = new HttpGet();
        ReleaseAddressResponse response = this.makeRequestInt((HttpRequestBase)method, "ReleaseAddress", params, ReleaseAddressResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not release address (no reason given).");
        }
    }

    public VolumeInfo createVolume(String size, String snapshotId, String zoneName) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (size != null && !size.equals("")) {
            params.put("Size", size);
        }
        if (snapshotId != null && !snapshotId.equals("")) {
            params.put("SnapshotId", snapshotId);
        }
        params.put("AvailabilityZone", zoneName);
        HttpGet method = new HttpGet();
        CreateVolumeResponse response = this.makeRequestInt((HttpRequestBase)method, "CreateVolume", params, CreateVolumeResponse.class);
        return new VolumeInfo(response.getVolumeId(), response.getSize(), response.getSnapshotId(), response.getAvailabilityZone(), response.getStatus(), response.getCreateTime().toGregorianCalendar());
    }

    public void deleteVolume(String volumeId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("VolumeId", volumeId);
        HttpGet method = new HttpGet();
        DeleteVolumeResponse response = this.makeRequestInt((HttpRequestBase)method, "DeleteVolume", params, DeleteVolumeResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not release delete volume (no reason given).");
        }
    }

    public List<VolumeInfo> describeVolumes(String[] volumeIds) throws EC2Exception {
        return this.describeVolumes(Arrays.asList(volumeIds));
    }

    public List<VolumeInfo> describeVolumes(List<String> volumeIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < volumeIds.size(); ++i) {
            params.put("VolumeId." + (i + 1), volumeIds.get(i));
        }
        HttpGet method = new HttpGet();
        DescribeVolumesResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeVolumes", params, DescribeVolumesResponse.class);
        ArrayList<VolumeInfo> result = new ArrayList<VolumeInfo>();
        DescribeVolumesSetResponseType res_set = response.getVolumeSet();
        for (DescribeVolumesSetItemResponseType item : res_set.getItems()) {
            VolumeInfo vol = new VolumeInfo(item.getVolumeId(), item.getSize(), item.getSnapshotId(), item.getAvailabilityZone(), item.getStatus(), item.getCreateTime().toGregorianCalendar());
            AttachmentSetResponseType set = item.getAttachmentSet();
            for (AttachmentSetItemResponseType as_item : set.getItems()) {
                vol.addAttachmentInfo(as_item.getVolumeId(), as_item.getInstanceId(), as_item.getDevice(), as_item.getStatus(), as_item.getAttachTime().toGregorianCalendar());
            }
            result.add(vol);
        }
        return result;
    }

    public AttachmentInfo attachVolume(String volumeId, String instanceId, String device) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("VolumeId", volumeId);
        params.put("InstanceId", instanceId);
        params.put("Device", device);
        HttpGet method = new HttpGet();
        AttachVolumeResponse response = this.makeRequestInt((HttpRequestBase)method, "AttachVolume", params, AttachVolumeResponse.class);
        return new AttachmentInfo(response.getVolumeId(), response.getInstanceId(), response.getDevice(), response.getStatus(), response.getAttachTime().toGregorianCalendar());
    }

    public AttachmentInfo detachVolume(String volumeId, String instanceId, String device, boolean force) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("VolumeId", volumeId);
        params.put("InstanceId", instanceId == null ? "" : instanceId);
        if (device != null && !device.equals("")) {
            params.put("Device", device);
        }
        params.put("Force", force ? "true" : "false");
        HttpGet method = new HttpGet();
        DetachVolumeResponse response = this.makeRequestInt((HttpRequestBase)method, "DetachVolume", params, DetachVolumeResponse.class);
        return new AttachmentInfo(response.getVolumeId(), response.getInstanceId(), response.getDevice(), response.getStatus(), response.getAttachTime().toGregorianCalendar());
    }

    public SnapshotInfo createSnapshot(String volumeId, String description) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("VolumeId", volumeId);
        params.put("Description", description);
        HttpGet method = new HttpGet();
        CreateSnapshotResponse response = this.makeRequestInt((HttpRequestBase)method, "CreateSnapshot", params, CreateSnapshotResponse.class);
        return new SnapshotInfo(response.getSnapshotId(), response.getVolumeId(), response.getStatus(), response.getStartTime().toGregorianCalendar(), response.getProgress(), response.getOwnerId(), response.getVolumeSize(), response.getDescription(), null);
    }

    public void deleteSnapshot(String snapshotId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SnapshotId", snapshotId);
        HttpGet method = new HttpGet();
        DeleteSnapshotResponse response = this.makeRequestInt((HttpRequestBase)method, "DeleteSnapshot", params, DeleteSnapshotResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not release delete snapshot (no reason given).");
        }
    }

    public List<SnapshotInfo> describeSnapshots(String[] snapshotIds) throws EC2Exception {
        return this.describeSnapshots(Arrays.asList(snapshotIds));
    }

    public List<SnapshotInfo> describeSnapshots(List<String> snapshotIds) throws EC2Exception {
        return this.describeSnapshots(snapshotIds, null, null);
    }

    public List<SnapshotInfo> describeSnapshots(List<String> snapshotIds, String owner, String restorableBy) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < snapshotIds.size(); ++i) {
            params.put("SnapshotId." + (i + 1), snapshotIds.get(i));
        }
        if (owner != null) {
            params.put("Owner", owner);
        }
        if (restorableBy != null) {
            params.put("RestorableBy", owner);
        }
        HttpGet method = new HttpGet();
        DescribeSnapshotsResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeSnapshots", params, DescribeSnapshotsResponse.class);
        ArrayList<SnapshotInfo> result = new ArrayList<SnapshotInfo>();
        DescribeSnapshotsSetResponseType res_set = response.getSnapshotSet();
        for (DescribeSnapshotsSetItemResponseType item : res_set.getItems()) {
            SnapshotInfo vol = new SnapshotInfo(item.getSnapshotId(), item.getVolumeId(), item.getStatus(), item.getStartTime().toGregorianCalendar(), item.getProgress(), item.getOwnerId(), item.getVolumeSize(), item.getDescription(), item.getOwnerAlias());
            result.add(vol);
        }
        return result;
    }

    public void modifySnapshotAttribute(String snapshotId, String attribute, OperationType opType, String userId, String userGroup) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SnapshotId", snapshotId);
        if (userId != null) {
            params.put("UserId", userId);
        }
        if (userGroup != null) {
            params.put("UserGroup", userGroup);
        }
        params.put("Attribute", attribute);
        params.put("OperationType", opType.getTypeId());
        HttpGet method = new HttpGet();
        ModifySnapshotAttributeResponse response = this.makeRequestInt((HttpRequestBase)method, "ModifySnapshotAttribute", params, ModifySnapshotAttributeResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not modify snapshot attribute : " + attribute + ". No reason given.");
        }
    }

    public void resetSnapshotAttribute(String snapshotId, String attribute) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SnapshotId", snapshotId);
        params.put("Attribute", attribute);
        HttpGet method = new HttpGet();
        ResetSnapshotAttributeResponse response = this.makeRequestInt((HttpRequestBase)method, "ResetSnapshotAttribute", params, ResetSnapshotAttributeResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not reset snapshot attribute. No reason given.");
        }
    }

    public DescribeSnapshotAttributeResult describeSnapshotAttribute(String snapshotId, String attribute) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SnapshotId", snapshotId);
        params.put("Attribute", attribute);
        HttpGet method = new HttpGet();
        DescribeSnapshotAttributeResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeSnapshotAttribute", params, DescribeSnapshotAttributeResponse.class);
        DescribeSnapshotAttributeResult ret = new DescribeSnapshotAttributeResult(response.getSnapshotId());
        List<CreateVolumePermissionItemType> list = response.getCreateVolumePermission().getItems();
        if (list != null) {
            for (CreateVolumePermissionItemType item : list) {
                ret.addCreateVolumePermission(item.getUserId(), item.getGroup());
            }
        }
        return ret;
    }

    public List<RegionInfo> describeRegions(List<String> regions) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (regions != null && regions.size() > 0) {
            for (int i = 0; i < regions.size(); ++i) {
                params.put("Region." + (i + 1), regions.get(i));
            }
        }
        HttpGet method = new HttpGet();
        DescribeRegionsResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeRegions", params, DescribeRegionsResponse.class);
        ArrayList<RegionInfo> ret = new ArrayList<RegionInfo>();
        RegionSetType set = response.getRegionInfo();
        for (RegionItemType item : set.getItems()) {
            ret.add(new RegionInfo(item.getRegionName(), item.getRegionEndpoint()));
        }
        return ret;
    }

    public void setRegion(RegionInfo region) {
        this.setServer(region.getUrl());
    }

    public void setRegionUrl(String regionUrl) {
        this.setServer(regionUrl);
    }

    public BundleInstanceInfo bundleInstance(String instanceId, String accessId, String bucketName, String prefix, UploadPolicy policy) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        params.put("Storage.S3.AWSAccessKeyId", accessId);
        params.put("Storage.S3.Bucket", bucketName);
        params.put("Storage.S3.Prefix", prefix);
        String jsonPolicy = policy.getPolicyString();
        params.put("Storage.S3.UploadPolicy", jsonPolicy);
        params.put("Storage.S3.UploadPolicySignature", this.encode(this.getSecretAccessKey(), jsonPolicy, false, "HmacSHA1"));
        HttpGet method = new HttpGet();
        BundleInstanceResponse response = this.makeRequestInt((HttpRequestBase)method, "BundleInstance", params, BundleInstanceResponse.class);
        BundleInstanceTaskType task = response.getBundleInstanceTask();
        return new BundleInstanceInfo(response.getRequestId(), task.getInstanceId(), task.getBundleId(), task.getState(), task.getStartTime().toGregorianCalendar(), task.getUpdateTime().toGregorianCalendar(), task.getStorage(), task.getProgress(), task.getError());
    }

    public BundleInstanceInfo cancelBundleInstance(String bundleId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("BundleId", bundleId);
        HttpGet method = new HttpGet();
        CancelBundleTaskResponse response = this.makeRequestInt((HttpRequestBase)method, "CancelBundleTask", params, CancelBundleTaskResponse.class);
        BundleInstanceTaskType task = response.getBundleInstanceTask();
        return new BundleInstanceInfo(response.getRequestId(), task.getInstanceId(), task.getBundleId(), task.getState(), task.getStartTime().toGregorianCalendar(), task.getUpdateTime().toGregorianCalendar(), task.getStorage(), task.getProgress(), task.getError());
    }

    public List<BundleInstanceInfo> describeBundleTasks(String[] bundleIds) throws EC2Exception {
        return this.describeBundleTasks(Arrays.asList(bundleIds));
    }

    public List<BundleInstanceInfo> describeBundleTasks(List<String> bundleIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < bundleIds.size(); ++i) {
            params.put("BundleId." + (i + 1), bundleIds.get(i));
        }
        HttpGet method = new HttpGet();
        DescribeBundleTasksResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeBundleTasks", params, DescribeBundleTasksResponse.class);
        ArrayList<BundleInstanceInfo> ret = new ArrayList<BundleInstanceInfo>();
        for (BundleInstanceTaskType task : response.getBundleInstanceTasksSet().getItems()) {
            ret.add(new BundleInstanceInfo(response.getRequestId(), task.getInstanceId(), task.getBundleId(), task.getState(), task.getStartTime().toGregorianCalendar(), task.getUpdateTime().toGregorianCalendar(), task.getStorage(), task.getProgress(), task.getError()));
        }
        return ret;
    }

    public List<ReservedInstances> describeReservedInstances(List<String> instanceIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (instanceIds != null) {
            for (int i = 0; i < instanceIds.size(); ++i) {
                params.put("ReservedInstanceId." + (i + 1), instanceIds.get(i));
            }
        }
        HttpGet method = new HttpGet();
        DescribeReservedInstancesResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeReservedInstances", params, DescribeReservedInstancesResponse.class);
        ArrayList<ReservedInstances> ret = new ArrayList<ReservedInstances>();
        for (DescribeReservedInstancesResponseSetItemType type : response.getReservedInstancesSet().getItems()) {
            ret.add(new ReservedInstances(type.getReservedInstancesId(), InstanceType.getTypeFromString(type.getInstanceType()), type.getAvailabilityZone(), type.getStart().toGregorianCalendar(), type.getDuration(), type.getFixedPrice(), type.getUsagePrice(), type.getProductDescription(), type.getInstanceCount().intValue(), type.getState()));
        }
        return ret;
    }

    public List<ProductDescription> describeReservedInstancesOfferings(List<String> offeringIds, InstanceType instanceType, String availabilityZone, String productDescription) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (offeringIds != null) {
            for (int i = 0; i < offeringIds.size(); ++i) {
                params.put("ReservedInstancesOfferingId." + (i + 1), offeringIds.get(i));
            }
        }
        if (instanceType != null) {
            params.put("InstanceType", instanceType.getTypeId());
        }
        if (availabilityZone != null) {
            params.put("AvailabilityZone", availabilityZone);
        }
        if (productDescription != null) {
            params.put("ProductDescription", productDescription);
        }
        HttpGet method = new HttpGet();
        DescribeReservedInstancesOfferingsResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeReservedInstancesOfferings", params, DescribeReservedInstancesOfferingsResponse.class);
        ArrayList<ProductDescription> ret = new ArrayList<ProductDescription>();
        for (DescribeReservedInstancesOfferingsResponseSetItemType type : response.getReservedInstancesOfferingsSet().getItems()) {
            ret.add(new ProductDescription(type.getReservedInstancesOfferingId(), InstanceType.getTypeFromString(type.getInstanceType()), type.getAvailabilityZone(), type.getDuration(), type.getFixedPrice(), type.getUsagePrice(), type.getProductDescription()));
        }
        return ret;
    }

    public String purchaseReservedInstancesOffering(String offeringId, int instanceCount) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ReservedInstancesOfferingId", offeringId);
        params.put("InstanceCount", "" + instanceCount);
        HttpGet method = new HttpGet();
        PurchaseReservedInstancesOfferingResponse response = this.makeRequestInt((HttpRequestBase)method, "PurchaseReservedInstancesOffering", params, PurchaseReservedInstancesOfferingResponse.class);
        return response.getReservedInstancesId();
    }

    public List<MonitoredInstanceInfo> monitorInstances(List<String> instanceIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < instanceIds.size(); ++i) {
            params.put("InstanceId." + (i + 1), instanceIds.get(i));
        }
        HttpGet method = new HttpGet();
        MonitorInstancesResponseType response = this.makeRequestInt((HttpRequestBase)method, "MonitorInstances", params, MonitorInstancesResponseType.class);
        ArrayList<MonitoredInstanceInfo> ret = new ArrayList<MonitoredInstanceInfo>();
        for (MonitorInstancesResponseSetItemType item : response.getInstancesSet().getItems()) {
            ret.add(new MonitoredInstanceInfo(item.getInstanceId(), item.getMonitoring().getState()));
        }
        return ret;
    }

    public List<MonitoredInstanceInfo> unmonitorInstances(List<String> instanceIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < instanceIds.size(); ++i) {
            params.put("InstanceId." + (i + 1), instanceIds.get(i));
        }
        HttpGet method = new HttpGet();
        MonitorInstancesResponseType response = this.makeRequestInt((HttpRequestBase)method, "UnmonitorInstances", params, MonitorInstancesResponseType.class);
        ArrayList<MonitoredInstanceInfo> ret = new ArrayList<MonitoredInstanceInfo>();
        for (MonitorInstancesResponseSetItemType item : response.getInstancesSet().getItems()) {
            ret.add(new MonitoredInstanceInfo(item.getInstanceId(), item.getMonitoring().getState()));
        }
        return ret;
    }

    public List<SpotPriceHistoryItem> describeSpotPriceHistory(Calendar start, Calendar end, String productDescription, InstanceType ... instanceTypes) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (start != null) {
            params.put("StartTime", this.httpDate(start));
        }
        if (end != null) {
            params.put("EndTime", this.httpDate(end));
        }
        if (productDescription != null) {
            params.put("ProductDescription", productDescription);
        }
        for (int i = 0; i < instanceTypes.length; ++i) {
            InstanceType instanceType = instanceTypes[i];
            params.put("InstanceType." + (i + 1), instanceType.getTypeId());
        }
        HttpGet method = new HttpGet();
        ArrayList<SpotPriceHistoryItem> ret = new ArrayList<SpotPriceHistoryItem>();
        DescribeSpotPriceHistoryResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeSpotPriceHistory", params, DescribeSpotPriceHistoryResponse.class);
        List<SpotPriceHistorySetItemType> items = response.getSpotPriceHistorySet().getItems();
        if (items != null) {
            for (SpotPriceHistorySetItemType item : items) {
                ret.add(new SpotPriceHistoryItem(item));
            }
        }
        return ret;
    }

    public List<SpotInstanceRequest> describeSpotInstanceRequests() throws EC2Exception {
        HttpGet method = new HttpGet();
        ArrayList<SpotInstanceRequest> ret = new ArrayList<SpotInstanceRequest>();
        DescribeSpotInstanceRequestsResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeSpotInstanceRequests", null, DescribeSpotInstanceRequestsResponse.class);
        List<SpotInstanceRequestSetItemType> items = response.getSpotInstanceRequestSet().getItems();
        if (items != null) {
            for (SpotInstanceRequestSetItemType item : items) {
                ret.add(new SpotInstanceRequest(item));
            }
        }
        return ret;
    }

    public List<SpotInstanceRequest> requestSpotInstances(SpotInstanceRequestConfiguration sirc, LaunchConfiguration lc) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        lc.prepareQueryParams("LaunchSpecification.", false, params);
        sirc.prepareQueryParams(params);
        HttpGet method = new HttpGet();
        ArrayList<SpotInstanceRequest> ret = new ArrayList<SpotInstanceRequest>();
        RequestSpotInstancesResponse response = this.makeRequestInt((HttpRequestBase)method, "RequestSpotInstances", params, RequestSpotInstancesResponse.class);
        List<SpotInstanceRequestSetItemType> items = response.getSpotInstanceRequestSet().getItems();
        if (items != null) {
            for (SpotInstanceRequestSetItemType item : items) {
                ret.add(new SpotInstanceRequest(item));
            }
        }
        return ret;
    }

    public List<SpotInstanceCancellationResponse> cancelSpotInstanceRequests(String ... sirIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < sirIds.length; ++i) {
            params.put("SpotInstanceRequestId." + (i + 1), sirIds[i]);
        }
        HttpGet method = new HttpGet();
        ArrayList<SpotInstanceCancellationResponse> ret = new ArrayList<SpotInstanceCancellationResponse>();
        CancelSpotInstanceRequestsResponse response = this.makeRequestInt((HttpRequestBase)method, "CancelSpotInstanceRequests", params, CancelSpotInstanceRequestsResponse.class);
        List<CancelSpotInstanceRequestsResponseSetItemType> items = response.getSpotInstanceRequestSet().getItems();
        if (items != null) {
            for (CancelSpotInstanceRequestsResponseSetItemType item : items) {
                ret.add(new SpotInstanceCancellationResponse(item));
            }
        }
        return ret;
    }

    public SpotDatafeedSubscription createSpotDatafeedSubscription(String bucket, String prefix) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Bucket", bucket);
        if (prefix != null && !prefix.trim().equals("")) {
            params.put("Prefix", prefix);
        }
        HttpGet method = new HttpGet();
        CreateSpotDatafeedSubscriptionResponse response = this.makeRequestInt((HttpRequestBase)method, "CreateSpotDatafeedSubscription", params, CreateSpotDatafeedSubscriptionResponse.class);
        return new SpotDatafeedSubscription(response.getRequestId(), response.getSpotDatafeedSubscription());
    }

    public SpotDatafeedSubscription describeSpotDatafeedSubscription() throws EC2Exception {
        HttpGet method = new HttpGet();
        DescribeSpotDatafeedSubscriptionResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeSpotDatafeedSubscription", null, DescribeSpotDatafeedSubscriptionResponse.class);
        return new SpotDatafeedSubscription(response.getRequestId(), response.getSpotDatafeedSubscription());
    }

    public void deleteSpotDatafeedSubscription() throws EC2Exception {
        HttpGet method = new HttpGet();
        DeleteSpotDatafeedSubscriptionResponse response = this.makeRequestInt((HttpRequestBase)method, "DeleteSpotDatafeedSubscription", null, DeleteSpotDatafeedSubscriptionResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not delete subscription. No reason given.");
        }
    }

    public void createPlacementGroup(String groupName, String strategy) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GropuName", groupName);
        params.put("Stategy", strategy);
        HttpGet method = new HttpGet();
        CreatePlacementGroupResponse response = this.makeRequestInt((HttpRequestBase)method, "CreatePlacementGroup", params, CreatePlacementGroupResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not create placement group. No reason given.");
        }
    }

    public void deletePlacementGroup(String groupName) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GropuName", groupName);
        HttpGet method = new HttpGet();
        DeletePlacementGroupResponse response = this.makeRequestInt((HttpRequestBase)method, "DeletePlacementGroup", params, DeletePlacementGroupResponse.class);
        if (!response.isReturn()) {
            throw new EC2Exception("Could not delete placement group. No reason given.");
        }
    }

    public List<PlacementGroupInfo> describePlacementGroups(List<String> groupNames) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < groupNames.size(); ++i) {
            params.put("GroupName." + (i + 1), groupNames.get(i));
        }
        HttpGet method = new HttpGet();
        DescribePlacementGroupsResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribePlacementGroups", params, DescribePlacementGroupsResponse.class);
        ArrayList<PlacementGroupInfo> ret = new ArrayList<PlacementGroupInfo>();
        List<PlacementGroupInfoType> items = response.getPlacementGroupSet().getItems();
        if (items != null) {
            for (PlacementGroupInfoType item : items) {
                ret.add(new PlacementGroupInfo(response.getRequestId(), item.getGroupName(), item.getStrategy(), item.getState()));
            }
        }
        return ret;
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws EC2Exception {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new EC2Exception(ex);
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new EC2Exception("Problem parsing returned message.", ex);
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (HttpException ex) {
            throw new EC2Exception(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageListAttributeOperationType {
        add,
        remove;

    }
}

