/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.ec2.HealthCheck;
import com.xerox.amazonws.ec2.InstanceState;
import com.xerox.amazonws.ec2.Listener;
import com.xerox.amazonws.ec2.LoadBalancer;
import com.xerox.amazonws.ec2.LoadBalancingException;
import com.xerox.amazonws.typica.loadbalance.jaxb.ConfigureHealthCheckResponse;
import com.xerox.amazonws.typica.loadbalance.jaxb.CreateLoadBalancerResponse;
import com.xerox.amazonws.typica.loadbalance.jaxb.DeleteLoadBalancerResponse;
import com.xerox.amazonws.typica.loadbalance.jaxb.DeregisterInstancesFromLoadBalancerResponse;
import com.xerox.amazonws.typica.loadbalance.jaxb.DescribeInstanceHealthResponse;
import com.xerox.amazonws.typica.loadbalance.jaxb.DescribeLoadBalancersResponse;
import com.xerox.amazonws.typica.loadbalance.jaxb.DisableAvailabilityZonesForLoadBalancerResponse;
import com.xerox.amazonws.typica.loadbalance.jaxb.EnableAvailabilityZonesForLoadBalancerResponse;
import com.xerox.amazonws.typica.loadbalance.jaxb.Instance;
import com.xerox.amazonws.typica.loadbalance.jaxb.LoadBalancerDescription;
import com.xerox.amazonws.typica.loadbalance.jaxb.RegisterInstancesWithLoadBalancerResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancing
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(LoadBalancing.class);

    public LoadBalancing(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public LoadBalancing(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "elasticloadbalancing.amazonaws.com");
    }

    public LoadBalancing(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public LoadBalancing(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2009-05-15");
        this.headers.put("Version", vals);
    }

    public List<String> enableAvailabilityZonesForLoadBalancer(String loadBalancerName, List<String> availabilityZones) throws LoadBalancingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LoadBalancerName", loadBalancerName);
        int i = 0;
        for (String zone : availabilityZones) {
            params.put("AvailabilityZones.member." + (i + 1), zone);
            ++i;
        }
        HttpGet method = new HttpGet();
        EnableAvailabilityZonesForLoadBalancerResponse response = this.makeRequestInt((HttpRequestBase)method, "EnableAvailabilityZonesForLoadBalancer", params, EnableAvailabilityZonesForLoadBalancerResponse.class);
        return response.getEnableAvailabilityZonesForLoadBalancerResult().getAvailabilityZones().getMembers();
    }

    public String createLoadBalancer(String loadBalancerName, List<Listener> listeners, List<String> availabilityZones) throws LoadBalancingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LoadBalancerName", loadBalancerName);
        int i = 1;
        for (Listener l : listeners) {
            params.put("Listeners.member." + i + ".Protocol", l.getProtocol());
            params.put("Listeners.member." + i + ".LoadBalancerPort", "" + l.getLoadBalancerPort());
            params.put("Listeners.member." + i + ".InstancePort", "" + l.getInstancePort());
        }
        i = 1;
        for (String zone : availabilityZones) {
            params.put("AvailabilityZones.member." + i, zone);
            ++i;
        }
        HttpGet method = new HttpGet();
        CreateLoadBalancerResponse response = this.makeRequestInt((HttpRequestBase)method, "CreateLoadBalancer", params, CreateLoadBalancerResponse.class);
        return response.getCreateLoadBalancerResult().getDNSName();
    }

    public HealthCheck configureHealthCheck(String loadBalancerName, HealthCheck healthCheck) throws LoadBalancingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LoadBalancerName", loadBalancerName);
        params.put("HealthCheck.Target", "" + healthCheck.getTarget());
        params.put("HealthCheck.Interval", "" + healthCheck.getInterval());
        params.put("HealthCheck.Timeout", "" + healthCheck.getTimeout());
        params.put("HealthCheck.UnhealthyThreshold", "" + healthCheck.getUnhealthyThreshold());
        params.put("HealthCheck.HealthyThreshold", "" + healthCheck.getHealthyThreshold());
        HttpGet method = new HttpGet();
        ConfigureHealthCheckResponse response = this.makeRequestInt((HttpRequestBase)method, "ConfigureHealthCheck", params, ConfigureHealthCheckResponse.class);
        com.xerox.amazonws.typica.loadbalance.jaxb.HealthCheck hc = response.getConfigureHealthCheckResult().getHealthCheck();
        return new HealthCheck(hc.getTarget(), hc.getInterval().intValue(), hc.getTimeout().intValue(), hc.getUnhealthyThreshold().intValue(), hc.getHealthyThreshold().intValue());
    }

    public void deleteLoadBalancer(String loadBalancerName) throws LoadBalancingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LoadBalancerName", loadBalancerName);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "DeleteLoadBalancer", params, DeleteLoadBalancerResponse.class);
    }

    public List<String> deregisterInstancesFromLoadBalancer(String loadBalancerName, List<String> instances) throws LoadBalancingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LoadBalancerName", loadBalancerName);
        int i = 1;
        for (String inst : instances) {
            params.put("Instances.member." + i + ".InstanceId", inst);
            ++i;
        }
        HttpGet method = new HttpGet();
        DeregisterInstancesFromLoadBalancerResponse response = this.makeRequestInt((HttpRequestBase)method, "DeregisterInstancesFromLoadBalancer", params, DeregisterInstancesFromLoadBalancerResponse.class);
        List<Instance> instList = response.getDeregisterInstancesFromLoadBalancerResult().getInstances().getMembers();
        ArrayList<String> ret = new ArrayList<String>();
        for (Instance inst : instList) {
            ret.add(inst.getInstanceId());
        }
        return ret;
    }

    public List<LoadBalancer> describeLoadBalancers() throws LoadBalancingException {
        return this.describeLoadBalancers(null);
    }

    public List<LoadBalancer> describeLoadBalancers(List<String> loadBalancerNames) throws LoadBalancingException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (loadBalancerNames != null && loadBalancerNames.size() > 0) {
            int i = 0;
            for (String name : loadBalancerNames) {
                params.put("LoadBalancerNames.member." + (i + 1), name);
                ++i;
            }
        }
        HttpGet method = new HttpGet();
        DescribeLoadBalancersResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeLoadBalancers", params, DescribeLoadBalancersResponse.class);
        List<LoadBalancerDescription> result = response.getDescribeLoadBalancersResult().getLoadBalancerDescriptions().getMembers();
        ArrayList<LoadBalancer> ret = new ArrayList<LoadBalancer>();
        for (LoadBalancerDescription lb : result) {
            List<Instance> instList = lb.getInstances().getMembers();
            ArrayList<String> instances = new ArrayList<String>();
            for (Instance inst : instList) {
                instances.add(inst.getInstanceId());
            }
            List<com.xerox.amazonws.typica.loadbalance.jaxb.Listener> listenerList = lb.getListeners().getMembers();
            ArrayList<Listener> listeners = new ArrayList<Listener>();
            for (com.xerox.amazonws.typica.loadbalance.jaxb.Listener listnr : listenerList) {
                listeners.add(new Listener(listnr.getProtocol(), listnr.getLoadBalancerPort().intValue(), listnr.getInstancePort().intValue()));
            }
            com.xerox.amazonws.typica.loadbalance.jaxb.HealthCheck hc = lb.getHealthCheck();
            HealthCheck healthCheck = new HealthCheck(hc.getTarget(), hc.getInterval().intValue(), hc.getTimeout().intValue(), hc.getUnhealthyThreshold().intValue(), hc.getHealthyThreshold().intValue());
            LoadBalancer newPoint = new LoadBalancer(lb.getLoadBalancerName(), lb.getDNSName(), listeners, lb.getAvailabilityZones().getMembers(), instances, healthCheck, lb.getCreatedTime().toGregorianCalendar());
            ret.add(newPoint);
        }
        return ret;
    }

    public List<InstanceState> describeInstanceHealth(String loadBalancerName) throws LoadBalancingException {
        return this.describeInstanceHealth(loadBalancerName, null);
    }

    public List<InstanceState> describeInstanceHealth(String loadBalancerName, List<String> instances) throws LoadBalancingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LoadBalancerName", loadBalancerName);
        if (instances != null && instances.size() > 0) {
            int i = 1;
            for (String name : instances) {
                params.put("Instances.member." + i + ".InstanceId", name);
                ++i;
            }
        }
        HttpGet method = new HttpGet();
        DescribeInstanceHealthResponse response = this.makeRequestInt((HttpRequestBase)method, "DescribeInstanceHealth", params, DescribeInstanceHealthResponse.class);
        List<com.xerox.amazonws.typica.loadbalance.jaxb.InstanceState> result = response.getDescribeInstanceHealthResult().getInstanceStates().getMembers();
        ArrayList<InstanceState> ret = new ArrayList<InstanceState>();
        for (com.xerox.amazonws.typica.loadbalance.jaxb.InstanceState state : result) {
            InstanceState newState = new InstanceState(state.getInstanceId(), state.getState(), state.getReasonCode(), state.getDescription());
            ret.add(newState);
        }
        return ret;
    }

    public List<String> registerInstancesWithLoadBalancer(String loadBalancerName, List<String> instances) throws LoadBalancingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LoadBalancerName", loadBalancerName);
        int i = 1;
        for (String inst : instances) {
            params.put("Instances.member." + i + ".InstanceId", inst);
            ++i;
        }
        HttpGet method = new HttpGet();
        RegisterInstancesWithLoadBalancerResponse response = this.makeRequestInt((HttpRequestBase)method, "RegisterInstancesWithLoadBalancer", params, RegisterInstancesWithLoadBalancerResponse.class);
        List<Instance> instList = response.getRegisterInstancesWithLoadBalancerResult().getInstances().getMembers();
        ArrayList<String> ret = new ArrayList<String>();
        for (Instance inst : instList) {
            ret.add(inst.getInstanceId());
        }
        return ret;
    }

    public List<String> disableAvailabilityZonesForLoadBalancer(String loadBalancerName, List<String> availabilityZones) throws LoadBalancingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LoadBalancerName", loadBalancerName);
        int i = 0;
        for (String zone : availabilityZones) {
            params.put("AvailabilityZones.member." + (i + 1), zone);
            ++i;
        }
        HttpGet method = new HttpGet();
        DisableAvailabilityZonesForLoadBalancerResponse response = this.makeRequestInt((HttpRequestBase)method, "DisableAvailabilityZonesForLoadBalancer", params, DisableAvailabilityZonesForLoadBalancerResponse.class);
        return response.getDisableAvailabilityZonesForLoadBalancerResult().getAvailabilityZones().getMembers();
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws LoadBalancingException {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new LoadBalancingException(ex);
        }
        catch (JAXBException ex) {
            throw new LoadBalancingException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new LoadBalancingException("Problem parsing returned message.", ex);
        }
        catch (MalformedURLException ex) {
            throw new LoadBalancingException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new LoadBalancingException(ex.getMessage(), ex);
        }
        catch (HttpException ex) {
            throw new LoadBalancingException(ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

