/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import com.xerox.amazonws.ec2.SpotInstanceState;
import com.xerox.amazonws.ec2.SpotInstanceType;
import com.xerox.amazonws.typica.jaxb.SpotInstanceRequestSetItemType;
import java.util.Calendar;

public class SpotInstanceRequest {
    protected String spotInstanceRequestId;
    protected double spotPrice;
    protected SpotInstanceType type;
    protected SpotInstanceState state;
    protected String launchGroup;
    protected String availabilityZoneGroup;
    protected String instanceId;
    protected Calendar createTime;
    protected String productDescription;

    public SpotInstanceRequest() {
    }

    SpotInstanceRequest(SpotInstanceRequestSetItemType item) {
        this.spotInstanceRequestId = item.getSpotInstanceRequestId();
        this.spotPrice = Double.parseDouble(item.getSpotPrice());
        this.type = SpotInstanceType.getTypeFromString(item.getType());
        this.state = SpotInstanceState.getStateFromString(item.getState());
        this.launchGroup = item.getLaunchGroup();
        this.availabilityZoneGroup = item.getAvailabilityZoneGroup();
        this.instanceId = item.getInstanceId();
        this.createTime = item.getCreateTime().toGregorianCalendar();
        this.productDescription = item.getProductDescription();
    }

    public String getSpotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public double getSpotPrice() {
        return this.spotPrice;
    }

    public SpotInstanceType getType() {
        return this.type;
    }

    public SpotInstanceState getState() {
        return this.state;
    }

    public String getLaunchGroup() {
        return this.launchGroup;
    }

    public String getAvailabilityZoneGroup() {
        return this.availabilityZoneGroup;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Calendar getCreateTime() {
        return this.createTime;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public String toString() {
        return "SpotInstanceRequest[spotInstanceRequestId='" + this.spotInstanceRequestId + '\'' + ", spotPrice=" + this.spotPrice + ", type='" + (Object)((Object)this.type) + '\'' + ", state=" + (Object)((Object)this.state) + ", launchGroup='" + this.launchGroup + '\'' + ", availabilityZoneGroup='" + this.availabilityZoneGroup + '\'' + ", instanceId='" + this.instanceId + '\'' + ", createTime=" + this.createTime + ", productDescription='" + this.productDescription + '\'' + ']';
    }
}

