/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import com.xerox.amazonws.ec2.SpotInstanceType;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpotInstanceRequestConfiguration {
    private double price;
    private int maxInstanceCount = 1;
    private SpotInstanceType type = SpotInstanceType.ONE_TIME;
    private Calendar validFrom;
    private Calendar validUntil;
    private String launchGroup;
    private String availabilityZoneGroup;

    public SpotInstanceRequestConfiguration(double price, int maxInstanceCount, SpotInstanceType type) {
        this.price = price;
        this.maxInstanceCount = maxInstanceCount;
        this.type = type;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public int getMaxInstanceCount() {
        return this.maxInstanceCount;
    }

    public void setMaxInstanceCount(int maxInstanceCount) {
        this.maxInstanceCount = maxInstanceCount;
    }

    public SpotInstanceType getType() {
        return this.type;
    }

    public void setType(SpotInstanceType type) {
        this.type = type;
    }

    public Calendar getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Calendar validFrom) {
        this.validFrom = validFrom;
    }

    public Calendar getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Calendar validUntil) {
        this.validUntil = validUntil;
    }

    public String getLaunchGroup() {
        return this.launchGroup;
    }

    public void setLaunchGroup(String launchGroup) {
        this.launchGroup = launchGroup;
    }

    public String getAvailabilityZoneGroup() {
        return this.availabilityZoneGroup;
    }

    public void setAvailabilityZoneGroup(String availabilityZoneGroup) {
        this.availabilityZoneGroup = availabilityZoneGroup;
    }

    void prepareQueryParams(Map<String, String> params) {
        params.put("SpotPrice", "" + this.price);
        params.put("InstanceCount", "" + this.maxInstanceCount);
        params.put("Type", this.type.getAwsString());
        if (this.validFrom != null) {
            params.put("ValidFrom", this.validFrom.toString());
        }
        if (this.validUntil != null) {
            params.put("ValidUntil", this.validUntil.toString());
        }
        if (this.launchGroup != null) {
            params.put("LaunchGroup", this.launchGroup);
        }
        if (this.availabilityZoneGroup != null) {
            params.put("AvailabilityZoneGroup", this.availabilityZoneGroup);
        }
    }
}

