/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.typica.jaxb.SpotPriceHistorySetItemType;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpotPriceHistoryItem
implements Comparable<SpotPriceHistoryItem> {
    private InstanceType instanceType;
    private double price;
    private Calendar timestamp;
    private String productDescription;

    public SpotPriceHistoryItem() {
    }

    SpotPriceHistoryItem(SpotPriceHistorySetItemType item) {
        this.instanceType = InstanceType.getTypeFromString(item.getInstanceType());
        this.price = Double.parseDouble(item.getSpotPrice());
        this.timestamp = item.getTimestamp().toGregorianCalendar();
        this.productDescription = item.getProductDescription();
    }

    public InstanceType getInstanceType() {
        return this.instanceType;
    }

    public double getPrice() {
        return this.price;
    }

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    @Override
    public int compareTo(SpotPriceHistoryItem o) {
        return this.timestamp.compareTo(o.timestamp);
    }

    public String toString() {
        return "SpotPriceHistoryItem[instanceType=" + (Object)((Object)this.instanceType) + ", price=" + this.price + ", timestamp=" + this.timestamp.getTime().toString() + ", productDescription='" + this.productDescription + '\'' + ']';
    }
}

