/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.fps;

import com.xerox.amazonws.fps.Amount;
import com.xerox.amazonws.fps.FPSOperation;
import com.xerox.amazonws.fps.FlexiblePaymentsService;
import com.xerox.amazonws.fps.PaymentMethod;
import com.xerox.amazonws.fps.Transaction;
import com.xerox.amazonws.sdb.DataUtils;
import com.xerox.amazonws.typica.fps.jaxb.GetAccountActivityResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountActivity
implements Iterable<Transaction>,
Serializable {
    private BigInteger totalTransactions;
    private List<Transaction> transactions;
    private Date nextStartDate;
    private final FPSOperation filter;
    private final PaymentMethod paymentMethod;
    private final int maxBatchSize;
    private final Date endDate;
    private final Transaction.Status transactionStatus;
    private final FlexiblePaymentsService fps;

    public AccountActivity(Date nextStartDate, BigInteger totalTransactions, List<Transaction> transactions, FPSOperation filter, PaymentMethod paymentMethod, int maxBatchSize, Date endDate, Transaction.Status transactionStatus, FlexiblePaymentsService fps) {
        this.nextStartDate = nextStartDate;
        this.totalTransactions = totalTransactions;
        this.transactions = transactions;
        this.filter = filter;
        this.paymentMethod = paymentMethod;
        this.maxBatchSize = maxBatchSize;
        this.endDate = endDate;
        this.transactionStatus = transactionStatus;
        this.fps = fps;
    }

    public BigInteger getTotalTransactions() {
        return this.totalTransactions;
    }

    @Override
    public Iterator<Transaction> iterator() {
        return new AccountActivityIterator(this.nextStartDate, this.transactions, this.filter, this.paymentMethod, this.maxBatchSize, this.endDate, this.transactionStatus, this.fps);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AccountActivityIterator
    implements Iterator<Transaction> {
        private Iterator<Transaction> transactionsIterator;
        private Date nextStartDate;
        private final FPSOperation filter;
        private final PaymentMethod paymentMethod;
        private final int maxBatchSize;
        private final Date endDate;
        private final Transaction.Status transactionStatus;
        private final FlexiblePaymentsService fps;

        public AccountActivityIterator(Date nextStartDate, List<Transaction> transactions, FPSOperation filter, PaymentMethod paymentMethod, int maxBatchSize, Date endDate, Transaction.Status transactionStatus, FlexiblePaymentsService fps) {
            this.nextStartDate = nextStartDate;
            this.transactionsIterator = transactions.iterator();
            this.filter = filter;
            this.paymentMethod = paymentMethod;
            this.maxBatchSize = maxBatchSize;
            this.endDate = endDate;
            this.transactionStatus = transactionStatus;
            this.fps = fps;
        }

        @Override
        public boolean hasNext() {
            return this.transactionsIterator.hasNext() || this.nextStartDate != null;
        }

        @Override
        public Transaction next() {
            if (this.transactionsIterator.hasNext()) {
                return this.transactionsIterator.next();
            }
            if (this.nextStartDate == null) {
                throw new NoSuchElementException();
            }
            HttpGet method = new HttpGet();
            HashMap<String, String> params = new HashMap<String, String>();
            if (this.filter != null) {
                params.put("Operation", this.filter.value());
            }
            if (this.paymentMethod != null) {
                params.put("PaymentMethod", this.paymentMethod.value());
            }
            if (this.maxBatchSize != 0) {
                params.put("MaxBatchSize", Integer.toString(this.maxBatchSize));
            }
            params.put("StartDate", DataUtils.encodeDate(this.nextStartDate));
            if (this.endDate != null) {
                params.put("EndDate", DataUtils.encodeDate(this.endDate));
            }
            if (this.transactionStatus != null) {
                params.put("Status", this.transactionStatus.value());
            }
            try {
                GetAccountActivityResponse response = this.fps.makeRequestInt((HttpRequestBase)method, "GetAccountActivity", params, GetAccountActivityResponse.class);
                this.nextStartDate = response.getStartTimeForNextTransaction().toGregorianCalendar().getTime();
                AccountActivity.this.totalTransactions = response.getResponseBatchSize();
                List<com.xerox.amazonws.typica.fps.jaxb.Transaction> rawTransactions = response.getTransactions();
                ArrayList<Transaction> transactions = new ArrayList<Transaction>(rawTransactions.size());
                for (com.xerox.amazonws.typica.fps.jaxb.Transaction txn : rawTransactions) {
                    com.xerox.amazonws.typica.fps.jaxb.Amount txnAmount = txn.getTransactionAmount();
                    com.xerox.amazonws.typica.fps.jaxb.Amount fees = txn.getFees();
                    com.xerox.amazonws.typica.fps.jaxb.Amount balance = txn.getBalance();
                    transactions.add(new Transaction(txn.getTransactionId(), Transaction.Status.fromValue(txn.getStatus().value()), txn.getDateReceived().toGregorianCalendar().getTime(), txn.getDateCompleted().toGregorianCalendar().getTime(), new Amount(new BigDecimal(txnAmount.getAmount()), txnAmount.getCurrencyCode().toString()), FPSOperation.fromValue(txn.getOperation().value()), PaymentMethod.fromValue(txn.getPaymentMethod().value()), txn.getSenderName(), txn.getCallerName(), txn.getRecipientName(), new Amount(new BigDecimal(fees.getAmount()), fees.getCurrencyCode().toString()), new Amount(new BigDecimal(balance.getAmount()), balance.getCurrencyCode().toString()), txn.getCallerTokenId(), txn.getSenderTokenId(), txn.getRecipientTokenId()));
                }
                this.transactionsIterator = transactions.iterator();
            }
            catch (Exception e) {
                throw new NoSuchElementException(e.getMessage());
            }
            return this.transactionsIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

