/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.fps;

import com.xerox.amazonws.common.AWSError;
import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.fps.AccountActivity;
import com.xerox.amazonws.fps.AccountBalance;
import com.xerox.amazonws.fps.Address;
import com.xerox.amazonws.fps.Amount;
import com.xerox.amazonws.fps.AmountType;
import com.xerox.amazonws.fps.ChargeFeeTo;
import com.xerox.amazonws.fps.DebtBalance;
import com.xerox.amazonws.fps.DescriptorPolicy;
import com.xerox.amazonws.fps.FPSError;
import com.xerox.amazonws.fps.FPSException;
import com.xerox.amazonws.fps.FPSOperation;
import com.xerox.amazonws.fps.Instrument;
import com.xerox.amazonws.fps.InvalidSignatureException;
import com.xerox.amazonws.fps.MarketplaceRefundPolicy;
import com.xerox.amazonws.fps.MultiUseInstrument;
import com.xerox.amazonws.fps.NotificationEventType;
import com.xerox.amazonws.fps.OutstandingPrepaidLiability;
import com.xerox.amazonws.fps.PaymentInstructionDetail;
import com.xerox.amazonws.fps.PaymentMethod;
import com.xerox.amazonws.fps.PostPaidInstrument;
import com.xerox.amazonws.fps.PrepaidBalance;
import com.xerox.amazonws.fps.PrepaidInstrument;
import com.xerox.amazonws.fps.RecipientInstrument;
import com.xerox.amazonws.fps.RecurringGranularity;
import com.xerox.amazonws.fps.RecurringInstrument;
import com.xerox.amazonws.fps.SingleUseInstrument;
import com.xerox.amazonws.fps.TemporaryDeclinePolicy;
import com.xerox.amazonws.fps.Token;
import com.xerox.amazonws.fps.TokenType;
import com.xerox.amazonws.fps.TokenUsageLimit;
import com.xerox.amazonws.fps.Transaction;
import com.xerox.amazonws.fps.TransactionDetail;
import com.xerox.amazonws.fps.TransactionResult;
import com.xerox.amazonws.fps.TransactionalRoleFilter;
import com.xerox.amazonws.fps.UsageLimit;
import com.xerox.amazonws.sdb.DataUtils;
import com.xerox.amazonws.typica.fps.jaxb.CancelTokenResponse;
import com.xerox.amazonws.typica.fps.jaxb.DiscardResultsResponse;
import com.xerox.amazonws.typica.fps.jaxb.FPSOperationFilter;
import com.xerox.amazonws.typica.fps.jaxb.FundPrepaidResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetAccountActivityResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetAccountBalanceResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetAllCreditInstrumentsResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetAllPrepaidInstrumentsResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetDebtBalanceResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetOutstandingDebtBalanceResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetPaymentInstructionResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetPrepaidBalanceResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetResultsResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetTokenByCallerResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetTokenUsageResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetTokensResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetTotalPrepaidLiabilityResponse;
import com.xerox.amazonws.typica.fps.jaxb.GetTransactionResponse;
import com.xerox.amazonws.typica.fps.jaxb.InstallPaymentInstructionResponse;
import com.xerox.amazonws.typica.fps.jaxb.OutstandingDebtBalance;
import com.xerox.amazonws.typica.fps.jaxb.PayResponse;
import com.xerox.amazonws.typica.fps.jaxb.RefundResponse;
import com.xerox.amazonws.typica.fps.jaxb.ReserveResponse;
import com.xerox.amazonws.typica.fps.jaxb.ResponseStatus;
import com.xerox.amazonws.typica.fps.jaxb.RetryTransactionResponse;
import com.xerox.amazonws.typica.fps.jaxb.ServiceError;
import com.xerox.amazonws.typica.fps.jaxb.ServiceErrors;
import com.xerox.amazonws.typica.fps.jaxb.SettleDebtResponse;
import com.xerox.amazonws.typica.fps.jaxb.SettleResponse;
import com.xerox.amazonws.typica.fps.jaxb.SubscribeForCallerNotificationResponse;
import com.xerox.amazonws.typica.fps.jaxb.TransactionResponse;
import com.xerox.amazonws.typica.fps.jaxb.UnSubscribeForCallerNotificationResponse;
import com.xerox.amazonws.typica.fps.jaxb.WriteOffDebtResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexiblePaymentsService
extends AWSQueryConnection {
    private final String callerToken;
    private final String recipientToken;
    private final DescriptorPolicy descriptorPolicy;
    private final TemporaryDeclinePolicy tempDeclinePolicy;
    private final String uiPipeline;
    private static Log logger = LogFactory.getLog(FlexiblePaymentsService.class);

    public FlexiblePaymentsService(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true, null, null, null, null);
    }

    public FlexiblePaymentsService(String awsAccessId, String awsSecretKey, String callerToken, String recipientToken, DescriptorPolicy descriptorPolicy, TemporaryDeclinePolicy tempDeclinePolicy) {
        this(awsAccessId, awsSecretKey, true, callerToken, recipientToken, descriptorPolicy, tempDeclinePolicy);
    }

    public FlexiblePaymentsService(String awsAccessId, String awsSecretKey, boolean isSecure, String callerToken, String recipientToken, DescriptorPolicy descriptorPolicy, TemporaryDeclinePolicy tempDeclinePolicy) {
        this(awsAccessId, awsSecretKey, isSecure, callerToken, recipientToken, descriptorPolicy, tempDeclinePolicy, "fps.amazonaws.com", "https://authorize.payments.amazon.com/cobranded-ui/actions/start");
    }

    public FlexiblePaymentsService(String awsAccessId, String awsSecretKey, boolean isSecure, String callerToken, String recipientToken, DescriptorPolicy descriptorPolicy, TemporaryDeclinePolicy tempDeclinePolicy, String server, String uiPipeline) {
        this(awsAccessId, awsSecretKey, isSecure, callerToken, recipientToken, descriptorPolicy, tempDeclinePolicy, server, isSecure ? 443 : 80, uiPipeline);
    }

    public FlexiblePaymentsService(String awsAccessId, String awsSecretKey, boolean isSecure, String callerToken, String recipientToken, DescriptorPolicy descriptorPolicy, TemporaryDeclinePolicy tempDeclinePolicy, String server, int port, String uiPipeline) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        if (callerToken != null && !"".equals(callerToken) && callerToken.length() != 64) {
            throw new IllegalArgumentException("The caller token must have a length of 64 bytes! Invalid value: " + callerToken);
        }
        if (recipientToken != null && !"".equals(recipientToken) && recipientToken.length() != 64) {
            throw new IllegalArgumentException("The caller token must have a length of 64 bytes! Invalid value: " + recipientToken);
        }
        this.uiPipeline = uiPipeline;
        this.callerToken = "".equals(callerToken) ? null : callerToken;
        this.recipientToken = "".equals(recipientToken) ? null : recipientToken;
        this.descriptorPolicy = descriptorPolicy;
        this.tempDeclinePolicy = tempDeclinePolicy;
        FlexiblePaymentsService.setVersionHeader(this);
    }

    public void cancelToken(String tokenID) throws FPSException {
        this.cancelToken(tokenID, "");
    }

    public void cancelToken(String tokenID, String reason) throws FPSException {
        if (tokenID == null || tokenID.length() != 64) {
            throw new IllegalArgumentException("The token must have a length of 64 bytes");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TokenId", tokenID);
        params.put("ReasonText", reason);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "CancelToken", params, CancelTokenResponse.class);
    }

    public void discardResults(String ... transactionIDs) throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < transactionIDs.length; ++i) {
            params.put("TransactionID." + i, transactionIDs[i]);
        }
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "DiscardResults", params, DiscardResultsResponse.class);
    }

    public Transaction fundPrepaid(String senderTokenID, String prepaidInstrumentID, double fundingAmount, String callerReference) throws FPSException {
        return this.fundPrepaid(senderTokenID, this.callerToken, prepaidInstrumentID, fundingAmount, new Date(), null, null, callerReference, ChargeFeeTo.RECIPIENT, null, null, null, null, this.descriptorPolicy, this.tempDeclinePolicy);
    }

    public Transaction fundPrepaid(String senderTokenID, String callerTokenID, String prepaidInstrumentID, double fundingAmount, Date transactionDate, String senderReference, String recipientReference, String callerReference, ChargeFeeTo chargeFeeTo, String senderDescription, String recipientDescription, String callerDescription, String metadata, DescriptorPolicy descriptorPolicy, TemporaryDeclinePolicy tempDeclinePolicy) throws FPSException {
        if (callerTokenID == null || callerTokenID.length() != 64) {
            throw new IllegalArgumentException("The token must have a length of 64 bytes");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SenderTokenId", senderTokenID);
        params.put("CallerTokenId", callerTokenID);
        params.put("PrepaidInstrumentId", prepaidInstrumentID);
        params.put("FundingAmount", Double.toString(fundingAmount));
        params.put("TransactionDate", DataUtils.encodeDate(transactionDate));
        if (senderReference != null) {
            params.put("SenderReference", senderReference);
        }
        if (recipientReference != null) {
            params.put("RecipientReference", recipientReference);
        }
        params.put("CallerReference", callerReference);
        params.put("ChargeFeeTo", chargeFeeTo.value());
        params.put("ChargeFeeTo", chargeFeeTo.value());
        if (senderDescription != null) {
            params.put("SenderDescription", senderDescription);
        }
        if (recipientDescription != null) {
            params.put("RecipientDescription", recipientDescription);
        }
        if (callerDescription != null) {
            params.put("CallerDescription", callerDescription);
        }
        if (metadata != null) {
            params.put("MetaData", metadata);
        }
        if (descriptorPolicy != null) {
            params.put("SoftDescriptorType", descriptorPolicy.getSoftDescriptorType().value());
            params.put("CSNumberOf", descriptorPolicy.getCSNumberOf().value());
        }
        if (tempDeclinePolicy != null) {
            params.put("TemporaryDeclinePolicy.TemporaryDeclinePolicyType", tempDeclinePolicy.getTemporaryDeclinePolicyType().value());
            params.put("ImplicitRetryTimeoutInMins", Integer.toString(tempDeclinePolicy.getImplicitRetryTimeoutInMins()));
        }
        HttpGet method = new HttpGet();
        FundPrepaidResponse response = this.makeRequestInt((HttpRequestBase)method, "FundPrepaid", params, FundPrepaidResponse.class);
        TransactionResponse transactionResponse = response.getTransactionResponse();
        return new Transaction(transactionResponse.getTransactionId(), Transaction.Status.valueOf(transactionResponse.getStatus().value()), transactionResponse.getStatusDetail());
    }

    public AccountActivity getAccountActivity(Date startDate) throws FPSException {
        return this.getAccountActivity(null, null, 0, startDate, null, null, null);
    }

    public AccountActivity getAccountActivity(Date startDate, Date endDate) throws FPSException {
        return this.getAccountActivity(null, null, 0, startDate, endDate, null, null);
    }

    public AccountActivity getAccountActivity(FPSOperation filter, PaymentMethod paymentMethod, int maxBatchSize, Date startDate, Date endDate, TransactionalRoleFilter role, Transaction.Status transactionStatus) throws FPSException {
        if (startDate == null) {
            throw new IllegalArgumentException("The start date should not be null!");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (filter != null) {
            params.put("Operation", filter.value());
        }
        if (paymentMethod != null) {
            params.put("PaymentMethod", paymentMethod.value());
        }
        if (maxBatchSize != 0) {
            params.put("MaxBatchSize", Integer.toString(maxBatchSize));
        }
        params.put("StartDate", DataUtils.encodeDate(startDate));
        if (endDate != null) {
            params.put("EndDate", DataUtils.encodeDate(endDate));
        }
        if (role != null) {
            params.put("Role", role.value());
        }
        if (transactionStatus != null) {
            params.put("Status", transactionStatus.value());
        }
        HttpGet method = new HttpGet();
        GetAccountActivityResponse response = this.makeRequestInt((HttpRequestBase)method, "GetAccountActivity", params, GetAccountActivityResponse.class);
        Date nextStartDate = null;
        if (response.getStartTimeForNextTransaction() != null) {
            nextStartDate = response.getStartTimeForNextTransaction().toGregorianCalendar().getTime();
        }
        BigInteger nbTransactions = response.getResponseBatchSize();
        List<com.xerox.amazonws.typica.fps.jaxb.Transaction> rawTransactions = response.getTransactions();
        ArrayList<Transaction> transactions = new ArrayList<Transaction>(rawTransactions.size());
        for (com.xerox.amazonws.typica.fps.jaxb.Transaction txn : rawTransactions) {
            com.xerox.amazonws.typica.fps.jaxb.Amount txnAmount = txn.getTransactionAmount();
            com.xerox.amazonws.typica.fps.jaxb.Amount fees = txn.getFees();
            com.xerox.amazonws.typica.fps.jaxb.Amount balance = txn.getBalance();
            transactions.add(new Transaction(txn.getTransactionId(), Transaction.Status.fromValue(txn.getStatus().value()), txn.getDateReceived().toGregorianCalendar().getTime(), txn.getDateCompleted().toGregorianCalendar().getTime(), new Amount(new BigDecimal(txnAmount.getAmount()), txnAmount.getCurrencyCode().toString()), FPSOperation.fromValue(txn.getOperation().value()), PaymentMethod.fromValue(txn.getPaymentMethod().value()), txn.getSenderName(), txn.getCallerName(), txn.getRecipientName(), new Amount(new BigDecimal(fees.getAmount()), fees.getCurrencyCode().toString()), new Amount(new BigDecimal(balance.getAmount()), balance.getCurrencyCode().toString()), txn.getCallerTokenId(), txn.getSenderTokenId(), txn.getRecipientTokenId()));
        }
        return new AccountActivity(nextStartDate, nbTransactions, transactions, filter, paymentMethod, maxBatchSize, endDate, transactionStatus, this);
    }

    public List<String> getAllPrepaidInstruments() throws FPSException {
        return this.getAllPrepaidInstruments(null);
    }

    public List<String> getAllPrepaidInstruments(Instrument.Status instrumentStatus) throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (instrumentStatus != null) {
            params.put("InstrumentStatus", instrumentStatus.value());
        }
        HttpGet method = new HttpGet();
        GetAllPrepaidInstrumentsResponse response = this.makeRequestInt((HttpRequestBase)method, "GetAllPrepaidInstruments", params, GetAllPrepaidInstrumentsResponse.class);
        return response.getPrepaidInstrumentIds();
    }

    public List<String> getAllCreditInstruments() throws FPSException {
        return this.getAllCreditInstruments(null);
    }

    public List<DebtBalance> getAllCreditInstrumentBalances() throws FPSException {
        return this.getAllCreditInstrumentBalances(null);
    }

    public List<String> getAllCreditInstruments(Instrument.Status instrumentStatus) throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (instrumentStatus != null) {
            params.put("InstrumentStatus", instrumentStatus.value());
        }
        HttpGet method = new HttpGet();
        GetAllCreditInstrumentsResponse response = this.makeRequestInt((HttpRequestBase)method, "GetAllCreditInstruments", params, GetAllCreditInstrumentsResponse.class);
        return response.getCreditInstrumentIds();
    }

    public List<DebtBalance> getAllCreditInstrumentBalances(Instrument.Status instrumentStatus) throws FPSException {
        List<String> creditInstruments = this.getAllCreditInstruments(instrumentStatus);
        ArrayList<DebtBalance> balances = new ArrayList<DebtBalance>(creditInstruments.size());
        for (String instrument : creditInstruments) {
            balances.add(this.getDebtBalance(instrument));
        }
        return balances;
    }

    public DebtBalance getDebtBalance(String creditInstrumentId) throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CreditInstrumentId", creditInstrumentId);
        HttpGet method = new HttpGet();
        GetDebtBalanceResponse response = this.makeRequestInt((HttpRequestBase)method, "GetDebtBalance", params, GetDebtBalanceResponse.class);
        com.xerox.amazonws.typica.fps.jaxb.DebtBalance balance = response.getDebtBalance();
        com.xerox.amazonws.typica.fps.jaxb.Amount availableBalance = balance.getAvailableBalance();
        com.xerox.amazonws.typica.fps.jaxb.Amount pendingOutBalance = balance.getPendingOutBalance();
        return new DebtBalance(new Amount(new BigDecimal(availableBalance.getAmount()), availableBalance.getCurrencyCode().toString()), new Amount(new BigDecimal(pendingOutBalance.getAmount()), pendingOutBalance.getCurrencyCode().toString()));
    }

    public DebtBalance getOutstandingDebtBalance() throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        HttpGet method = new HttpGet();
        GetOutstandingDebtBalanceResponse response = this.makeRequestInt((HttpRequestBase)method, "GetOutstandingDebtBalance", params, GetOutstandingDebtBalanceResponse.class);
        OutstandingDebtBalance balance = response.getOutstandingDebt();
        com.xerox.amazonws.typica.fps.jaxb.Amount outstanding = balance.getOutstandingBalance();
        com.xerox.amazonws.typica.fps.jaxb.Amount pendingOut = balance.getPendingOutBalance();
        return new DebtBalance(new Amount(new BigDecimal(outstanding.getAmount()), outstanding.getCurrencyCode().toString()), new Amount(new BigDecimal(pendingOut.getAmount()), pendingOut.getCurrencyCode().toString()));
    }

    public PaymentInstructionDetail getPaymentInstruction(String tokenID) throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TokenId", tokenID);
        HttpGet method = new HttpGet();
        GetPaymentInstructionResponse response = this.makeRequestInt((HttpRequestBase)method, "GetPaymentInstruction", params, GetPaymentInstructionResponse.class);
        Token token = new Token(response.getToken().getTokenId(), response.getToken().getFriendlyName(), Token.Status.fromValue(response.getToken().getStatus().value()), response.getToken().getDateInstalled().toGregorianCalendar().getTime(), response.getToken().getCallerInstalled(), TokenType.fromValue(response.getToken().getTokenType().value()), response.getToken().getOldTokenId(), response.getToken().getPaymentReason());
        return new PaymentInstructionDetail(token, response.getPaymentInstruction(), response.getAccountId(), response.getTokenFriendlyName());
    }

    public PrepaidBalance getPrepaidBalance(String prepaidInstrumentId) throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PrepaidInstrumentId", prepaidInstrumentId);
        HttpGet method = new HttpGet();
        GetPrepaidBalanceResponse response = this.makeRequestInt((HttpRequestBase)method, "GetPrepaidBalance", params, GetPrepaidBalanceResponse.class);
        com.xerox.amazonws.typica.fps.jaxb.PrepaidBalance balance = response.getPrepaidBalance();
        com.xerox.amazonws.typica.fps.jaxb.Amount availableBalance = balance.getAvailableBalance();
        com.xerox.amazonws.typica.fps.jaxb.Amount pendingOutBalance = balance.getPendingInBalance();
        return new PrepaidBalance(new Amount(new BigDecimal(availableBalance.getAmount()), availableBalance.getCurrencyCode().toString()), new Amount(new BigDecimal(pendingOutBalance.getAmount()), pendingOutBalance.getCurrencyCode().toString()));
    }

    public List<TransactionResult> getResults() throws FPSException {
        return this.getResults(null, null);
    }

    public List<TransactionResult> getResults(FPSOperationFilter operation, Integer maxResultsCount) throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (operation != null) {
            params.put("Operation", operation.toString());
        }
        if (maxResultsCount != null) {
            params.put("MaxResultsCount", maxResultsCount.toString());
        }
        HttpGet method = new HttpGet();
        GetResultsResponse response = this.makeRequestInt((HttpRequestBase)method, "GetResults", params, GetResultsResponse.class);
        List<com.xerox.amazonws.typica.fps.jaxb.TransactionResult> rawTransactions = response.getTransactionResults();
        ArrayList<TransactionResult> transactionResults = new ArrayList<TransactionResult>(rawTransactions.size());
        for (com.xerox.amazonws.typica.fps.jaxb.TransactionResult txn : rawTransactions) {
            transactionResults.add(new TransactionResult(txn.getTransactionId(), FPSOperation.fromValue(txn.getOperation().value()), txn.getCallerReference(), Transaction.Status.fromValue(txn.getStatus().value())));
        }
        return transactionResults;
    }

    public List<Token> getAllTokens() throws FPSException {
        return this.getTokens(null, null, null);
    }

    public List<Token> getTokensByFriendlyName(String tokenFriendlyName) throws FPSException {
        return this.getTokens(tokenFriendlyName, null, null);
    }

    public List<Token> getTokensByStatus(Token.Status tokenStatus) throws FPSException {
        return this.getTokens(null, tokenStatus, null);
    }

    public List<Token> getTokensByCallerReference(String callerReference) throws FPSException {
        return this.getTokens(null, null, callerReference);
    }

    public List<Token> getTokens(String tokenFriendlyName, Token.Status tokenStatus, String callerReference) throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (tokenFriendlyName != null) {
            params.put("TokenFriendlyName", tokenFriendlyName);
        }
        if (tokenStatus != null) {
            params.put("TokenStatus", tokenStatus.value());
        }
        if (callerReference != null) {
            params.put("CallerReference", callerReference);
        }
        HttpGet method = new HttpGet();
        GetTokensResponse response = this.makeRequestInt((HttpRequestBase)method, "GetTokens", params, GetTokensResponse.class);
        List<com.xerox.amazonws.typica.fps.jaxb.Token> rawTokens = response.getTokens();
        ArrayList<Token> tokens = new ArrayList<Token>(rawTokens.size());
        for (com.xerox.amazonws.typica.fps.jaxb.Token token : rawTokens) {
            tokens.add(new Token(token.getTokenId(), token.getFriendlyName(), Token.Status.fromValue(token.getStatus().value()), token.getDateInstalled().toGregorianCalendar().getTime(), token.getCallerInstalled(), TokenType.fromValue(token.getTokenType().value()), token.getOldTokenId(), token.getPaymentReason()));
        }
        return tokens;
    }

    public Token getTokenByID(String tokenID) throws FPSException {
        return this.getToken(tokenID, null);
    }

    public Token getTokenByCaller(String callerReference) throws FPSException {
        return this.getToken(null, callerReference);
    }

    private Token getToken(String tokenID, String callerReference) throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (tokenID == null && callerReference == null) {
            throw new IllegalArgumentException("Either the token ID or the caller reference must be given!");
        }
        if (tokenID != null && tokenID.length() != 64) {
            throw new IllegalArgumentException("The token must have a length of 64 bytes");
        }
        if (tokenID != null) {
            params.put("TokenId", tokenID);
        }
        if (callerReference != null) {
            params.put("CallerReference", callerReference);
        }
        HttpGet method = new HttpGet();
        GetTokenByCallerResponse response = this.makeRequestInt((HttpRequestBase)method, "GetTokenByCaller", params, GetTokenByCallerResponse.class);
        return new Token(response.getToken().getTokenId(), response.getToken().getFriendlyName(), Token.Status.fromValue(response.getToken().getStatus().value()), response.getToken().getDateInstalled().toGregorianCalendar().getTime(), response.getToken().getCallerInstalled(), TokenType.fromValue(response.getToken().getTokenType().value()), response.getToken().getOldTokenId(), response.getToken().getPaymentReason());
    }

    public List<TokenUsageLimit> getTokenUsage(String tokenID) throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (tokenID == null) {
            throw new IllegalArgumentException("Either the token ID or the caller reference must be given!");
        }
        if (tokenID.length() != 64) {
            throw new IllegalArgumentException("The token must have a length of 64 bytes");
        }
        params.put("TokenId", tokenID);
        HttpGet method = new HttpGet();
        GetTokenUsageResponse response = this.makeRequestInt((HttpRequestBase)method, "GetTokenUsage", params, GetTokenUsageResponse.class);
        ArrayList<TokenUsageLimit> limits = new ArrayList<TokenUsageLimit>(response.getTokenUsageLimits().size());
        for (com.xerox.amazonws.typica.fps.jaxb.TokenUsageLimit limit : response.getTokenUsageLimits()) {
            limits.add(new TokenUsageLimit(limit.getCount(), new Amount(new BigDecimal(limit.getAmount().getAmount()), limit.getAmount().getCurrencyCode().value()), limit.getLastResetCount(), new Amount(new BigDecimal(limit.getLastResetAmount().getAmount()), limit.getLastResetAmount().getCurrencyCode().value()), limit.getLastResetTimeStamp().toGregorianCalendar().getTime()));
        }
        return limits;
    }

    public OutstandingPrepaidLiability getTotalPrepaidLiability() throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        HttpGet method = new HttpGet();
        GetTotalPrepaidLiabilityResponse response = this.makeRequestInt((HttpRequestBase)method, "GetTotalPrepaidLiability", params, GetTotalPrepaidLiabilityResponse.class);
        com.xerox.amazonws.typica.fps.jaxb.OutstandingPrepaidLiability liability = response.getOutstandingPrepaidLiability();
        return new OutstandingPrepaidLiability(new Amount(new BigDecimal(liability.getOutstandingBalance().getAmount()), liability.getOutstandingBalance().getCurrencyCode().value()), new Amount(new BigDecimal(liability.getPendingInBalance().getAmount()), liability.getPendingInBalance().getCurrencyCode().value()));
    }

    public TransactionDetail getTransaction(String transactionID) throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TransactionId", transactionID);
        HttpGet method = new HttpGet();
        GetTransactionResponse response = this.makeRequestInt((HttpRequestBase)method, "GetTransaction", params, GetTransactionResponse.class);
        com.xerox.amazonws.typica.fps.jaxb.TransactionDetail txn = response.getTransaction();
        return new TransactionDetail(txn.getTransactionId(), txn.getCallerTransactionDate().toGregorianCalendar().getTime(), txn.getDateReceived().toGregorianCalendar().getTime(), txn.getDateCompleted().toGregorianCalendar().getTime(), new Amount(new BigDecimal(txn.getTransactionAmount().getAmount()), txn.getTransactionAmount().getCurrencyCode().value()), new Amount(new BigDecimal(txn.getFees().getAmount()), txn.getFees().getCurrencyCode().value()), txn.getCallerTokenId(), txn.getSenderTokenId(), txn.getRecipientTokenId(), txn.getPrepaidInstrumentId(), txn.getCreditInstrumentId(), FPSOperation.fromValue(txn.getOperation().value()), PaymentMethod.fromValue(txn.getPaymentMethod().value()), Transaction.Status.fromValue(txn.getStatus().value()), txn.getErrorCode(), txn.getErrorMessage(), txn.getMetaData(), txn.getSenderName(), txn.getCallerName(), txn.getRecipientName());
    }

    public String installUnrestrictedCallerPaymentInstruction(String callerReference) throws FPSException {
        return this.installPaymentInstruction("MyRole == 'Caller' orSay 'Role does not match';", callerReference, callerReference, TokenType.UNRESTRICTED, callerReference);
    }

    public String installUnrestrictedRecipientPaymentInstruction(String callerReference) throws FPSException {
        return this.installPaymentInstruction("MyRole == 'Recipient' orSay 'Role does not match';", callerReference, callerReference, TokenType.UNRESTRICTED, callerReference);
    }

    public String installPaymentInstruction(String paymentInstruction, String callerReference, TokenType type) throws FPSException {
        return this.installPaymentInstruction(paymentInstruction, null, callerReference, type, null);
    }

    public String installPaymentInstruction(String paymentInstruction, String tokenFriendlyName, String callerReference, TokenType type, String comment) throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PaymentInstruction", paymentInstruction);
        if (tokenFriendlyName != null) {
            params.put("TokenFriendlyName", tokenFriendlyName);
        }
        params.put("CallerReference", callerReference);
        params.put("TokenType", type.value());
        if (comment != null) {
            params.put("PaymentReason", comment);
        }
        HttpGet method = new HttpGet();
        InstallPaymentInstructionResponse response = this.makeRequestInt((HttpRequestBase)method, "InstallPaymentInstruction", params, InstallPaymentInstructionResponse.class);
        return response.getTokenId();
    }

    public Transaction pay(String senderToken, Amount amount, String callerReference) throws FPSException {
        return this.pay(this.recipientToken, senderToken, this.callerToken, amount, new Date(), ChargeFeeTo.RECIPIENT, callerReference, null, null, null, null, null, null, 0.0, 0, this.descriptorPolicy);
    }

    public Transaction pay(String senderToken, Amount amount, String callerReference, DescriptorPolicy descriptorPolicy) throws FPSException {
        return this.pay(this.recipientToken, senderToken, this.callerToken, amount, new Date(), ChargeFeeTo.RECIPIENT, callerReference, null, null, null, null, null, null, 0.0, 0, descriptorPolicy);
    }

    public Transaction pay(String recipientToken, String senderToken, String callerToken, Amount amount, Date transactionDate, ChargeFeeTo chargeFeeTo, String callerReference, String senderReference, String recipientReference, String senderDescription, String recipientDescription, String callerDescription, String metadata, double marketplaceFixedFee, int marketplaceVariableFee, DescriptorPolicy descriptorPolicy) throws FPSException {
        return this.pay(recipientToken, senderToken, callerToken, amount, transactionDate, chargeFeeTo, callerReference, senderReference, recipientReference, senderDescription, recipientDescription, callerDescription, metadata, marketplaceFixedFee, marketplaceVariableFee, descriptorPolicy, this.tempDeclinePolicy);
    }

    public Transaction pay(String recipientToken, String senderToken, String callerToken, Amount amount, Date transactionDate, ChargeFeeTo chargeFeeTo, String callerReference, String senderReference, String recipientReference, String senderDescription, String recipientDescription, String callerDescription, String metadata, double marketplaceFixedFee, int marketplaceVariableFee, DescriptorPolicy descriptorPolicy, TemporaryDeclinePolicy tempDeclinePolicy) throws FPSException {
        if (recipientToken != null && recipientToken.length() != 64) {
            throw new IllegalArgumentException("The recipient token must have a length of 64 bytes");
        }
        if (senderToken != null && senderToken.length() != 64) {
            throw new IllegalArgumentException("The sender token must have a length of 64 bytes");
        }
        if (callerToken != null && callerToken.length() != 64) {
            throw new IllegalArgumentException("The caller token must have a length of 64 bytes");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Payment: " + senderToken + " paying " + recipientToken + " for " + amount));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (recipientToken != null) {
            params.put("RecipientTokenId", recipientToken);
        }
        params.put("SenderTokenId", senderToken);
        params.put("CallerTokenId", callerToken);
        params.put("TransactionAmount.Amount", Double.toString(amount.getAmount().doubleValue()));
        params.put("TransactionAmount.CurrencyCode", amount.getCurrencyCode());
        if (transactionDate != null) {
            params.put("TransactionDate", DataUtils.encodeDate(transactionDate));
        }
        params.put("ChargeFeeTo", chargeFeeTo.value());
        params.put("CallerReference", callerReference);
        if (senderReference != null) {
            params.put("SenderReference", senderReference);
        }
        if (recipientReference != null) {
            params.put("RecipientReference", recipientReference);
        }
        if (senderDescription != null) {
            params.put("SenderDescription", senderDescription);
        }
        if (recipientDescription != null) {
            params.put("RecipientDescription", recipientDescription);
        }
        if (callerDescription != null) {
            params.put("CallerDescription", callerDescription);
        }
        if (metadata != null) {
            params.put("MetaData", metadata);
        }
        if (marketplaceFixedFee != 0.0) {
            params.put("MarketplaceFixedFee", Double.toString(marketplaceFixedFee));
        }
        if (marketplaceVariableFee != 0) {
            params.put("MarketplaceVariableFee", Integer.toString(marketplaceVariableFee));
        }
        if (descriptorPolicy != null) {
            params.put("SoftDescriptorType", descriptorPolicy.getSoftDescriptorType().value());
            params.put("CSNumberOf", descriptorPolicy.getCSNumberOf().value());
        }
        if (tempDeclinePolicy != null) {
            params.put("TemporaryDeclinePolicy.TemporaryDeclinePolicyType", tempDeclinePolicy.getTemporaryDeclinePolicyType().value());
            params.put("TemporaryDeclinePolicy.ImplicitRetryTimeoutInMins", Integer.toString(tempDeclinePolicy.getImplicitRetryTimeoutInMins()));
        }
        HttpGet method = new HttpGet();
        PayResponse response = this.makeRequestInt((HttpRequestBase)method, "Pay", params, PayResponse.class);
        TransactionResponse transactionResponse = response.getTransactionResponse();
        return new Transaction(transactionResponse.getTransactionId(), Transaction.Status.fromValue(transactionResponse.getStatus().value()), transactionResponse.getStatusDetail());
    }

    public Transaction refund(String senderToken, String transactionID, String callerReference) throws FPSException {
        return this.refund(this.callerToken, senderToken, transactionID, null, ChargeFeeTo.RECIPIENT, new Date(), callerReference, null, null, null, null, null, null, null);
    }

    public Transaction refund(String callerToken, String senderToken, String transactionID, Amount refundAmount, ChargeFeeTo chargeFeeTo, Date transactionDate, String callerReference, String senderReference, String recipientReference, String senderDescription, String recipientDescription, String callerDescription, String metadata, MarketplaceRefundPolicy policy) throws FPSException {
        if (callerToken == null || callerToken.length() != 64) {
            throw new IllegalArgumentException("The caller token must have a length of 64 bytes");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Refund: " + senderToken + " refunding transaction " + transactionID + " for " + refundAmount));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CallerTokenId", callerToken);
        params.put("RefundSenderTokenId", senderToken);
        params.put("TransactionId", transactionID);
        if (refundAmount != null) {
            params.put("RefundAmount.Amount", refundAmount.getAmount().toString());
            params.put("RefundAmount.CurrencyCode", refundAmount.getCurrencyCode());
        }
        params.put("ChargeFeeTo", chargeFeeTo.value());
        if (transactionDate != null) {
            params.put("TransactionDate", DataUtils.encodeDate(transactionDate));
        }
        params.put("CallerReference", callerReference);
        if (senderReference != null) {
            params.put("RefundSenderReference", senderReference);
        }
        if (recipientReference != null) {
            params.put("RefundRecipientReference", recipientReference);
        }
        if (senderDescription != null) {
            params.put("RefundSenderDescription", senderDescription);
        }
        if (recipientDescription != null) {
            params.put("RefundRecipientDescription", recipientDescription);
        }
        if (callerDescription != null) {
            params.put("CallerDescription", callerDescription);
        }
        if (metadata != null) {
            params.put("MetaData", metadata);
        }
        if (policy != null) {
            params.put("MarketplaceRefundPolicy", policy.value());
        }
        HttpGet method = new HttpGet();
        RefundResponse response = this.makeRequestInt((HttpRequestBase)method, "Refund", params, RefundResponse.class);
        TransactionResponse transactionResponse = response.getTransactionResponse();
        return new Transaction(transactionResponse.getTransactionId(), Transaction.Status.fromValue(transactionResponse.getStatus().value()), transactionResponse.getStatusDetail());
    }

    public Transaction reserve(String senderToken, Amount amount, String callerReference) throws FPSException {
        return this.reserve(this.recipientToken, senderToken, this.callerToken, amount, new Date(), ChargeFeeTo.RECIPIENT, callerReference, null, null, null, null, null, null, 0.0, 0, this.descriptorPolicy, this.tempDeclinePolicy);
    }

    public Transaction reserve(String recipientToken, String senderToken, String callerToken, Amount amount, Date transactionDate, ChargeFeeTo chargeFeeTo, String callerReference, String senderReference, String recipientReference, String senderDescription, String recipientDescription, String callerDescription, String metadata, double marketplaceFixedFee, int marketplaceVariableFee, DescriptorPolicy descriptorPolicy, TemporaryDeclinePolicy tempDeclinePolicy) throws FPSException {
        if (recipientToken == null || recipientToken.length() != 64) {
            throw new IllegalArgumentException("The recipient token must have a length of 64 bytes");
        }
        if (senderToken == null || senderToken.length() != 64) {
            throw new IllegalArgumentException("The sender token must have a length of 64 bytes");
        }
        if (callerToken == null || callerToken.length() != 64) {
            throw new IllegalArgumentException("The caller token must have a length of 64 bytes");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Reserve: " + recipientToken + " reserving " + senderToken + " for " + amount));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("RecipientTokenId", recipientToken);
        params.put("SenderTokenId", senderToken);
        params.put("CallerTokenId", callerToken);
        params.put("TransactionAmount.Amount", Double.toString(amount.getAmount().doubleValue()));
        params.put("TransactionAmount.CurrencyCode", amount.getCurrencyCode());
        if (transactionDate != null) {
            params.put("TransactionDate", DataUtils.encodeDate(transactionDate));
        }
        params.put("ChargeFeeTo", chargeFeeTo.value());
        params.put("CallerReference", callerReference);
        if (senderReference != null) {
            params.put("SenderReference", senderReference);
        }
        if (recipientReference != null) {
            params.put("RecipientReference", recipientReference);
        }
        if (senderDescription != null) {
            params.put("SenderDescription", senderDescription);
        }
        if (recipientDescription != null) {
            params.put("RecipientDescription", recipientDescription);
        }
        if (callerDescription != null) {
            params.put("CallerDescription", callerDescription);
        }
        if (metadata != null) {
            params.put("MetaData", metadata);
        }
        if (marketplaceFixedFee != 0.0) {
            params.put("MarketplaceFixedFee", Double.toString(marketplaceFixedFee));
        }
        if (marketplaceVariableFee != 0) {
            params.put("MarketplaceVariableFee", Integer.toString(marketplaceVariableFee));
        }
        if (descriptorPolicy != null) {
            params.put("SoftDescriptorType", descriptorPolicy.getSoftDescriptorType().value());
            params.put("CSNumberOf", descriptorPolicy.getCSNumberOf().value());
        }
        if (tempDeclinePolicy != null) {
            params.put("TemporaryDeclinePolicy.TemporaryDeclinePolicyType", tempDeclinePolicy.getTemporaryDeclinePolicyType().value());
            params.put("ImplicitRetryTimeoutInMins", Integer.toString(tempDeclinePolicy.getImplicitRetryTimeoutInMins()));
        }
        HttpGet method = new HttpGet();
        ReserveResponse response = this.makeRequestInt((HttpRequestBase)method, "Reserve", params, ReserveResponse.class);
        TransactionResponse transactionResponse = response.getTransactionResponse();
        return new Transaction(transactionResponse.getTransactionId(), Transaction.Status.fromValue(transactionResponse.getStatus().value()), transactionResponse.getStatusDetail());
    }

    public Transaction retryTransaction(String transactionID) throws FPSException {
        if (transactionID == null || transactionID.length() == 0 || transactionID.length() > 35) {
            throw new IllegalArgumentException("The transaction ID must not be null/empty and has a max size of 35 bytes");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Retry tranasction: " + transactionID));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("OriginalTransactionId", transactionID);
        HttpGet method = new HttpGet();
        RetryTransactionResponse response = this.makeRequestInt((HttpRequestBase)method, "RetryTransaction", params, RetryTransactionResponse.class);
        TransactionResponse transactionResponse = response.getTransactionResponse();
        return new Transaction(transactionResponse.getTransactionId(), Transaction.Status.fromValue(transactionResponse.getStatus().value()), transactionResponse.getStatusDetail());
    }

    public Transaction settle(String reserveTransactionID, Amount amount) throws FPSException {
        return this.settle(reserveTransactionID, amount, null);
    }

    public Transaction settle(String reserveTransactionID, Amount amount, Date transactionDate) throws FPSException {
        if (reserveTransactionID == null || reserveTransactionID.length() == 0 || reserveTransactionID.length() > 35) {
            throw new IllegalArgumentException("The reserve transaction ID must not be null/empty and has a max size of 35 bytes");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Settle: " + reserveTransactionID + " for " + amount));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ReserveTransactionId", reserveTransactionID);
        params.put("TransactionAmount.Amount", Double.toString(amount.getAmount().doubleValue()));
        params.put("TransactionAmount.CurrencyCode", amount.getCurrencyCode());
        if (transactionDate != null) {
            params.put("TransactionDate", DataUtils.encodeDate(transactionDate));
        }
        HttpGet method = new HttpGet();
        SettleResponse response = this.makeRequestInt((HttpRequestBase)method, "Settle", params, SettleResponse.class);
        TransactionResponse transactionResponse = response.getTransactionResponse();
        return new Transaction(transactionResponse.getTransactionId(), Transaction.Status.fromValue(transactionResponse.getStatus().value()), transactionResponse.getStatusDetail());
    }

    public Transaction settleDebt(String settlementToken, String creditInstrument, Amount amount, String callerReference) throws FPSException {
        return this.settleDebt(settlementToken, this.callerToken, creditInstrument, amount, new Date(), null, null, callerReference, ChargeFeeTo.RECIPIENT, null, null, null, null, this.descriptorPolicy, this.tempDeclinePolicy);
    }

    public Transaction settleDebt(String settlementToken, String callerToken, String creditInstrument, Amount amount, Date transactionDate, String senderReference, String recipientReference, String callerReference, ChargeFeeTo chargeFeeTo, String senderDescription, String recipientDescription, String callerDescription, String metadata, DescriptorPolicy descriptorPolicy, TemporaryDeclinePolicy tempDeclinePolicy) throws FPSException {
        if (settlementToken == null || settlementToken.length() != 64) {
            throw new IllegalArgumentException("The settlement token must have a length of 64 bytes");
        }
        if (callerToken == null || callerToken.length() != 64) {
            throw new IllegalArgumentException("The caller token must have a length of 64 bytes");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SenderTokenId", settlementToken);
        params.put("CallerTokenId", callerToken);
        params.put("CreditInstrumentId", creditInstrument);
        params.put("SettlementAmount.Amount", Double.toString(amount.getAmount().doubleValue()));
        params.put("SettlementAmount.CurrencyCode", amount.getCurrencyCode());
        if (transactionDate != null) {
            params.put("TransactionDate", DataUtils.encodeDate(transactionDate));
        }
        if (senderReference != null) {
            params.put("SenderReference", senderReference);
        }
        if (recipientReference != null) {
            params.put("RecipientReference", recipientReference);
        }
        params.put("CallerReference", callerReference);
        params.put("ChargeFeeTo", chargeFeeTo.value());
        if (senderDescription != null) {
            params.put("SenderDescription", senderDescription);
        }
        if (recipientDescription != null) {
            params.put("RecipientDescription", recipientDescription);
        }
        if (callerDescription != null) {
            params.put("CallerDescription", callerDescription);
        }
        if (metadata != null) {
            params.put("MetaData", metadata);
        }
        if (descriptorPolicy != null) {
            params.put("SoftDescriptorType", descriptorPolicy.getSoftDescriptorType().value());
            params.put("CSNumberOf", descriptorPolicy.getCSNumberOf().value());
        }
        if (tempDeclinePolicy != null) {
            params.put("TemporaryDeclinePolicy.TemporaryDeclinePolicyType", tempDeclinePolicy.getTemporaryDeclinePolicyType().value());
            params.put("ImplicitRetryTimeoutInMins", Integer.toString(tempDeclinePolicy.getImplicitRetryTimeoutInMins()));
        }
        HttpGet method = new HttpGet();
        SettleDebtResponse response = this.makeRequestInt((HttpRequestBase)method, "SettleDebt", params, SettleDebtResponse.class);
        TransactionResponse transactionResponse = response.getTransactionResponse();
        return new Transaction(transactionResponse.getTransactionId(), Transaction.Status.fromValue(transactionResponse.getStatus().value()), transactionResponse.getStatusDetail());
    }

    public void subscribeForCallerNotification(NotificationEventType operationType, URL webService) throws FPSException {
        if (operationType == null) {
            throw new IllegalArgumentException("The notification operation name is required!");
        }
        if (webService == null) {
            throw new IllegalArgumentException("The Web Service API URL is required!");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Subscribe for caller notification for operations " + operationType + " at " + webService));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NotificationOperationName", operationType.value());
        params.put("WebServiceAPIURLt", webService.toString());
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "SubscribeForCallerNotification", params, SubscribeForCallerNotificationResponse.class);
    }

    public void unsubscribeForCallerNotification(NotificationEventType operationType) throws FPSException {
        if (operationType == null) {
            throw new IllegalArgumentException("The notification operation name is required!");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Unsubscribe for caller notification for operations " + operationType));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NotificationOperationName", operationType.value());
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "UnSubscribeForCallerNotification", params, UnSubscribeForCallerNotificationResponse.class);
    }

    public Transaction writeOffDebt(String creditInstrument, double adjustmentAmount, String callerReference) throws FPSException {
        return this.writeOffDebt(this.callerToken, creditInstrument, adjustmentAmount, new Date(), callerReference, null, null, null, null, null, null);
    }

    public Transaction writeOffDebt(String callerToken, String creditInstrument, double adjustmentAmount, Date transactionDate, String callerReference, String recipientReference, String senderReference, String senderDescription, String recipientDescription, String callerDescription, String metadata) throws FPSException {
        if (callerToken == null || callerToken.length() != 64) {
            throw new IllegalArgumentException("The caller token must have a length of 64 bytes");
        }
        if (adjustmentAmount <= 0.0) {
            throw new IllegalArgumentException("The adjustment amount should be a positive value");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Writing off debt instrument " + creditInstrument + " for an amount of " + adjustmentAmount));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CallerTokenId", callerToken);
        params.put("CreditInstrumentId", creditInstrument);
        params.put("AdjustmentAmount.Amount", Double.toString(adjustmentAmount));
        params.put("AdjustmentAmount.CurrencyCode", "USD");
        if (transactionDate != null) {
            params.put("TransactionDate", DataUtils.encodeDate(transactionDate));
        }
        if (senderReference != null) {
            params.put("SenderReference", senderReference);
        }
        if (recipientReference != null) {
            params.put("RecipientReference", recipientReference);
        }
        params.put("CallerReference", callerReference);
        if (senderDescription != null) {
            params.put("SenderDescription", senderDescription);
        }
        if (recipientDescription != null) {
            params.put("RecipientDescription", recipientDescription);
        }
        if (callerDescription != null) {
            params.put("CallerDescription", callerDescription);
        }
        if (metadata != null) {
            params.put("MetaData", metadata);
        }
        HttpGet method = new HttpGet();
        WriteOffDebtResponse response = this.makeRequestInt((HttpRequestBase)method, "WriteOffDebt", params, WriteOffDebtResponse.class);
        TransactionResponse transactionResponse = response.getTransactionResponse();
        return new Transaction(transactionResponse.getTransactionId(), Transaction.Status.fromValue(transactionResponse.getStatus().value()), transactionResponse.getStatusDetail());
    }

    public AccountBalance getAccountBalance() throws FPSException {
        HashMap<String, String> params = new HashMap<String, String>();
        HttpGet method = new HttpGet();
        GetAccountBalanceResponse response = this.makeRequestInt((HttpRequestBase)method, "GetAccountBalance", params, GetAccountBalanceResponse.class);
        com.xerox.amazonws.typica.fps.jaxb.AccountBalance balance = response.getAccountBalance();
        com.xerox.amazonws.typica.fps.jaxb.Amount available = balance.getTotalBalance();
        com.xerox.amazonws.typica.fps.jaxb.Amount pendingIn = balance.getPendingInBalance();
        com.xerox.amazonws.typica.fps.jaxb.Amount pendingOut = balance.getPendingOutBalance();
        com.xerox.amazonws.typica.fps.jaxb.Amount disburse = balance.getAvailableBalances().getDisburseBalance();
        com.xerox.amazonws.typica.fps.jaxb.Amount refund = balance.getAvailableBalances().getRefundBalance();
        return new AccountBalance(new Amount(new BigDecimal(available.getAmount()), available.getCurrencyCode().toString()), new Amount(new BigDecimal(pendingIn.getAmount()), pendingIn.getCurrencyCode().toString()), new Amount(new BigDecimal(pendingOut.getAmount()), pendingOut.getCurrencyCode().toString()), new Amount(new BigDecimal(disburse.getAmount()), disburse.getCurrencyCode().toString()), new Amount(new BigDecimal(refund.getAmount()), refund.getCurrencyCode().toString()));
    }

    public String acquireSingleUseToken(String callerReference, Amount amount, String returnURL, String reason) throws FPSException, MalformedURLException {
        return this.acquireSingleUseToken(callerReference, amount, false, null, null, false, true, null, null, null, null, null, null, null, returnURL, reason);
    }

    public String acquireSingleUseToken(String callerReference, Amount amount, PaymentMethod paymentMethod, String returnURL, String reason) throws FPSException, MalformedURLException {
        return this.acquireSingleUseToken(callerReference, amount, false, paymentMethod, null, false, true, null, null, null, null, null, null, null, returnURL, reason);
    }

    public String acquireSingleUseToken(String callerReference, Amount amount, boolean reserve, PaymentMethod paymentMethod, String recipientToken, Boolean isRecipientCobranding, Boolean collectShippingAddress, Address address, Amount itemTotal, Amount shipping, Amount handling, Boolean giftWrapping, Amount discount, Amount tax, String returnURL, String reason) throws FPSException, MalformedURLException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("callerReference", callerReference);
        parameters.put("transactionAmount", amount.getAmount().toString());
        parameters.put("currencyCode", amount.getCurrencyCode());
        if (paymentMethod != null) {
            parameters.put("paymentMethod", paymentMethod.value());
        }
        if (recipientToken != null) {
            parameters.put("recipientToken", recipientToken);
        }
        if (reason != null) {
            parameters.put("paymentReason", reason);
        }
        if (reserve) {
            parameters.put("reserve", "True");
        }
        if (isRecipientCobranding != null) {
            parameters.put("isRecipientCobranding", isRecipientCobranding.toString());
        }
        if (collectShippingAddress.booleanValue()) {
            parameters.put("collectShippingAddress", "True");
        }
        if (address != null) {
            parameters.put("addressName", address.getName());
            parameters.put("addressLine1", address.getLine1());
            parameters.put("addressLine2", address.getLine2());
            parameters.put("city", address.getCity());
            parameters.put("zip", address.getZipCode());
        }
        if (itemTotal != null) {
            parameters.put("itemTotal", itemTotal.getAmount().toString());
        }
        if (shipping != null) {
            parameters.put("shipping", shipping.getAmount().toString());
        }
        if (handling != null) {
            parameters.put("handling", handling.getAmount().toString());
        }
        if (discount != null) {
            parameters.put("discount", discount.getAmount().toString());
        }
        if (tax != null) {
            parameters.put("tax", tax.getAmount().toString());
        }
        if (giftWrapping != null) {
            parameters.put("giftWrapping", "True");
        }
        return this.generateUIPipelineURL("SingleUse", returnURL, parameters);
    }

    public String acquireMultiUseToken(String callerReference, Amount globalLimit, String returnURL, String reason) throws MalformedURLException, FPSException {
        return this.acquireMultiUseToken(callerReference, null, null, globalLimit, null, null, null, null, null, null, null, returnURL, reason);
    }

    public String acquireMultiUseToken(String callerReference, List<String> recipientTokens, AmountType amountType, Amount globalLimit, List<UsageLimit> usageLimits, Boolean isRecipientCobranding, Boolean collectShippingAddress, Address address, Date validityStart, Date validityExpiry, PaymentMethod paymentMethod, String returnURL, String reason) throws FPSException, MalformedURLException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("callerReference", callerReference);
        if (globalLimit != null) {
            parameters.put("currencyCode", globalLimit.getCurrencyCode());
        }
        if (reason != null) {
            parameters.put("paymentReason", reason);
        }
        if (recipientTokens != null && recipientTokens.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < recipientTokens.size(); ++i) {
                String token = recipientTokens.get(i);
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(token);
            }
            parameters.put("recipientTokenList", buffer.toString());
        }
        if (amountType != null) {
            parameters.put("amountType", amountType.value());
        }
        if (validityStart != null) {
            parameters.put("validityStart", DataUtils.encodeDate(validityStart));
        }
        if (validityExpiry != null) {
            parameters.put("validityExpiry", DataUtils.encodeDate(validityExpiry));
        }
        if (paymentMethod != null) {
            parameters.put("paymentMethod", paymentMethod.value());
        }
        if (usageLimits != null) {
            for (int i = 0; i < usageLimits.size(); ++i) {
                UsageLimit limit = usageLimits.get(i);
                parameters.put("usageLimitType" + i, limit.getType().value());
                if (limit.getPeriodicity() == null) continue;
                parameters.put("usageLimitPeriod" + i, limit.getPeriodicity().toString());
            }
        }
        if (isRecipientCobranding != null) {
            parameters.put("isRecipientCobranding", isRecipientCobranding.toString());
        }
        if (collectShippingAddress != null) {
            parameters.put("collectShippingAddress", collectShippingAddress.toString());
        }
        if (address != null) {
            parameters.put("addressName", address.getName());
            parameters.put("addressLine1", address.getLine1());
            parameters.put("addressLine2", address.getLine2());
            parameters.put("city", address.getCity());
            parameters.put("zip", address.getZipCode());
        }
        return this.generateUIPipelineURL("MultiUse", returnURL, parameters);
    }

    public String acquireRecurringToken(String callerReference, Amount amount, int recurringInterval, RecurringGranularity recurringGranularity, String returnURL, String reason) throws MalformedURLException, FPSException {
        return this.acquireRecurringToken(callerReference, amount, recurringInterval, recurringGranularity, null, null, null, null, null, null, null, returnURL, reason);
    }

    public String acquireRecurringToken(String callerReference, Amount amount, int recurringInterval, RecurringGranularity recurringGranularity, Date validityStart, Date validityExpiry, PaymentMethod paymentMethod, String recipientToken, Boolean isRecipientCobranding, Boolean collectShippingAddress, Address address, String returnURL, String reason) throws FPSException, MalformedURLException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("callerReference", callerReference);
        parameters.put("transactionAmount", amount.getAmount().toString());
        parameters.put("currencyCode", amount.getCurrencyCode());
        if (paymentMethod != null) {
            parameters.put("paymentMethod", paymentMethod.value());
        }
        if (recipientToken != null) {
            parameters.put("recipientToken", recipientToken);
        }
        if (reason != null) {
            parameters.put("paymentReason", reason);
        }
        if (validityStart != null) {
            parameters.put("validityStart", DataUtils.encodeDate(validityStart));
        }
        if (validityExpiry != null) {
            parameters.put("validityExpiry", DataUtils.encodeDate(validityExpiry));
        }
        String recurringPeriod = Integer.toString(recurringInterval) + " " + recurringGranularity.getValue();
        parameters.put("recurringPeriod", recurringPeriod);
        if (isRecipientCobranding != null) {
            parameters.put("isRecipientCobranding", isRecipientCobranding.toString());
        }
        if (collectShippingAddress.booleanValue()) {
            parameters.put("collectShippingAddress", "True");
        }
        if (address != null) {
            parameters.put("addressName", address.getName());
            parameters.put("addressLine1", address.getLine1());
            parameters.put("addressLine2", address.getLine2());
            parameters.put("city", address.getCity());
            parameters.put("zip", address.getZipCode());
        }
        return this.generateUIPipelineURL("Recurring", returnURL, parameters);
    }

    public String acquireRecipientToken(String callerReference, Boolean recipientPaysFee, String returnURL, String reason) throws FPSException, MalformedURLException {
        return this.acquireRecipientToken(callerReference, null, null, null, recipientPaysFee, null, null, null, returnURL, reason);
    }

    public String acquireRecipientToken(String callerReference, Date validityStart, Date validityExpiry, PaymentMethod paymentMethod, Boolean recipientPaysFee, String callerReferenceRefund, Long maxVariableFee, Long maxFixedFee, String returnURL, String reason) throws FPSException, MalformedURLException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("callerReference", callerReference);
        parameters.put("recipientPaysFee", recipientPaysFee != false ? "True" : "False");
        if (validityStart != null) {
            parameters.put("validityStart", DataUtils.encodeDate(validityStart));
        }
        if (validityExpiry != null) {
            parameters.put("validityExpiry", DataUtils.encodeDate(validityExpiry));
        }
        if (paymentMethod != null) {
            parameters.put("paymentMethod", paymentMethod.value());
        }
        if (callerReferenceRefund != null) {
            parameters.put("callerReferenceRefund", callerReferenceRefund);
        }
        if (maxVariableFee != null) {
            parameters.put("maxVariableFee", maxVariableFee.toString());
        }
        if (maxFixedFee != null) {
            parameters.put("maxFixedFee", maxFixedFee.toString());
        }
        return this.generateUIPipelineURL("Recipient", returnURL, parameters);
    }

    public String acquirePrepaidToken(String callerReferenceSender, String callerReferenceFunding, Amount amount, String returnURL, String reason) throws FPSException, MalformedURLException {
        return this.acquirePrepaidToken(callerReferenceSender, callerReferenceFunding, amount, null, null, null, null, null, returnURL, reason);
    }

    public String acquirePrepaidToken(String callerReferenceSender, String callerReferenceFunding, Amount amount, PaymentMethod paymentMethod, Date validityStart, Date validityExpiry, Boolean collectShippingAddress, Address address, String returnURL, String reason) throws FPSException, MalformedURLException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("callerReferenceSender", callerReferenceSender);
        parameters.put("callerReferenceFunding", callerReferenceFunding);
        parameters.put("currencyCode", amount.getCurrencyCode());
        parameters.put("transactionAmount", amount.getAmount().toString());
        if (reason != null) {
            parameters.put("paymentReason", reason);
        }
        if (validityStart != null) {
            parameters.put("validityStart", DataUtils.encodeDate(validityStart));
        }
        if (validityExpiry != null) {
            parameters.put("validityExpiry", DataUtils.encodeDate(validityExpiry));
        }
        if (paymentMethod != null) {
            parameters.put("paymentMethod", paymentMethod.value());
        }
        if (collectShippingAddress != null) {
            parameters.put("collectShippingAddress", collectShippingAddress.toString());
        }
        if (address != null) {
            parameters.put("addressName", address.getName());
            parameters.put("addressLine1", address.getLine1());
            parameters.put("addressLine2", address.getLine2());
            parameters.put("city", address.getCity());
            parameters.put("zip", address.getZipCode());
        }
        return this.generateUIPipelineURL("SetupPrepaid", returnURL, parameters);
    }

    public String acquirePostPaidToken(String callerReferenceSender, String callerReferenceSettlement, Amount creditLimit, Amount globalAmountLimit, String returnURL, String reason) throws FPSException, MalformedURLException {
        return this.acquirePostPaidToken(callerReferenceSender, callerReferenceSettlement, null, null, creditLimit, globalAmountLimit, null, null, null, null, returnURL, reason);
    }

    public String acquirePostPaidToken(String callerReferenceSender, String callerReferenceSettlement, Amount creditLimit, Amount globalAmountLimit, PaymentMethod paymentMethod, String returnURL, String reason) throws FPSException, MalformedURLException {
        return this.acquirePostPaidToken(callerReferenceSender, callerReferenceSettlement, null, null, creditLimit, globalAmountLimit, null, null, null, paymentMethod, returnURL, reason);
    }

    public String acquirePostPaidToken(String callerReferenceSender, String callerReferenceSettlement, Date validityStart, Date validityExpiry, Amount creditLimit, Amount globalAmountLimit, List<UsageLimit> usageLimits, Boolean collectShippingAddress, Address address, PaymentMethod paymentMethod, String returnURL, String reason) throws FPSException, MalformedURLException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("callerReferenceSender", callerReferenceSender);
        parameters.put("callerReferenceSettlement", callerReferenceSettlement);
        if (validityStart != null) {
            parameters.put("validityStart", DataUtils.encodeDate(validityStart));
        }
        if (validityExpiry != null) {
            parameters.put("validityExpiry", DataUtils.encodeDate(validityExpiry));
        }
        parameters.put("currencyCode", creditLimit.getCurrencyCode());
        parameters.put("creditLimit", creditLimit.getAmount().toString());
        parameters.put("globalAmountLimit", globalAmountLimit.getAmount().toString());
        if (paymentMethod != null) {
            parameters.put("paymentMethod", paymentMethod.value());
        }
        if (reason != null) {
            parameters.put("paymentReason", reason);
        }
        if (usageLimits != null) {
            for (int i = 0; i < usageLimits.size(); ++i) {
                UsageLimit limit = usageLimits.get(i);
                parameters.put("usageLimitType" + i, limit.getType().value());
                if (limit.getPeriodicity() == null) continue;
                parameters.put("usageLimitPeriod" + i, limit.getPeriodicity().toString());
            }
        }
        if (collectShippingAddress != null) {
            parameters.put("collectShippingAddress", collectShippingAddress.toString());
        }
        if (address != null) {
            parameters.put("addressName", address.getName());
            parameters.put("addressLine1", address.getLine1());
            parameters.put("addressLine2", address.getLine2());
            parameters.put("city", address.getCity());
            parameters.put("zip", address.getZipCode());
        }
        return this.generateUIPipelineURL("SetupPostpaid", returnURL, parameters);
    }

    public String acquireEditToken(String callerReference, String tokenID, PaymentMethod paymentMethod, String returnURL) throws FPSException, MalformedURLException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("callerReference", callerReference);
        parameters.put("tokenID", tokenID);
        if (paymentMethod != null) {
            parameters.put("paymentMethod", paymentMethod.value());
        }
        return this.generateUIPipelineURL("EditToken", returnURL, parameters);
    }

    public String generateUIPipelineURL(String pipelineName, String returnURL, Map<String, String> params) throws MalformedURLException {
        TreeMap<String, String> parameters = new TreeMap<String, String>(params);
        parameters.put("callerKey", super.getAwsAccessKeyId());
        parameters.put("pipelineName", pipelineName);
        parameters.put("returnURL", returnURL);
        StringBuffer url = new StringBuffer(this.uiPipeline);
        boolean first = true;
        for (Map.Entry parameter : parameters.entrySet()) {
            if (first) {
                url.append('?');
                first = false;
            } else {
                url.append('&');
            }
            url.append(this.urlencode((String)parameter.getKey())).append("=").append(this.urlencode((String)parameter.getValue()));
        }
        URL rawURL = new URL(url.toString());
        StringBuilder toBeSigned = new StringBuilder(rawURL.getPath()).append('?').append(rawURL.getQuery());
        String signature = this.urlencode(this.encode(this.getSecretAccessKey(), toBeSigned.toString(), false));
        url.append("&awsSignature=").append(signature);
        return url.toString();
    }

    public SingleUseInstrument extractSingleUseTokenFromCBUI(HttpServletRequest request) throws MalformedURLException, FPSException {
        String status = request.getParameter("status");
        String errorMessage = request.getParameter("errorMessage");
        String requestID = request.getParameter("RequestId");
        if ("SE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("A".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("CE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("PE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("NP".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("NM".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Status: " + status));
            logger.debug((Object)("Error Message: " + errorMessage));
        }
        if (!this.isSignatureValid(request)) {
            throw new InvalidSignatureException(request.getParameter("awsSignature"), request.getRequestURI());
        }
        Date expiry = null;
        try {
            String expiryValue = request.getParameter("expiry");
            if (expiryValue != null) {
                expiry = DataUtils.decodeDate(expiryValue);
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        return new SingleUseInstrument(request.getParameter("tokenID"), expiry, new Address(request.getParameter("addressName"), request.getParameter("addressLine1"), request.getParameter("addressLine2"), request.getParameter("city"), request.getParameter("state"), request.getParameter("zip")));
    }

    public MultiUseInstrument extractMultiUseTokenFromCBUI(HttpServletRequest request) throws MalformedURLException, FPSException {
        String status = request.getParameter("status");
        String errorMessage = request.getParameter("errorMessage");
        String requestID = request.getParameter("RequestId");
        if ("SE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("A".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("CE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("PE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("NP".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("NM".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Status: " + status));
            logger.debug((Object)("Error Message: " + errorMessage));
        }
        if (!this.isSignatureValid(request)) {
            throw new InvalidSignatureException(request.getParameter("awsSignature"), request.getRequestURI());
        }
        Date expiry = null;
        try {
            String expiryValue = request.getParameter("expiry");
            if (expiryValue != null) {
                expiry = DataUtils.decodeDate(expiryValue);
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        return new MultiUseInstrument(request.getParameter("tokenID"), expiry, new Address(request.getParameter("addressName"), request.getParameter("addressLine1"), request.getParameter("addressLine2"), request.getParameter("city"), request.getParameter("state"), request.getParameter("zip")));
    }

    public RecurringInstrument extractRecurringTokenFromCBUI(HttpServletRequest request) throws MalformedURLException, FPSException {
        String status = request.getParameter("status");
        String errorMessage = request.getParameter("errorMessage");
        String requestID = request.getParameter("RequestId");
        if ("SE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("A".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("CE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("PE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("NP".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("NM".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Status: " + status));
            logger.debug((Object)("Error Message: " + errorMessage));
        }
        if (!this.isSignatureValid(request)) {
            throw new InvalidSignatureException(request.getParameter("awsSignature"), request.getRequestURI());
        }
        Date expiry = null;
        try {
            String expiryValue = request.getParameter("expiry");
            if (expiryValue != null) {
                expiry = DataUtils.decodeDate(expiryValue);
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        return new RecurringInstrument(request.getParameter("tokenID"), expiry, new Address(request.getParameter("addressName"), request.getParameter("addressLine1"), request.getParameter("addressLine2"), request.getParameter("city"), request.getParameter("state"), request.getParameter("zip")));
    }

    public RecipientInstrument extractRecipientTokenFromCBUI(HttpServletRequest request) throws MalformedURLException, FPSException {
        String status = request.getParameter("status");
        String errorMessage = request.getParameter("errorMessage");
        String requestID = request.getParameter("RequestId");
        if ("SE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("A".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("CE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("PE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("NP".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("NM".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Status: " + status));
            logger.debug((Object)("Error Message: " + errorMessage));
        }
        if (!this.isSignatureValid(request)) {
            throw new InvalidSignatureException(request.getParameter("awsSignature"), request.getRequestURI());
        }
        return new RecipientInstrument(request.getParameter("tokenID"), request.getParameter("refundTokenID"));
    }

    public PrepaidInstrument extractPrepaidTokenFromCBUI(HttpServletRequest request) throws MalformedURLException, FPSException {
        String status = request.getParameter("status");
        String errorMessage = request.getParameter("errorMessage");
        String requestID = request.getParameter("RequestId");
        if ("SE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("A".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("CE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("PE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("NP".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("NM".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Status: " + status));
            logger.debug((Object)("Error Message: " + errorMessage));
        }
        if (!this.isSignatureValid(request)) {
            throw new InvalidSignatureException(request.getParameter("awsSignature"), request.getRequestURI());
        }
        Date expiry = null;
        try {
            String expiryValue = request.getParameter("expiry");
            if (expiryValue != null) {
                expiry = DataUtils.decodeDate(expiryValue);
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        return new PrepaidInstrument(request.getParameter("prepaidInstrumentID"), request.getParameter("fundingTokenID"), request.getParameter("prepaidSenderTokenID"), expiry, new Address(request.getParameter("addressName"), request.getParameter("addressLine1"), request.getParameter("addressLine2"), request.getParameter("city"), request.getParameter("state"), request.getParameter("zip")));
    }

    public PostPaidInstrument extractPostPaidTokenFromCBUI(HttpServletRequest request) throws MalformedURLException, FPSException {
        String status = request.getParameter("status");
        String errorMessage = request.getParameter("errorMessage");
        String requestID = request.getParameter("RequestId");
        if ("SE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("A".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("CE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("PE".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("NP".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if ("NM".equals(status)) {
            throw new FPSException(requestID, status, errorMessage);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Status: " + status));
            logger.debug((Object)("Error Message: " + errorMessage));
        }
        if (!this.isSignatureValid(request)) {
            throw new InvalidSignatureException(request.getParameter("awsSignature"), request.getRequestURI());
        }
        Date expiry = null;
        try {
            String expiryValue = request.getParameter("expiry");
            if (expiryValue != null) {
                expiry = DataUtils.decodeDate(expiryValue);
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        return new PostPaidInstrument(request.getParameter("creditInstrumentID"), request.getParameter("creditSenderTokenID"), request.getParameter("settlementTokenID"), expiry, new Address(request.getParameter("addressName"), request.getParameter("addressLine1"), request.getParameter("addressLine2"), request.getParameter("city"), request.getParameter("state"), request.getParameter("zip")));
    }

    public boolean isSignatureValid(HttpServletRequest request) throws MalformedURLException {
        String signature = this.urlencode(request.getParameter("awsSignature"));
        if (signature == null) {
            return false;
        }
        ArrayList parameters = new ArrayList(request.getParameterMap().keySet());
        Collator stringCollator = Collator.getInstance();
        stringCollator.setStrength(0);
        Collections.sort(parameters, stringCollator);
        parameters.remove("awsSignature");
        StringBuffer url = new StringBuffer(request.getRequestURL());
        boolean first = true;
        for (String parameter : parameters) {
            if (first) {
                url.append('?');
                first = false;
            } else {
                url.append('&');
            }
            url.append(this.urlencode(parameter)).append("=").append(this.urlencode(request.getParameter(parameter)));
        }
        URL rawURL = new URL(url.toString());
        StringBuilder toBeSigned = new StringBuilder(rawURL.getPath()).append('?').append(rawURL.getQuery());
        String ourSignature = this.urlencode(this.encode(this.getSecretAccessKey(), toBeSigned.toString(), false));
        ourSignature = ourSignature.replaceAll("%2B", "+");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AWS sig: " + signature));
            logger.debug((Object)("Our sig: " + ourSignature));
        }
        return ourSignature.equals(signature);
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws FPSException {
        try {
            T response = this.makeRequest(method, action, params, respType);
            Class<?> responseClass = response.getClass();
            ResponseStatus status = (ResponseStatus)((Object)responseClass.getMethod("getStatus", new Class[0]).invoke(response, new Object[0]));
            if (ResponseStatus.FAILURE.equals((Object)status)) {
                String requestID = (String)responseClass.getMethod("getRequestId", new Class[0]).invoke(response, new Object[0]);
                ServiceErrors rawErrors = (ServiceErrors)responseClass.getMethod("getErrors", new Class[0]).invoke(response, new Object[0]);
                ArrayList<FPSError> errors = new ArrayList<FPSError>(rawErrors.getErrors().size());
                for (ServiceError error : rawErrors.getErrors()) {
                    AWSError.ErrorType type = null;
                    switch (error.getErrorType()) {
                        case BUSINESS: {
                            type = AWSError.ErrorType.SENDER;
                            break;
                        }
                        case SYSTEM: {
                            type = AWSError.ErrorType.RECEIVER;
                        }
                    }
                    errors.add(new FPSError(type, error.getErrorCode(), error.getReasonText(), error.isIsRetriable()));
                }
                throw new FPSException(requestID, errors);
            }
            return response;
        }
        catch (AWSException ex) {
            throw new FPSException(ex);
        }
        catch (JAXBException ex) {
            throw new FPSException("Problem parsing returned message.", ex);
        }
        catch (SAXException ex) {
            throw new FPSException("Problem parsing returned message.", ex);
        }
        catch (HttpException ex) {
            throw new FPSException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new FPSException(ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new FPSException(ex.getMessage(), ex);
        }
        catch (NoSuchMethodException ex) {
            throw new FPSException(ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new FPSException(ex.getMessage(), ex);
        }
    }

    static void setVersionHeader(AWSQueryConnection connection) {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2007-01-08");
        connection.getHeaders().put("Version", vals);
    }
}

