/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.monitoring;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.monitoring.Datapoint;
import com.xerox.amazonws.monitoring.Metric;
import com.xerox.amazonws.monitoring.MetricStatisticsResult;
import com.xerox.amazonws.monitoring.MonitoringException;
import com.xerox.amazonws.monitoring.StandardUnit;
import com.xerox.amazonws.monitoring.Statistics;
import com.xerox.amazonws.typica.monitor.jaxb.Dimension;
import com.xerox.amazonws.typica.monitor.jaxb.GetMetricStatisticsResponse;
import com.xerox.amazonws.typica.monitor.jaxb.GetMetricStatisticsResult;
import com.xerox.amazonws.typica.monitor.jaxb.ListMetricsResponse;
import com.xerox.amazonws.typica.monitor.jaxb.ListMetricsResult;
import com.xerox.amazonws.typica.monitor.jaxb.Metrics;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Monitoring
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(Monitoring.class);
    private static String dateFormat = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public Monitoring(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public Monitoring(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "monitoring.amazonaws.com");
    }

    public Monitoring(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public Monitoring(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2009-05-15");
        this.headers.put("Version", vals);
    }

    public MetricStatisticsResult getMetricStatistics(int period, List<Statistics> statistics, String namespace, Map<String, String> dimensions, Date startTime, Date endTime, String measureName, StandardUnit unit, String customUnit) throws MonitoringException {
        int i;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Period", "" + period);
        params.put("Namespace", namespace);
        SimpleDateFormat dateFormatter = new SimpleDateFormat(dateFormat);
        params.put("StartTime", dateFormatter.format(startTime));
        params.put("EndTime", dateFormatter.format(endTime));
        for (i = 0; i < statistics.size(); ++i) {
            params.put("Statistics.member." + (i + 1), statistics.get(i).getStatId());
        }
        if (unit != null) {
            params.put("Unit", unit.getUnitId());
        }
        if (customUnit != null && !customUnit.equals("")) {
            params.put("CustomUnit", customUnit);
        }
        if (dimensions != null && dimensions.size() > 0) {
            i = 0;
            for (String key : dimensions.keySet()) {
                String value = dimensions.get(key);
                params.put("Dimensions.member." + (i + 1) + ".Name", key);
                params.put("Dimensions.member." + (i + 1) + ".Value", value);
                ++i;
            }
        }
        params.put("MeasureName", measureName);
        HttpGet method = new HttpGet();
        GetMetricStatisticsResponse response = this.makeRequestInt((HttpRequestBase)method, "GetMetricStatistics", params, GetMetricStatisticsResponse.class);
        GetMetricStatisticsResult result = response.getGetMetricStatisticsResult();
        MetricStatisticsResult ret = new MetricStatisticsResult(result.getLabel());
        List<Datapoint> dpList = ret.getDatapoints();
        List<com.xerox.amazonws.typica.monitor.jaxb.Datapoint> dps = result.getDatapoints().getMembers();
        for (com.xerox.amazonws.typica.monitor.jaxb.Datapoint dp : dps) {
            dpList.add(new Datapoint(dp.getTimestamp().toGregorianCalendar(), dp.getSamples(), dp.getAverage(), dp.getSum(), dp.getMinimum(), dp.getMaximum(), dp.getUnit(), dp.getCustomUnit()));
        }
        return ret;
    }

    public List<Metric> listMetrics() throws MonitoringException {
        ListMetricsResult result;
        HashMap<String, String> params = new HashMap<String, String>();
        HttpGet method = new HttpGet();
        ArrayList<Metric> ret = new ArrayList<Metric>();
        String nextToken = null;
        do {
            if (nextToken != null) {
                params.put("NextToken", nextToken);
            }
            ListMetricsResponse response = this.makeRequestInt((HttpRequestBase)method, "ListMetrics", params, ListMetricsResponse.class);
            result = response.getListMetricsResult();
            Metrics mtrx = result.getMetrics();
            for (com.xerox.amazonws.typica.monitor.jaxb.Metric m : mtrx.getMembers()) {
                Metric met = new Metric(m.getMeasureName(), m.getNamespace());
                for (Dimension d : m.getDimensions().getMembers()) {
                    met.addDimension(d.getName(), d.getValue());
                }
                ret.add(met);
            }
        } while ((nextToken = result.getNextToken()) != null);
        return ret;
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws MonitoringException {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new MonitoringException(ex);
        }
        catch (JAXBException ex) {
            throw new MonitoringException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new MonitoringException("Problem parsing returned message.", ex);
        }
        catch (MalformedURLException ex) {
            throw new MonitoringException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new MonitoringException(ex.getMessage(), ex);
        }
        catch (HttpException ex) {
            throw new MonitoringException(ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

