/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sdb;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sdb.Domain;
import com.xerox.amazonws.sdb.ListDomainsResult;
import com.xerox.amazonws.sdb.SDBException;
import com.xerox.amazonws.typica.sdb.jaxb.CreateDomainResponse;
import com.xerox.amazonws.typica.sdb.jaxb.DeleteDomainResponse;
import com.xerox.amazonws.typica.sdb.jaxb.ListDomainsResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDB
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(SimpleDB.class);

    public SimpleDB(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public SimpleDB(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "sdb.amazonaws.com");
    }

    public SimpleDB(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public SimpleDB(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        SimpleDB.setVersionHeader(this);
    }

    @Override
    public int getSignatureVersion() {
        return super.getSignatureVersion();
    }

    @Override
    public void setSignatureVersion(int version) {
        super.setSignatureVersion(version);
    }

    public ListDomainsResult listDomains() throws SDBException {
        return this.listDomains(null);
    }

    public ListDomainsResult listDomains(String nextToken) throws SDBException {
        return this.listDomains(nextToken, 0);
    }

    public Domain createDomain(String name) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", name);
        HttpGet method = new HttpGet();
        CreateDomainResponse response = this.makeRequestInt((HttpRequestBase)method, "CreateDomain", params, CreateDomainResponse.class);
        Domain ret = new Domain(name, this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer(), this.getPort());
        ret.setSignatureVersion(this.getSignatureVersion());
        ret.setHttpClient(this.getHttpClient());
        return ret;
    }

    public void deleteDomain(Domain domain) throws SDBException {
        this.deleteDomain(domain.getName());
    }

    public void deleteDomain(String name) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", name);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "DeleteDomain", params, DeleteDomainResponse.class);
    }

    public Domain getDomain(String domainName) throws SDBException {
        Domain ret = new Domain(domainName, this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer(), this.getPort());
        ret.setSignatureVersion(this.getSignatureVersion());
        ret.setHttpClient(this.getHttpClient());
        return ret;
    }

    public ListDomainsResult listDomains(String nextToken, int maxResults) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (nextToken != null) {
            params.put("NextToken", nextToken);
        }
        if (maxResults > 0) {
            params.put("MaxNumberOfDomains", "" + maxResults);
        }
        HttpGet method = new HttpGet();
        ListDomainsResponse response = this.makeRequestInt((HttpRequestBase)method, "ListDomains", params, ListDomainsResponse.class);
        return new ListDomainsResult(response.getListDomainsResult().getNextToken(), response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage(), Domain.createList(response.getListDomainsResult().getDomainNames().toArray(new String[0]), this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer(), this.getPort(), this.getSignatureVersion(), this.getHttpClient()));
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws SDBException {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new SDBException(ex);
        }
        catch (JAXBException ex) {
            throw new SDBException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new SDBException("Problem parsing returned message.", ex);
        }
        catch (HttpException ex) {
            throw new SDBException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SDBException(ex.getMessage(), ex);
        }
    }

    static void setVersionHeader(AWSQueryConnection connection) {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2009-04-15");
        connection.getHeaders().put("Version", vals);
    }
}

