/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sqs2;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sqs2.Message;
import com.xerox.amazonws.sqs2.QueueAttribute;
import com.xerox.amazonws.sqs2.QueueService;
import com.xerox.amazonws.sqs2.SQSException;
import com.xerox.amazonws.typica.sqs2.jaxb.AddPermissionResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.Attribute;
import com.xerox.amazonws.typica.sqs2.jaxb.ChangeMessageVisibilityResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.DeleteMessageResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.DeleteQueueResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.GetQueueAttributesResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.ReceiveMessageResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.RemovePermissionResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.SendMessageResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.SetQueueAttributesResponse;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageQueue
extends AWSQueryConnection {
    public static final int MAX_MESSAGES = 600;
    protected String queueId;
    private boolean enableEncoding = true;

    protected MessageQueue(String queueUrl, String awsAccessId, String awsSecretKey, boolean isSecure, int port, String server) throws SQSException {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        this.queueId = queueUrl.startsWith("http") ? queueUrl.substring(queueUrl.indexOf("//") + 2) : queueUrl;
        this.queueId = this.queueId.substring(this.queueId.indexOf("/") + 1);
        QueueService.setVersionHeader(this);
    }

    @Override
    public URL getUrl() {
        try {
            return new URL(super.getUrl().toString());
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public boolean isEncoding() {
        return this.enableEncoding;
    }

    public void setEncoding(boolean enable) {
        this.enableEncoding = enable;
    }

    public String sendMessage(String msg) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        String encodedMsg = this.enableEncoding ? new String(Base64.encodeBase64((byte[])msg.getBytes())) : msg;
        params.put("MessageBody", encodedMsg);
        HttpPost method = new HttpPost();
        SendMessageResponse response = this.makeRequestInt((HttpRequestBase)method, "SendMessage", params, SendMessageResponse.class);
        return response.getSendMessageResult().getMessageId();
    }

    public Message receiveMessage() throws SQSException {
        Message[] amessage = this.receiveMessages(BigInteger.valueOf(1L), null, null);
        if (amessage.length > 0) {
            return amessage[0];
        }
        return null;
    }

    public Message receiveMessage(int visibilityTimeout) throws SQSException {
        Message[] amessage = this.receiveMessages(BigInteger.valueOf(1L), BigInteger.valueOf(visibilityTimeout), null);
        if (amessage.length > 0) {
            return amessage[0];
        }
        return null;
    }

    public Message[] receiveMessages(int numMessages) throws SQSException {
        return this.receiveMessages(BigInteger.valueOf(numMessages), null, null);
    }

    public Message[] receiveMessages(int numMessages, int visibilityTimeout) throws SQSException {
        return this.receiveMessages(BigInteger.valueOf(numMessages), BigInteger.valueOf(visibilityTimeout), null);
    }

    public Message[] receiveMessages(int numMessages, int visibilityTimeout, List<String> attributes) throws SQSException {
        return this.receiveMessages(BigInteger.valueOf(numMessages), BigInteger.valueOf(visibilityTimeout), attributes);
    }

    protected Message[] receiveMessages(BigInteger numMessages, BigInteger visibilityTimeout, List<String> attributes) throws SQSException {
        HttpGet method;
        ReceiveMessageResponse response;
        HashMap<String, String> params = new HashMap<String, String>();
        if (numMessages != null) {
            params.put("MaxNumberOfMessages", numMessages.toString());
        }
        if (visibilityTimeout != null) {
            params.put("VisibilityTimeout", visibilityTimeout.toString());
        }
        if (attributes != null) {
            int i = 1;
            for (String attr : attributes) {
                params.put("AttributeName." + i, attr);
                ++i;
            }
        }
        if ((response = this.makeRequestInt((HttpRequestBase)(method = new HttpGet()), "ReceiveMessage", params, ReceiveMessageResponse.class)).getReceiveMessageResult().getMessages() == null) {
            return new Message[0];
        }
        ArrayList<Message> msgs = new ArrayList<Message>();
        for (com.xerox.amazonws.typica.sqs2.jaxb.Message msg : response.getReceiveMessageResult().getMessages()) {
            String decodedMsg = this.enableEncoding ? new String(Base64.decodeBase64((byte[])msg.getBody().getBytes())) : msg.getBody();
            Message newMsg = new Message(msg.getMessageId(), msg.getReceiptHandle(), decodedMsg, msg.getMD5OfBody());
            for (Attribute attr : msg.getAttributes()) {
                newMsg.setAttribute(attr.getName(), attr.getValue());
            }
            msgs.add(newMsg);
        }
        return msgs.toArray(new Message[msgs.size()]);
    }

    public void deleteMessage(Message msg) throws SQSException {
        this.deleteMessage(msg.getReceiptHandle());
    }

    public void deleteMessage(String receiptHandle) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ReceiptHandle", receiptHandle);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "DeleteMessage", params, DeleteMessageResponse.class);
    }

    public void deleteQueue() throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "DeleteQueue", params, DeleteQueueResponse.class);
    }

    public void setMessageVisibilityTimeout(Message msg, int timeout) throws SQSException {
        this.setMessageVisibilityTimeout(msg.getReceiptHandle(), timeout);
    }

    public void setMessageVisibilityTimeout(String receiptHandle, int timeout) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ReceiptHandle", receiptHandle);
        params.put("VisibilityTimeout", "" + timeout);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "ChangeMessageVisibility", params, ChangeMessageVisibilityResponse.class);
    }

    public int getVisibilityTimeout() throws SQSException {
        return Integer.parseInt(this.getQueueAttributes(QueueAttribute.VISIBILITY_TIMEOUT).values().iterator().next());
    }

    public int getApproximateNumberOfMessages() throws SQSException {
        return Integer.parseInt(this.getQueueAttributes(QueueAttribute.APPROXIMATE_NUMBER_OF_MESSAGES).values().iterator().next());
    }

    public Map<String, String> getQueueAttributes(QueueAttribute qAttr) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("AttributeName", qAttr.queryAttribute());
        HttpGet method = new HttpGet();
        GetQueueAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "GetQueueAttributes", params, GetQueueAttributesResponse.class);
        HashMap<String, String> ret = new HashMap<String, String>();
        List<Attribute> attrs = response.getGetQueueAttributesResult().getAttributes();
        for (Attribute attr : attrs) {
            ret.put(attr.getName(), attr.getValue());
        }
        return ret;
    }

    public void setVisibilityTimeout(int timeout) throws SQSException {
        this.setQueueAttribute("VisibilityTimeout", "" + timeout);
    }

    public void setQueueAttribute(String attribute, String value) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Attribute.Name", attribute);
        params.put("Attribute.Value", value);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "SetQueueAttributes", params, SetQueueAttributesResponse.class);
    }

    public void addPermission(String label, String accountId, String action) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Label", label);
        params.put("AWSAccountId", accountId);
        params.put("ActionName", action);
        HttpGet method = new HttpGet();
        AddPermissionResponse response = this.makeRequestInt((HttpRequestBase)method, "AddPermission", params, AddPermissionResponse.class);
    }

    public void removePermission(String label) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Label", label);
        HttpGet method = new HttpGet();
        RemovePermissionResponse response = this.makeRequestInt((HttpRequestBase)method, "RemovePermission", params, RemovePermissionResponse.class);
    }

    @Override
    protected URL makeURL(String resource) throws MalformedURLException {
        return super.makeURL(this.queueId + resource);
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws SQSException {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new SQSException(ex);
        }
        catch (JAXBException ex) {
            throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new SQSException("Problem parsing returned message.", ex);
        }
        catch (HttpException ex) {
            throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SQSException(ex.getMessage(), ex);
        }
    }

    public static List<MessageQueue> createList(String[] queueUrls, String awsAccessId, String awsSecretKey, boolean isSecure, int port, String server, HttpClient hc) throws SQSException {
        ArrayList<MessageQueue> ret = new ArrayList<MessageQueue>();
        for (int i = 0; i < queueUrls.length; ++i) {
            MessageQueue mq = new MessageQueue(queueUrls[i], awsAccessId, awsSecretKey, isSecure, port, server);
            mq.setHttpClient(hc);
            ret.add(mq);
        }
        return ret;
    }
}

