/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sqs2;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sqs2.MessageQueue;
import com.xerox.amazonws.sqs2.SQSException;
import com.xerox.amazonws.typica.sqs2.jaxb.CreateQueueResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.ListQueuesResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueService
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(QueueService.class);

    public QueueService(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public QueueService(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "queue.amazonaws.com");
    }

    public QueueService(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public QueueService(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        QueueService.setVersionHeader(this);
    }

    public MessageQueue getOrCreateMessageQueue(String queueName) throws SQSException {
        return this.getOrCreateMessageQueue(queueName, -1);
    }

    public MessageQueue getOrCreateMessageQueue(String queueName, int timeout) throws SQSException {
        if (queueName.charAt(0) == '/' && queueName.lastIndexOf(47) > 0 || queueName.startsWith("http")) {
            return this.getMessageQueue(queueName);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("QueueName", queueName);
        if (timeout >= 0) {
            params.put("DefaultVisibilityTimeout", "" + timeout);
        }
        HttpGet method = new HttpGet();
        CreateQueueResponse response = this.makeRequestInt((HttpRequestBase)method, "CreateQueue", params, CreateQueueResponse.class);
        MessageQueue ret = new MessageQueue(response.getCreateQueueResult().getQueueUrl(), this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getPort(), this.getServer());
        ret.setHttpClient(this.getHttpClient());
        return ret;
    }

    public MessageQueue getMessageQueue(String queueName) throws SQSException {
        if (!(queueName.charAt(0) == '/' && queueName.lastIndexOf(47) > 0 || queueName.startsWith("http"))) {
            throw new IllegalArgumentException("Queue name must be more fully specified or use getOrCreateMessageQueue().");
        }
        MessageQueue ret = new MessageQueue(queueName, this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getPort(), this.getServer());
        ret.setHttpClient(this.getHttpClient());
        return ret;
    }

    public List<MessageQueue> listMessageQueues(String queueNamePrefix) throws SQSException {
        HttpGet method;
        ListQueuesResponse response;
        List<String> urls;
        HashMap<String, String> params = new HashMap<String, String>();
        if (queueNamePrefix != null && !queueNamePrefix.trim().equals("")) {
            params.put("QueueNamePrefix", queueNamePrefix);
        }
        if ((urls = (response = this.makeRequestInt((HttpRequestBase)(method = new HttpGet()), "ListQueues", params, ListQueuesResponse.class)).getListQueuesResult().getQueueUrls()) == null || urls.size() == 0) {
            return new ArrayList<MessageQueue>();
        }
        return MessageQueue.createList(urls.toArray(new String[urls.size()]), this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getPort(), this.getServer(), this.getHttpClient());
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws SQSException {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new SQSException(ex);
        }
        catch (JAXBException ex) {
            throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new SQSException("Problem parsing returned message.", ex);
        }
        catch (HttpException ex) {
            throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SQSException(ex.getMessage(), ex);
        }
    }

    static void setVersionHeader(AWSQueryConnection connection) {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2009-02-01");
        connection.getHeaders().put("Version", vals);
    }
}

