/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sqs2;

import com.xerox.amazonws.sqs2.MessageQueue;
import com.xerox.amazonws.sqs2.QueueService;
import com.xerox.amazonws.sqs2.SQSException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQSUtils {
    private static Log logger = LogFactory.getLog(SQSUtils.class);

    public static MessageQueue connectToQueue(String queueName, String accessKey, String secretKey) throws SQSException {
        return SQSUtils.connectToQueue(null, queueName, accessKey, secretKey);
    }

    public static MessageQueue connectToQueue(String serverName, String queueName, String accessKey, String secretKey) throws SQSException {
        QueueService service = SQSUtils.getQueueService(accessKey, secretKey, serverName);
        return SQSUtils.getMessageQueue(service, queueName);
    }

    public static QueueService getQueueService(String accessKey, String secretKey, String serverName) throws SQSException {
        QueueService service = null;
        service = serverName != null ? new QueueService(accessKey, secretKey, true, serverName) : new QueueService(accessKey, secretKey);
        if (service.getUrl() != null) {
            logger.debug((Object)("Service: " + service.getUrl().toString()));
        } else {
            logger.error((Object)"Service: null url!");
        }
        return service;
    }

    public static MessageQueue getMessageQueue(QueueService service, String msgQueueName) throws SQSException {
        MessageQueue msgQueue = null;
        MessageQueue msgQueueFound = null;
        List<MessageQueue> msgQueuesFound = service.listMessageQueues(null);
        for (MessageQueue mq : msgQueuesFound) {
            if (!mq.getUrl().toString().endsWith(msgQueueName)) continue;
            msgQueueFound = mq;
        }
        if (msgQueueFound == null) {
            logger.debug((Object)"Message queue couldn't be listed, going to create it.");
            msgQueue = service.getOrCreateMessageQueue(msgQueueName.substring(msgQueueName.lastIndexOf("/") + 1));
        } else if (msgQueue == null) {
            msgQueue = msgQueueFound;
        }
        if (msgQueue == null) {
            logger.error((Object)("Couldn't find message queue " + msgQueueName));
        } else {
            logger.debug((Object)("Using message queue resource at " + msgQueue.getUrl()));
        }
        return msgQueue;
    }

    public static MessageQueue getQueueOrElse(QueueService qs, String queueName) {
        MessageQueue ret = null;
        while (ret == null) {
            try {
                ret = qs.getOrCreateMessageQueue(queueName);
            }
            catch (SQSException ex) {
                logger.error((Object)"Error access message queue, Retrying.", (Throwable)ex);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException iex) {}
            }
        }
        return ret;
    }

    public static void sendMessageForSure(MessageQueue queue, String message) {
        while (true) {
            try {
                queue.sendMessage(message);
                return;
            }
            catch (SQSException ex) {
                logger.warn((Object)"Error sending message, Retrying.");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }
}

