/*
 * Decompiled with CFR 0.152.
 */
package de.jw.cloud42.core.remoting;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import de.jw.cloud42.core.domain.AwsCredentials;
import de.jw.cloud42.core.domain.RemoteResult;
import de.jw.cloud42.core.domain.Settings;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;

public class RemoteControl {
    private final String TEMP_REMOTE_FOLDER = "/tmp";
    private final String TEMP_BATCH_FILENAME = "tmp.sh";

    public RemoteResult executeCommand(String host, String key, String command) {
        Connection conn = this.connect(host, key);
        RemoteResult result = this.exec(conn, command);
        if (conn != null) {
            conn.close();
        }
        return result;
    }

    public RemoteResult executeBatch(String host, String key, byte[] batchData) {
        Connection conn = this.connect(host, key);
        RemoteResult result = new RemoteResult();
        try {
            if (conn == null) {
                throw new IOException("Connection failed.");
            }
            RemoteResult r1 = this.doUpload(conn, batchData, "tmp.sh", "/tmp");
            if (r1.getExceptionMessage() != null) {
                throw new Exception("Uploading batch file failed due to an exception: " + r1.getExceptionMessage());
            }
            r1 = this.exec(conn, "chmod 774 /tmp/tmp.sh");
            if (!r1.getStdErr().equals("")) {
                throw new Exception("Setting rights for batch file failed: " + r1.getStdErr());
            }
            if (r1.getExceptionMessage() != null) {
                throw new Exception("Setting rights for batch file failed due to an exception: " + r1.getExceptionMessage());
            }
            result = this.exec(conn, "/tmp/tmp.sh");
        }
        catch (Exception ex) {
            result.setExceptionMessage(ex.getMessage());
        }
        this.exec(conn, "rm -f /tmp/tmp.sh");
        if (conn != null) {
            conn.close();
        }
        return result;
    }

    public RemoteResult uploadFile(String host, String key, String targetDir, String targetFilename, byte[] fileData) {
        Connection conn = this.connect(host, key);
        RemoteResult result = new RemoteResult();
        try {
            if (conn == null) {
                throw new IOException("Connection failed.");
            }
            this.exec(conn, "mkdir -p " + targetDir);
            result = this.doUpload(conn, fileData, targetFilename, targetDir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result.setExceptionMessage(ex.getMessage());
        }
        if (conn != null) {
            conn.close();
        }
        return result;
    }

    public RemoteResult uploadFileFromURL(String host, String key, String targetDir, String targetFilename, String url) {
        Connection conn = this.connect(host, key);
        RemoteResult result = new RemoteResult();
        try {
            if (conn == null) {
                throw new IOException("Connection failed.");
            }
            this.exec(conn, "mkdir -p " + targetDir);
            result = this.exec(conn, "wget " + url + " -O " + targetDir + "/" + targetFilename);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result.setExceptionMessage(ex.getMessage());
        }
        if (conn != null) {
            conn.close();
        }
        return result;
    }

    public byte[] downloadFile(String host, String key, String remoteFileName) {
        Connection conn = this.connect(host, key);
        try {
            if (conn == null) {
                throw new IOException("Connection failed.");
            }
            SCPClient scp = conn.createSCPClient();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            scp.get(remoteFileName, (OutputStream)out);
            if (conn != null) {
                conn.close();
            }
            return out.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (conn != null) {
                conn.close();
            }
            return null;
        }
    }

    public RemoteResult bundleImage(String dnsName, String key, AwsCredentials credentials, String targetBucket, String newImageName, boolean use64Bit, boolean notifyWhenFinished, String topic, String messageText, String messageInfo, byte[] keyFile, byte[] certFile) {
        Connection conn = this.connect(dnsName, key);
        RemoteResult result = new RemoteResult();
        result.setStdErr("");
        result.setStdOut("");
        result.setExitCode(0);
        try {
            if (conn == null) {
                throw new IOException("Connection failed.");
            }
            SCPClient scp = conn.createSCPClient();
            scp.put(keyFile, "pk.pem", "//mnt");
            scp.put(certFile, "cert.pem", "//mnt");
            String architecture = use64Bit ? "x86_64" : "i386";
            RemoteResult tmpResult = this.exec(conn, "ec2-bundle-vol -d //mnt -k //mnt//pk.pem -c //mnt//cert.pem -u " + credentials.getUserID() + " -r " + architecture + " -p " + newImageName);
            if (tmpResult.getExceptionMessage() != null) {
                throw new Exception("ec2-bundle-vol failed with exception: " + tmpResult.getExceptionMessage());
            }
            if (tmpResult.getExitCode() != 0) {
                throw new Exception("ec2-bundle-vol failed. Error output is: " + tmpResult.getStdErr());
            }
            tmpResult = this.exec(conn, "ec2-upload-bundle -b " + targetBucket + " -m //mnt//" + newImageName + ".manifest.xml -a " + credentials.getAwsAccessKeyId() + " -s " + credentials.getSecretAccessKey());
            if (tmpResult.getExceptionMessage() != null) {
                throw new Exception("ec2-upload-bundle failed with an exception: " + tmpResult.getExceptionMessage());
            }
            if (tmpResult.getExitCode() != 0) {
                throw new Exception("ec2-upload-bundle failed. Error output is: " + tmpResult.getStdErr());
            }
            if (notifyWhenFinished) {
                String instanceId = "";
                tmpResult = this.exec(conn, "curl http://169.254.169.254/latest/meta-data/instance-id");
                if (tmpResult.getExceptionMessage() != null) {
                    throw new Exception("Retreiving instance-id failed: " + tmpResult.getExceptionMessage());
                }
                if (tmpResult.getStdOut() != null) {
                    instanceId = tmpResult.getStdOut();
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = new Date();
                String timestamp = dateFormat.format(date);
                String message = "<message xmlns=\\\"http://cloud42.jw.de/message\\\"><topic>" + topic + "</topic>" + "<instanceId>" + instanceId + "</instanceId>" + "<timestamp>" + timestamp + "</timestamp>" + "<text>" + messageText + "</text>" + "<info>" + messageInfo + "</info>" + "</message>";
                String endpointAddress = Settings.getInstance().getEndpointAddress();
                if (endpointAddress != null) {
                    String command = "curl -H \"Content-Type: text/xml\" -i -d \"" + message + "\" " + endpointAddress;
                    tmpResult = this.exec(conn, command);
                    if (tmpResult.getExitCode() != 0) {
                        Logger.getAnonymousLogger().severe("Bundling was completed but notification could not be sent.");
                    }
                } else {
                    Logger.getAnonymousLogger().severe("No endpoint address for Cloud42 notification endpoint was found. Notification could not be sent.");
                }
                if (tmpResult.getExceptionMessage() != null) {
                    throw new Exception("Notification failed with exception: " + tmpResult.getExceptionMessage());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result.setExceptionMessage(ex.getMessage());
            result.setExitCode(1);
        }
        if (conn != null) {
            conn.close();
        }
        return result;
    }

    private Connection connect(String host, String key) {
        try {
            Connection conn = new Connection(host);
            conn.connect();
            boolean isAuthenticated = conn.authenticateWithPublicKey("root", key.toCharArray(), "");
            if (!isAuthenticated) {
                throw new IOException("Authentication failed.");
            }
            return conn;
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private RemoteResult exec(Connection conn, String command) {
        RemoteResult result = new RemoteResult();
        try {
            String line;
            if (conn == null) {
                throw new IOException("Connection failed.");
            }
            Session sess = conn.openSession();
            sess.execCommand(command);
            StreamGobbler out = new StreamGobbler(sess.getStdout());
            StreamGobbler err = new StreamGobbler(sess.getStderr());
            BufferedReader brOut = new BufferedReader(new InputStreamReader((InputStream)out));
            BufferedReader brErr = new BufferedReader(new InputStreamReader((InputStream)err));
            String outMessage = "";
            String errMessage = "";
            while ((line = brOut.readLine()) != null) {
                outMessage = outMessage + line + "\n";
            }
            while ((line = brErr.readLine()) != null) {
                errMessage = errMessage + line + "\n";
            }
            result.setStdErr(errMessage);
            result.setStdOut(outMessage);
            try {
                result.setExitCode(sess.getExitStatus().intValue());
            }
            catch (Exception ex) {
                // empty catch block
            }
            sess.close();
        }
        catch (Exception ex) {
            result.setExceptionMessage(ex.getMessage());
        }
        return result;
    }

    private RemoteResult doUpload(Connection conn, byte[] data, String fileName, String dir) {
        RemoteResult result = new RemoteResult();
        try {
            SCPClient scp = conn.createSCPClient();
            scp.put(data, fileName, dir);
            result.setExitCode(0);
        }
        catch (Exception ex) {
            result.setExceptionMessage(ex.getMessage());
            result.setExitCode(1);
        }
        return result;
    }
}

