/*
 * Decompiled with CFR 0.152.
 */
package de.jw.cloud42.core.endpoint;

import de.jw.cloud42.core.domain.Settings;
import de.jw.cloud42.core.eventing.Message;
import de.jw.cloud42.core.eventing.notification.NotificationManager;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.BindingType;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.MessageContext;

@WebServiceProvider
@BindingType(value="http://www.w3.org/2004/08/wsdl/http")
@ServiceMode(value=Service.Mode.MESSAGE)
public class Cloud42Endpoint
implements Provider<Source> {
    private final String DEFAULT_ENDPOINT_ADDRESS = "http://localhost:8084/messages";
    private static Cloud42Endpoint theInstance;
    @Resource
    protected WebServiceContext wsContext;
    private JAXBContext jc;
    Endpoint endpoint = null;

    private Cloud42Endpoint() {
        try {
            this.jc = JAXBContext.newInstance((Class[])new Class[]{Message.class});
        }
        catch (JAXBException je) {
            throw new WebServiceException("Cannot create JAXBContext", (Throwable)je);
        }
    }

    public static Cloud42Endpoint getInstance() {
        if (theInstance == null) {
            theInstance = new Cloud42Endpoint();
        }
        return theInstance;
    }

    public Source invoke(Source request) {
        MessageContext mc = this.wsContext.getMessageContext();
        String httpMethod = (String)mc.get((Object)"javax.xml.ws.http.request.method");
        if (httpMethod.equals("POST")) {
            return this.post(request, mc);
        }
        mc.put((Object)"javax.xml.ws.http.response.code", (Object)400);
        return null;
    }

    public void startEndpoint() {
        try {
            if (this.endpoint != null) {
                this.endpoint.stop();
                Logger.getAnonymousLogger().info("Currently running Cloud42 message endpoint was closed.");
            }
            this.endpoint = Endpoint.create((String)"http://www.w3.org/2004/08/wsdl/http", (Object)new Cloud42Endpoint());
            String address = this.getAddress();
            this.endpoint.publish(address);
            Logger.getAnonymousLogger().info("------------------------------------------------");
            Logger.getAnonymousLogger().info("Cloud42 message endpoint published at " + address);
            Logger.getAnonymousLogger().info("------------------------------------------------");
        }
        catch (Exception ex) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Creating Cloud42 endpoint failed: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public String getAddress() {
        String address = Settings.getInstance().getEndpointAddress();
        if (address == null) {
            address = "http://localhost:8084/messages";
            Settings.getInstance().setEndpointAddress(address);
            Settings.getInstance().save();
        }
        return address;
    }

    public void setAddress(String newAddress) {
        Settings.getInstance().setEndpointAddress(newAddress);
        Settings.getInstance().save();
        this.startEndpoint();
    }

    private Source post(Source source, MessageContext mc) {
        String replyElement;
        try {
            Unmarshaller u = this.jc.createUnmarshaller();
            Message message = (Message)u.unmarshal(source);
            Logger.getAnonymousLogger().info("Cloud42 endpoint retrieved a event message. InstanceId is: " + message.instanceId);
            mc.put((Object)"javax.xml.ws.http.response.code", (Object)202);
            replyElement = "<reply>OK</reply>";
            NotificationManager.notifySubscribers((Message)message);
        }
        catch (Exception ex) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Error parsing incoming event message: " + ex.getMessage() + ". Maybe HTTP content-type was wrong (must be text/xml) or invalid message format.");
            mc.put((Object)"javax.xml.ws.http.response.code", (Object)400);
            replyElement = "<reply>" + ex.getMessage() + "</reply>";
        }
        StreamSource reply = new StreamSource(new StringReader(replyElement));
        return reply;
    }
}

