/*
 * Decompiled with CFR 0.152.
 */
package de.jw.cloud42.core.service;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;

public class Cloud42Settings {
    private static HashMap<String, Cloud42Settings> instances = new HashMap();
    private final Logger LOG = Logger.getLogger(this.getClass().getName());
    private FileConfiguration properties;

    private Cloud42Settings(String filename) {
        try {
            this.properties = new PropertiesConfiguration();
            this.properties.setBasePath("/etc/cloud42");
            this.properties.setFileName(filename);
            this.properties.load();
            this.LOG.info("Loaded settings from " + this.properties.getFile().getPath());
        }
        catch (Exception e) {
            this.LOG.log(Level.SEVERE, "Error reading properties file for Cloud42 (should be located at /etc/cloud42/" + filename + ")!");
            throw new RuntimeException(e);
        }
    }

    public static Cloud42Settings getInstance(String filename) {
        Cloud42Settings theInstance = null;
        if (instances.containsKey(filename)) {
            theInstance = instances.get(filename);
        } else {
            theInstance = new Cloud42Settings(filename);
            instances.put(filename, theInstance);
        }
        return theInstance;
    }

    public String getString(String propertyName) {
        this.LOG.log(Level.FINE, "Reading property " + propertyName + " in file " + this.properties.getFile().getPath());
        return this.properties.getString(propertyName);
    }

    public boolean getBoolean(String propertyName) {
        return this.properties.getBoolean(propertyName);
    }

    public int getInteger(String propertyName) {
        return this.properties.getInt(propertyName);
    }

    public List<?> getList(String propertyName) {
        return this.properties.getList(propertyName);
    }

    public String[] getStringArray(String propertyName) {
        return this.properties.getStringArray(propertyName);
    }
}

