/*
 * Decompiled with CFR 0.152.
 */
package de.jw.cloud42.core.eventing.storage;

import de.jw.cloud42.core.eventing.storage.SubscriberStore;
import de.jw.cloud42.core.eventing.subscription.Subscription;
import de.jw.cloud42.core.hibernate.HibernateUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.classic.Session;

public class DefaultSubscriberStore
implements SubscriberStore {
    @Override
    public Subscription retrieve(String id) {
        Subscription s;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        try {
            s = (Subscription)session.load(Subscription.class, (Serializable)((Object)id));
        }
        catch (Exception ex) {
            s = null;
        }
        session.getTransaction().commit();
        return s;
    }

    @Override
    public void store(Subscription s) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        session.save((Object)s);
        session.getTransaction().commit();
    }

    @Override
    public void delete(String subscriberID) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        try {
            Object s = session.load(Subscription.class, (Serializable)((Object)subscriberID));
            session.delete(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        session.getTransaction().commit();
    }

    @Override
    public Iterator retrieveAllSubscribers(String topic) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        Query q = session.createQuery("SELECT s FROM Subscription s WHERE s.topic = :topic");
        q.setParameter("topic", (Object)topic);
        List resultset = q.list();
        session.getTransaction().commit();
        return resultset.iterator();
    }
}

