/*
 * Decompiled with CFR 0.152.
 */
package de.jw.cloud42.core.eventing.subscription;

import de.jw.cloud42.core.eventing.EventingException;
import de.jw.cloud42.core.eventing.Message;
import de.jw.cloud42.core.eventing.subscription.Subscription;
import java.util.logging.Logger;
import javax.persistence.Entity;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;

@Entity
public class SOAPSubscription
extends Subscription {
    private EndpointReference toEndpoint;

    @Override
    public void sendEventData(Message message) throws Exception {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://webservice.cloud42.jw.de/notification", "msg");
        OMElement messageElement = factory.createOMElement("message", ns);
        OMElement topicElement = factory.createOMElement("topic", ns);
        messageElement.addChild((OMNode)topicElement);
        topicElement.setText(message.topic);
        OMElement idElement = factory.createOMElement("instanceId", ns);
        messageElement.addChild((OMNode)idElement);
        idElement.setText(message.instanceId);
        OMElement timeElement = factory.createOMElement("timestamp", ns);
        messageElement.addChild((OMNode)timeElement);
        timeElement.setText(message.timestamp);
        OMElement textElement = factory.createOMElement("text", ns);
        messageElement.addChild((OMNode)textElement);
        textElement.setText(message.text);
        OMElement infoElement = factory.createOMElement("info", ns);
        messageElement.addChild((OMNode)infoElement);
        infoElement.setText(message.info);
        this.sendThePublication(messageElement);
    }

    public EndpointReference getToEndpoint() {
        return this.toEndpoint;
    }

    public void setToEndpoint(EndpointReference toEndpoint) {
        this.toEndpoint = toEndpoint;
    }

    private void sendThePublication(OMElement eventData) throws EventingException {
        Logger.getAnonymousLogger().info("Sending notification to " + this.getToEndpoint().getAddress());
        EndpointReference deliveryEPR = this.getToEndpoint();
        try {
            ServiceClient sc = new ServiceClient();
            Options options = new Options();
            options.setTo(deliveryEPR);
            options.setProperty("transportNonBlocking", (Object)Boolean.FALSE);
            options.setProperty("ContentType", (Object)"application/soap+xml");
            sc.setOptions(options);
            sc.fireAndForget(eventData);
        }
        catch (AxisFault e) {
            throw new EventingException((Exception)((Object)e));
        }
        catch (Exception ex) {
            throw new EventingException(ex);
        }
    }
}

