/*
 * Decompiled with CFR 0.152.
 */
package de.jw.cloud42.core.eventing.subscriptionProcessor;

import de.jw.cloud42.core.eventing.EventingException;
import de.jw.cloud42.core.eventing.storage.DefaultSubscriberStore;
import de.jw.cloud42.core.eventing.subscription.Subscription;
import de.jw.cloud42.core.eventing.subscriptionProcessor.SubscriptionProcessor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.UUIDGenerator;

public class GenericSubscriptionProcessor
implements SubscriptionProcessor {
    @Override
    public String subscribe(OMElement subscriptionMessage, String topic) throws EventingException {
        DefaultSubscriberStore store = new DefaultSubscriberStore();
        if (store == null) {
            throw new EventingException("Subscription store not found");
        }
        Subscription subscription = this.getSubscriberFromMessage(subscriptionMessage);
        subscription.setId(GenericSubscriptionProcessor.generateId());
        subscription.setTopic(topic);
        store.store(subscription);
        return subscription.getId();
    }

    @Override
    public void unsubscribe(String subscriptionId) throws EventingException {
        DefaultSubscriberStore store = new DefaultSubscriberStore();
        if (store == null) {
            throw new EventingException("Subscription store not found");
        }
        store.delete(subscriptionId);
        Logger.getAnonymousLogger().info("Subscription with id " + subscriptionId + " was unsubscribed.");
    }

    public Subscription getSubscriberFromMessage(OMElement message) throws EventingException {
        throw new UnsupportedOperationException("Method not supported in generic subscription processor.");
    }

    public static String generateId() throws EventingException {
        String id = UUIDGenerator.getUUID();
        try {
            URI uri = new URI(id);
            return uri.getSchemeSpecificPart();
        }
        catch (URISyntaxException e) {
            throw new EventingException(e);
        }
    }
}

