/*
 * Decompiled with CFR 0.152.
 */
package de.jw.cloud42.core.eventing.subscriptionProcessor;

import de.jw.cloud42.core.eventing.EventingException;
import de.jw.cloud42.core.eventing.subscription.SOAPSubscription;
import de.jw.cloud42.core.eventing.subscription.Subscription;
import de.jw.cloud42.core.eventing.subscriptionProcessor.GenericSubscriptionProcessor;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;

public class SOAPSubscriptionProcessor
extends GenericSubscriptionProcessor {
    @Override
    public Subscription getSubscriberFromMessage(OMElement message) throws EventingException {
        SOAPSubscription subscriber = new SOAPSubscription();
        OMElement subscribeElement = message.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Subscribe"));
        if (subscribeElement == null) {
            throw new EventingException("'Subscribe' element is not present");
        }
        OMElement deliveryElement = subscribeElement.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Delivery"));
        if (deliveryElement == null) {
            throw new EventingException("Delivery element is not present");
        }
        OMElement notifyToElement = deliveryElement.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "NotifyTo"));
        if (notifyToElement == null) {
            throw new EventingException("NotifyTo element is null");
        }
        EndpointReference notifyToEPr = null;
        try {
            notifyToEPr = EndpointReferenceHelper.fromOM((OMElement)notifyToElement);
        }
        catch (AxisFault af) {
            throw new EventingException((Exception)((Object)af));
        }
        subscriber.setToEndpoint(notifyToEPr);
        Logger.getAnonymousLogger().info("Subscription received. Subscribed Endpoint: " + notifyToEPr.getAddress());
        return subscriber;
    }
}

