/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.excel.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import jp.sourceforge.excel.plugin.ChunkedBufferByteArrayOutputStream;

public class ChunkedBufferByteArrayInputStream
extends InputStream {
    List buffers;
    int chunkedBufferSize;
    int currentPos;
    int currentBufferIndex;
    int maxPos;

    public ChunkedBufferByteArrayInputStream(ChunkedBufferByteArrayOutputStream out) {
        this.buffers = out.buffers;
        this.chunkedBufferSize = out.chunkedBufferSize;
        this.maxPos = out.currentPos;
        this.currentBufferIndex = 0;
        this.currentPos = 0;
    }

    public int available() throws IOException {
        return 0;
    }

    public void mark(int mark) {
        throw new RuntimeException("no supported operation");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.currentBufferIndex == this.buffers.size() - 1 && this.currentPos >= this.maxPos) {
            return -1;
        }
        byte[] bs = (byte[])this.buffers.get(this.currentBufferIndex);
        int rv = 0xFF & bs[this.currentPos++];
        if (this.currentPos >= this.chunkedBufferSize) {
            this.currentPos = 0;
            ++this.currentBufferIndex;
        }
        return rv;
    }

    public int read(byte[] bs, int off, int len) throws IOException {
        if (this.currentBufferIndex == this.buffers.size() - 1 && this.currentPos >= this.maxPos) {
            return -1;
        }
        int origLen = len;
        while (len > 0) {
            int filledLen;
            int n = filledLen = this.currentBufferIndex == this.buffers.size() - 1 ? this.maxPos - this.currentPos : this.chunkedBufferSize - this.currentPos;
            if (len < filledLen) {
                filledLen = len;
            }
            byte[] srcBs = (byte[])this.buffers.get(this.currentBufferIndex);
            System.arraycopy(srcBs, this.currentPos, bs, off, filledLen);
            off += filledLen;
            len -= filledLen;
            this.currentPos += filledLen;
            if (this.currentBufferIndex == this.buffers.size() - 1 && this.currentPos >= this.maxPos) {
                return origLen - len;
            }
            if (this.currentBufferIndex == this.buffers.size() - 1 || this.currentPos < this.chunkedBufferSize) continue;
            this.currentPos = 0;
            ++this.currentBufferIndex;
        }
        return origLen;
    }

    public int read(byte[] bs) throws IOException {
        return this.read(bs, 0, bs.length);
    }

    public long skip(long len) throws IOException {
        if (this.currentBufferIndex == this.buffers.size() - 1 && this.currentPos >= this.maxPos) {
            return -1L;
        }
        long origLen = len;
        long off = 0L;
        while (len > 0L) {
            long filledLen = this.currentBufferIndex == this.buffers.size() - 1 ? this.maxPos - this.currentPos : this.chunkedBufferSize - this.currentPos;
            if (len < filledLen) {
                filledLen = (int)len;
            }
            byte[] cfr_ignored_0 = (byte[])this.buffers.get(this.currentBufferIndex);
            off += filledLen;
            len -= filledLen;
            if (this.currentBufferIndex == this.buffers.size() - 1 && this.currentPos >= this.maxPos) {
                return origLen - len;
            }
            if (this.currentBufferIndex == this.buffers.size() - 1 || this.currentPos < this.chunkedBufferSize) continue;
            this.currentPos = 0;
            ++this.currentBufferIndex;
        }
        return origLen;
    }
}

