/*
 * $Id: ChunkedBufferByteArrayInputStream.java,v 1.1 2005/06/12 11:12:39 velvet Exp $
 * 
 * Copyright 2000-2005 The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package jp.sourceforge.excel.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/**
 * JVMɂĂ͘AoCgz̓tOe[VŎȂȂBɑ΂铚łB
 */

public class ChunkedBufferByteArrayInputStream extends InputStream {
    List buffers;

    int chunkedBufferSize;

    int currentPos;

    int currentBufferIndex;

    int maxPos;

    public ChunkedBufferByteArrayInputStream(
            ChunkedBufferByteArrayOutputStream out) {
        buffers = out.buffers;
        chunkedBufferSize = out.chunkedBufferSize;
        maxPos = out.currentPos;
        currentBufferIndex = 0;
        currentPos = 0;
    }

    public int available() throws IOException {
        return 0;
    }

    public void mark(int mark) {
        throw new RuntimeException("no supported operation");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (currentBufferIndex == buffers.size() - 1 && currentPos >= maxPos)
            return -1;
        byte bs[] = (byte[]) buffers.get(currentBufferIndex);
        int rv = 0xff & bs[currentPos++];
        if (currentPos >= chunkedBufferSize) {
            currentPos = 0;
            currentBufferIndex++;
        }
        return rv;
    }

    public int read(byte[] bs, int off, int len) throws IOException {
        if (currentBufferIndex == buffers.size() - 1 && currentPos >= maxPos)
            return -1;

        byte srcBs[];
        int origLen = len;
        while (len > 0) {
            int filledLen = currentBufferIndex == buffers.size() - 1 ? maxPos
                    - currentPos : chunkedBufferSize - currentPos;
            if (len < filledLen)
                filledLen = len;

            srcBs = (byte[]) buffers.get(currentBufferIndex);

            System.arraycopy(srcBs, currentPos, bs, off, filledLen);

            off += filledLen;
            len -= filledLen;
            currentPos += filledLen;

            if (currentBufferIndex == buffers.size() - 1
                    && currentPos >= maxPos)
                return origLen - len;
            if (currentBufferIndex != buffers.size() - 1
                    && currentPos >= chunkedBufferSize) {
                currentPos = 0;
                currentBufferIndex++;
            }
        }

        return origLen;
    }

    public int read(byte[] bs) throws IOException {
        return read(bs, 0, bs.length);
    }

    public long skip(long len) throws IOException {
        if (currentBufferIndex == buffers.size() - 1 && currentPos >= maxPos)
            return -1;

        byte srcBs[];
        long origLen = len;
        long off = 0;
        while (len > 0) {
            long filledLen = currentBufferIndex == buffers.size() - 1 ? maxPos
                    - currentPos : chunkedBufferSize - currentPos;
            if (len < filledLen)
                filledLen = (int) len;

            srcBs = (byte[]) buffers.get(currentBufferIndex);

            off += filledLen;
            len -= filledLen;

            if (currentBufferIndex == buffers.size() - 1
                    && currentPos >= maxPos)
                return origLen - len;
            if (currentBufferIndex != buffers.size() - 1
                    && currentPos >= chunkedBufferSize) {
                currentPos = 0;
                currentBufferIndex++;
            }
        }

        return origLen;
    }
}
