/*
 * $Id: ChunkedBufferByteArrayOutputStream.java,v 1.1 2005/06/12 11:12:39 velvet Exp $
 * 
 * Copyright 2000-2005 The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package jp.sourceforge.excel.plugin;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;

/**
 * JVMɂĂ͘AoCgz̓tOe[VŎȂȂBɑ΂铚łB
 */

public class ChunkedBufferByteArrayOutputStream extends OutputStream {
    final public static int DEFULAT_CHUNKED_BUFFER_SIZE = 512;

    protected int chunkedBufferSize;

    protected List buffers;

    protected int currentPos;

    protected byte currentByteArray[];

    public ChunkedBufferByteArrayOutputStream(int chunkedBufSize) {
        this.chunkedBufferSize = chunkedBufSize;
        buffers = new LinkedList();
        appendNewBuffer();
    }

    public ChunkedBufferByteArrayOutputStream() {
        this(DEFULAT_CHUNKED_BUFFER_SIZE);
    }

    protected void appendNewBuffer() {
        currentPos = 0;
        currentByteArray = new byte[chunkedBufferSize];
        buffers.add(currentByteArray);
    }

    public void write(int b) throws IOException {
        if (currentPos == chunkedBufferSize)
            appendNewBuffer();
        currentByteArray[currentPos++] = (byte) b;
    }

    public void write(byte[] bs, int off, int len) throws IOException {
        while (len > 0) {
            if (currentPos == chunkedBufferSize)
                appendNewBuffer();
            int filledLen = chunkedBufferSize - currentPos;
            if (len < filledLen)
                filledLen = len;
            System.arraycopy(bs, off, currentByteArray, currentPos, filledLen);

            off += filledLen;
            len -= filledLen;
            currentPos += filledLen;
        }
    }

    public void write(byte[] bs) throws IOException {
        write(bs, 0, bs.length);
    }

}