/* 
 * $Id: PoiUtil.java,v 1.1 2005/06/12 11:12:39 velvet Exp $
 *
 * Copyright 2000-2005 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.poi.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.sourceforge.poi.bean.Table;
import jp.sourceforge.poi.parser.Parser;
import jp.sourceforge.poi.parser.ParserResult;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;


public class PoiUtil {
    /** SingletonpPoiUtilCX^X */
    static protected PoiUtil util = new PoiUtil();

    /** HSSFColor̃Xg */
    private static HSSFColor colors[] = new HSSFColor[] { new HSSFColor.AQUA(),
            new HSSFColor.BLACK(), new HSSFColor.BLUE(),
            new HSSFColor.BLUE_GREY(), new HSSFColor.BRIGHT_GREEN(),
            new HSSFColor.BROWN(), new HSSFColor.CORAL(),
            new HSSFColor.CORNFLOWER_BLUE(), new HSSFColor.DARK_BLUE(),
            new HSSFColor.DARK_GREEN(), new HSSFColor.DARK_RED(),
            new HSSFColor.DARK_TEAL(), new HSSFColor.DARK_YELLOW(),
            new HSSFColor.GOLD(), new HSSFColor.GREEN(),
            new HSSFColor.GREY_25_PERCENT(), new HSSFColor.GREY_40_PERCENT(),
            new HSSFColor.GREY_50_PERCENT(), new HSSFColor.GREY_80_PERCENT(),
            new HSSFColor.INDIGO(), new HSSFColor.LAVENDER(),
            new HSSFColor.LEMON_CHIFFON(), new HSSFColor.LIGHT_BLUE(),
            new HSSFColor.LIGHT_CORNFLOWER_BLUE(), new HSSFColor.LIGHT_GREEN(),
            new HSSFColor.LIGHT_ORANGE(), new HSSFColor.LIGHT_TURQUOISE(),
            new HSSFColor.LIGHT_YELLOW(), new HSSFColor.LIME(),
            new HSSFColor.MAROON(), new HSSFColor.OLIVE_GREEN(),
            new HSSFColor.ORANGE(), new HSSFColor.ORCHID(),
            new HSSFColor.PALE_BLUE(), new HSSFColor.PINK(),
            new HSSFColor.PLUM(), new HSSFColor.RED(), new HSSFColor.ROSE(),
            new HSSFColor.ROYAL_BLUE(), new HSSFColor.SEA_GREEN(),
            new HSSFColor.SKY_BLUE(), new HSSFColor.TAN(),
            new HSSFColor.TEAL(), new HSSFColor.TURQUOISE(),
            new HSSFColor.VIOLET(), new HSSFColor.WHITE(),
            new HSSFColor.YELLOW() };

    /** HSSFColorIndexHSSFColorg̃}bsO */
    final static public Map colorMap;
    static {
        Map internalColorMap = new HashMap();
        for (int i = 0; i < colors.length; i++) {
            HSSFColor color = colors[i];
            internalColorMap.put(new Short(color.getIndex()), color);
        }
        colorMap = Collections.unmodifiableMap(internalColorMap);
    }

    protected PoiUtil() {

    }

    /**
     * SingletonPoiUtil𓾂B
     * 
     * @return PoiUtil
     */
    static public PoiUtil getPoiUtil() {
        return util;
    }

    /**
     * Excelt@C͈̓̔͂̃f[^擾
     * 
     * <p>
     * (startRow,startCol) - (startRow + rowSize,startCol +
     * columnSize)܂ł͈̔͂Excel̃f[^StringŎ擾B <br>
     * <table border>
     * <tr>
     * <td>0,0</td>
     * <td>1,0</td>
     * <td>2,0</td>
     * <td>3,0</td>
     * </tr>
     * <tr>
     * <td>0,1</td>
     * <td>1,1</td>
     * <td>2,1</td>
     * <td>3,1</td>
     * </tr>
     * <tr>
     * <td>0,2</td>
     * <td>1,2</td>
     * <td>2,2</td>
     * <td>3,2</td>
     * </tr>
     * <tr>
     * <td>0,3</td>
     * <td>1,3</td>
     * <td>2,3</td>
     * <td>3,3</td>
     * </tr>
     * </table>
     * </p>
     * 
     * @param in
     *            Excelt@CInputStream
     * @param sheetIndex
     *            Ԗڂ̃[NV[g
     * @param startCol
     *            Jn (0-index)
     * @param startRow
     *            Jns (0-index)
     * @param columnSize
     *            
     * @param rowSize
     *            s
     * 
     * @return f[^Ԃ(StringTable)
     * @throws IOException
     * @throws SheetNotFoundException
     */
    public Table getValues(InputStream in, int sheetIndex, int startCol,
            int startRow, int columnSize, int rowSize) throws IOException,
            SheetNotFoundException {

        POIFSFileSystem fs = new POIFSFileSystem(in);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(sheetIndex);
        if (sheet == null)
            throw new SheetNotFoundException("Sheet at " + sheetIndex
                    + " not found");
        return getValues(sheet, startCol, startRow, columnSize, rowSize);
    }

    /**
     * Excelt@C͈̓̔͂̃f[^擾
     * 
     * <p>
     * (startRow,startCol) - (startRow + rowSize,startCol +
     * columnSize)܂ł͈̔͂Excel̃f[^StringŎ擾B <br>
     * <table border>
     * <tr>
     * <td>0,0</td>
     * <td>1,0</td>
     * <td>2,0</td>
     * <td>3,0</td>
     * </tr>
     * <tr>
     * <td>0,1</td>
     * <td>1,1</td>
     * <td>2,1</td>
     * <td>3,1</td>
     * </tr>
     * <tr>
     * <td>0,2</td>
     * <td>1,2</td>
     * <td>2,2</td>
     * <td>3,2</td>
     * </tr>
     * <tr>
     * <td>0,3</td>
     * <td>1,3</td>
     * <td>2,3</td>
     * <td>3,3</td>
     * </tr>
     * </table>
     * </p>
     * 
     * @param in
     *            Excelt@CInputStream
     * @param sheetName
     *            [NV[g
     * @param startCol
     *            Jn (0-index)
     * @param startRow
     *            Jns (0-index)
     * @param columnSize
     *            
     * @param rowSize
     *            s
     * 
     * @return f[^Ԃ(StringTable)
     * @throws IOException
     * @throws SheetNotFoundException
     */
    public Table getValues(InputStream in, String sheetName, int startCol,
            int startRow, int columnSize, int rowSize) throws IOException,
            SheetNotFoundException {

        POIFSFileSystem fs = new POIFSFileSystem(in);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheet(sheetName);
        if (sheet == null)
            throw new SheetNotFoundException("Sheet " + sheetName
                    + " not found");
        return getValues(sheet, startCol, startRow, columnSize, rowSize);
    }

    public Table getValues(HSSFSheet sheet, int startCol, int startRow,
            int colSize, int rowSize) {
        Table table = new TableImpl(colSize, rowSize);
        for (int row = startRow; row < startRow + rowSize; row++) {
            HSSFRow rowValue = sheet.getRow(row);
            for (int col = startCol; col < startCol + colSize; col++) {
                HSSFCell cellValue = rowValue.getCell((short) col);
                String value = getCellValueAsString(cellValue);
                table.set(col - startCol, row - startRow, value);
            }
        }
        return table;
    }

    public Table getValues(InputStream in, int sheetIndex, int startCol,
            int startRow, Parser parser) throws IOException,
            SheetNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem(in);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(sheetIndex);
        if (sheet == null)
            throw new SheetNotFoundException("Sheet at " + sheetIndex
                    + " not found");
        return getValues(sheet, startCol, startRow, parser);
    }

    public Table getValues(InputStream in, String sheetName, int startCol,
            int startRow, Parser parser) throws IOException,
            SheetNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem(in);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheet(sheetName);
        if (sheet == null)
            throw new SheetNotFoundException("Sheet " + sheetName
                    + " not found");
        return getValues(sheet, startCol, startRow, parser);
    }

    public Table getValues(HSSFSheet sheet, int startCol, int startRow,
            Parser parser) {
        ParseIterator iter = new ParseIterator(sheet, parser, startCol,
                startRow);
        if (!iter.hasNext()) {
            return null;
        }
        Object os[] = (Object[]) iter.next();

        DynaTableImpl table = new DynaTableImpl(os.length);
        table.addRow(os);
        while (iter.hasNext()) {
            os = (Object[]) iter.next();
            table.addRow(os);
        }
        return table;
    }

    public Iterator getValuesAsIterator(HSSFSheet sheet, int startCol,
            int startRow, Parser parser) {
        return new ParseIterator(sheet, parser, startCol, startRow);
    }

    /**
     * @param cellValue
     * @param value
     * @return
     */
    public String getCellValueAsString(HSSFCell cellValue) {
        String value = null;

        if (cellValue != null) {
            int cellType = cellValue.getCellType();
            switch (cellType) {
            case HSSFCell.CELL_TYPE_STRING:
                value = cellValue.getStringCellValue();
                break;
            case HSSFCell.CELL_TYPE_FORMULA:
            case HSSFCell.CELL_TYPE_NUMERIC:
                short format = cellValue.getCellStyle().getDataFormat();
                //	        	lt
                if (HSSFDateUtil.isInternalDateFormat(format)) {
                    Date d = cellValue.getDateCellValue();
                    if (format == 22 || format == 176) {
                        //t
                        DateFormat.getDateTimeInstance().format(d);
                    } else {
                        //t
                        DateFormat.getDateInstance().format(d);
                    }
                } else {
                    double dval = cellValue.getNumericCellValue();
                    if (dval == (double) (short) dval)
                        value = Short.toString((short) dval);
                    else
                        value = Double.toString(dval);
                }
                break;
            }

        }
        if (cellValue == null)
            value = "";
        return value;
    }

    class ParseIterator implements Iterator {
        Parser parser;

        HSSFSheet sheet;

        int startCol;

        int row;

        Object nextValue;

        boolean hasNext = true;

        public ParseIterator(HSSFSheet sheet, Parser parser, int startCol,
                int startRow) {
            this.startCol = startCol;
            this.row = startRow;
            this.sheet = sheet;
            this.parser = parser;
            parser.setStartColumn(startCol);
            parser.setStartRow(startRow);

        }

        public boolean hasNext() {
            if (!hasNext)
                return false;
            HSSFRow rowValue = sheet.getRow(row);
            if (rowValue == null) {
                hasNext = false;
                return false;
            }
            parser.setCurrentRow(row);

            ParserResult result = parser.parse(rowValue);
            if (result.isParseBreak()) {
                hasNext = false;
            }
            row++;
            this.nextValue = result.getResultValue();
            return hasNext;
        }

        public Object next() {
            return nextValue;
        }

        public void remove() {
            throw new UnsupportedOperationException();

        }
    }

    public void setValues(HSSFSheet sheet, int startCol, int startRow,
            Table table) {
        int rowSize = table.getRowSize();
        int colSize = table.getColumnSize();

        for (int row = 0; row < startRow + rowSize; row++) {
            HSSFRow rowValue = sheet.getRow(row);
            for (int col = 0; col < colSize; col++) {
                HSSFCell cellValue = rowValue.getCell((short) col);
                Object value = table.get(startCol + col, startRow + row);
                cellValue.setCellValue(value.toString());
            }
        }

    }

    public int convertColumnCellNameToIndex(String colName) {
        if (colName.length() == 1) {
            char c = colName.charAt(0);
            c = Character.toUpperCase(c);
            return c - 'A';
        } else if (colName.length() == 2) {
            char c0 = Character.toUpperCase(colName.charAt(0));
            char c1 = Character.toUpperCase(colName.charAt(1));
            return ('Z' - 'A' + 1) * (c0 - 'A') + c1 - 'A' + ('Z' - 'A' + 1);
        } else {
            throw new RuntimeException("column " + colName + " not valid");
        }

    }

    class TableImpl implements Table {
        private int columnSize, rowSize;

        private Object[] values;

        public TableImpl(int columnSize, int rowSize) {
            if (rowSize <= 0)
                throw new RuntimeException("rowSize must be a positive value.");
            if (columnSize <= 0)
                throw new RuntimeException(
                        "columnSize must be a positive value.");
            values = new Object[rowSize * columnSize];
            this.columnSize = columnSize;
            this.rowSize = rowSize;
        }

        public int getRowSize() {
            return rowSize;
        }

        public int getColumnSize() {
            return columnSize;
        }

        public Object get(int col, int row) {
            // Never check an alignment.
            return values[row * columnSize + col];
        }

        public void set(int col, int row, Object value) {
            values[row * columnSize + col] = value;
        }

    }

    /** Iɍs\ */
    class DynaTableImpl implements Table {
        List table = new ArrayList();

        private int columnSize;

        public DynaTableImpl(int columnSize) {
            this.columnSize = columnSize;
        }

        public int getRowSize() {
            return table.size();
        }

        public int getColumnSize() {
            return columnSize;
        }

        public Object get(int col, int row) {
            String rowValue[] = (String[]) table.get(row);
            return rowValue[col];
        }

        public void set(int col, int row, Object value) {
            Object rowValue[] = (Object[]) table.get(row);
            rowValue[col] = value;
        }

        public void addRow(Object rowValue[]) {
            if (rowValue.length != columnSize)
                throw new RuntimeException("rowValue.length != columnSize");
            table.add(rowValue);
        }

    }
}
