package jp.sourceforge.poi.junit;

import java.io.IOException;
import java.io.InputStream;

import jp.sourceforge.poi.bean.Table;
import jp.sourceforge.poi.parser.BorderStyleParser;
import jp.sourceforge.poi.util.PoiUtil;
import jp.sourceforge.poi.util.SheetNotFoundException;
import junit.framework.TestCase;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;


public class BorderStyleParserTest extends TestCase {
    protected InputStream getInputStream() {
        return this.getClass().getResourceAsStream("PoiUtilTest.xls");
    }

    public void testParse() {
        PoiUtil util = PoiUtil.getPoiUtil();
        InputStream in = getInputStream();
        BorderStyleParser parser = new BorderStyleParser(1, 3,
                HSSFCellStyle.BORDER_MEDIUM);
        Table table;
        try {
            table = util.getValues(in, "border", 1, 1, parser);
            assertEquals(4, table.getRowSize());
            assertEquals(3, table.getColumnSize());

            assertEquals("2", ((String) table.get(0, 0)).trim());
            assertEquals("b:0,0", ((String) table.get(1, 0)).trim());
            assertEquals("b:1,0", ((String) table.get(2, 0)).trim());

            assertEquals("3", ((String) table.get(0, 1)).trim());
            assertEquals("b:0,1", ((String) table.get(1, 1)).trim());
            assertEquals("b:1,1", ((String) table.get(2, 1)).trim());

            assertEquals("4", ((String) table.get(0, 2)).trim());
            assertEquals("b:0,2", ((String) table.get(1, 2)).trim());
            assertEquals("b:1,2", ((String) table.get(2, 2)).trim());

            assertEquals("5", ((String) table.get(0, 3)).trim());
            assertEquals("b:0,3", ((String) table.get(1, 3)).trim());
            assertEquals("b:1,3", ((String) table.get(2, 3)).trim());
            in.close();
        } catch (IOException e) {
            fail(e.getMessage());
        } catch (SheetNotFoundException e) {
            fail(e.getMessage());
        }

    }
}
