package jp.sourceforge.poi.junit;

import java.io.IOException;
import java.io.InputStream;


import jp.sourceforge.poi.bean.Table;
import jp.sourceforge.poi.util.PoiUtil;
import jp.sourceforge.poi.util.SheetNotFoundException;
import junit.framework.TestCase;

public class PoiUtilTest extends TestCase {
    protected InputStream getInputStream() {
        return this.getClass().getResourceAsStream("PoiUtilTest.xls");
    }

    public void testGetValuesInputStreamintintintintint() {
        PoiUtil util = PoiUtil.getPoiUtil();
        InputStream in = getInputStream();
        try {
            Table table = util.getValues(in, 1, 1, 1, 2, 2);
            assertEquals("2:1,1", table.get(0, 0));
            assertEquals("2:2,1", table.get(1, 0));
            assertEquals("2:1,2", table.get(0, 1));
            assertEquals("2:2,2", table.get(1, 1));
            in.close();
        } catch (IOException e) {
            fail(e.getMessage());
        } catch (SheetNotFoundException e) {
            fail(e.getMessage());
        }

    }

    public void testGetValuesInputStreamStringintintintint() {
        PoiUtil util = PoiUtil.getPoiUtil();
        InputStream in = getInputStream();
        try {
            Table table = util.getValues(in, "Sheet2", 1, 1, 2, 2);
            assertEquals("2:1,1", table.get(0, 0));
            assertEquals("2:2,1", table.get(1, 0));
            assertEquals("2:1,2", table.get(0, 1));
            assertEquals("2:2,2", table.get(1, 1));
            in.close();
        } catch (IOException e) {
            fail(e.getMessage());
        } catch (SheetNotFoundException e) {
            fail(e.getMessage());
        }
    }

    public void testConvertColumnCellNameToIndex() {
        PoiUtil util = PoiUtil.getPoiUtil();
        InputStream in = getInputStream();
        int colIndex = util.convertColumnCellNameToIndex("IV");
        try {
            Table table = util.getValues(in, "long column", colIndex, 3000 - 1,
                    1, 1);
            assertEquals("3000IV", table.get(0, 0));
            in.close();
        } catch (IOException e) {
            fail(e.getMessage());
        } catch (SheetNotFoundException e) {
            fail(e.getMessage());
        }
    }

}
