/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.swt.widgets.Display;

public class QueuedRealm
extends Realm {
    static final int INITIAL_SIZE = 256;
    static final int GROW_SIZE = 32;
    static final int MESSAGE_LIMIT = 1024;
    static final Realm instance = new QueuedRealm();
    private Display display;
    int messageCount;
    Runnable[] messages = new Runnable[256];
    private Object messageLock = new Object();
    private Runnable delayedRunnable = new Runnable(){

        @Override
        public void run() {
            Runnable runnable;
            while ((runnable = QueuedRealm.this.removeFirst()) != null) {
                runnable.run();
            }
        }
    };

    public static Realm getInstance() {
        return instance;
    }

    private QueuedRealm() {
        this.display = Display.getDefault();
    }

    public boolean isCurrent() {
        return Display.getCurrent() == this.display;
    }

    public void exec(Runnable runnable) {
        this.addLast(runnable);
    }

    public void asyncExec(Runnable runnable) {
        this.addLast(runnable);
    }

    protected void syncExec(Runnable runnable) {
        this.display.syncExec(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLast(Runnable runnable) {
        boolean wake = false;
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messages == null) {
                this.messages = new Runnable[256];
            }
            if (this.messageCount == this.messages.length) {
                Runnable[] newMessages = new Runnable[this.messageCount + 32];
                System.arraycopy(this.messages, 0, newMessages, 0, this.messageCount);
                this.messages = newMessages;
                System.out.println(this.messages.length);
            }
            this.messages[this.messageCount++] = runnable;
            wake = this.messageCount == 1;
        }
        if (wake) {
            this.display.asyncExec(this.delayedRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runnable removeFirst() {
        Object object = this.messageLock;
        synchronized (object) {
            block5: {
                if (this.messageCount != 0) break block5;
                return null;
            }
            Runnable lock = this.messages[0];
            System.arraycopy(this.messages, 1, this.messages, 0, --this.messageCount);
            this.messages[this.messageCount] = null;
            if (this.messageCount == 0 && this.messages.length > 1024) {
                this.messages = null;
            }
            return lock;
        }
    }
}

