/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.repository.IChartSection;
import org.eclipsetrader.core.charts.repository.IElementSection;
import org.eclipsetrader.core.charts.repository.IParameter;
import org.eclipsetrader.core.internal.charts.repository.ChartSection;
import org.eclipsetrader.core.internal.charts.repository.ElementSection;
import org.eclipsetrader.core.internal.charts.repository.Parameter;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewItemVisitor;
import org.eclipsetrader.core.views.ViewItemDelta;
import org.eclipsetrader.ui.charts.ChartParameters;
import org.eclipsetrader.ui.charts.ChartView;
import org.eclipsetrader.ui.charts.ChartViewItem;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.charts.views.MainChartFactory;

public class ChartRowViewItem
implements IViewItem {
    private ChartView parent;
    private String id;
    private String name;
    private IDataSeries rootDataSeries;
    private List<IChartObject> rootChart = new ArrayList<IChartObject>();
    private List<ChartViewItem> items = new ArrayList<ChartViewItem>();

    public ChartRowViewItem(ChartView parent, String name) {
        this.parent = parent;
        this.name = name;
        this.id = UUID.randomUUID().toString();
    }

    public ChartRowViewItem(ChartView parent, IChartSection template) {
        this.parent = parent;
        this.name = template.getName();
        this.id = template.getId();
        IElementSection[] element = template.getElements();
        int i = 0;
        while (i < element.length) {
            IChartObjectFactory factory = null;
            if ("org.eclipsetrader.ui.charts.main".equals(element[i].getPluginId())) {
                factory = new MainChartFactory();
            } else if (UIActivator.getDefault() != null) {
                factory = UIActivator.getDefault().getChartObjectFactory(element[i].getPluginId());
            }
            if (factory != null) {
                ChartParameters parameters = new ChartParameters();
                IParameter[] iParameterArray = element[i].getParameters();
                int n = iParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IParameter p = iParameterArray[n2];
                    parameters.setParameter(p.getName(), p.getValue());
                    ++n2;
                }
                factory.setParameters(parameters);
                this.items.add(new ChartViewItem(this, factory, element[i].getId()));
            }
            ++i;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IDataSeries getRootDataSeries() {
        return this.rootDataSeries;
    }

    public void setRootDataSeries(IDataSeries rootDataSeries) {
        this.rootDataSeries = rootDataSeries;
        this.refresh();
    }

    public void refresh() {
        this.rootChart = new ArrayList<IChartObject>();
        for (ChartViewItem value : this.items) {
            IChartObject object = value.getFactory().createObject(this.rootDataSeries);
            if (object != null) {
                this.rootChart.add(object);
            }
            value.setObject(object);
        }
    }

    public void addChildItem(ChartViewItem viewItem) {
        this.items.add(viewItem);
        this.parent.fireViewChangedEvent(new ViewItemDelta[]{new ViewItemDelta(4, (IViewItem)this), new ViewItemDelta(1, (IViewItem)viewItem)});
    }

    public void addChildItem(int index, ChartViewItem viewItem) {
        this.items.add(index, viewItem);
        this.parent.fireViewChangedEvent(new ViewItemDelta[]{new ViewItemDelta(4, (IViewItem)this), new ViewItemDelta(1, (IViewItem)viewItem)});
    }

    public void removeChildItem(ChartViewItem viewItem) {
        this.items.remove((Object)viewItem);
        this.parent.fireViewChangedEvent(new ViewItemDelta[]{new ViewItemDelta(2, (IViewItem)viewItem), new ViewItemDelta(4, (IViewItem)this)});
    }

    public void addFactory(IChartObjectFactory factory) {
        this.addChildItem(new ChartViewItem(this, factory));
    }

    public void removeFactory(IChartObjectFactory factory) {
        ChartViewItem removedItem = null;
        Iterator<ChartViewItem> iter = this.items.iterator();
        while (iter.hasNext()) {
            ChartViewItem viewItem = iter.next();
            if (viewItem.getFactory() != factory) continue;
            iter.remove();
            removedItem = viewItem;
            break;
        }
        if (removedItem != null) {
            this.parent.fireViewChangedEvent(new ViewItemDelta[]{new ViewItemDelta(2, (IViewItem)removedItem), new ViewItemDelta(4, (IViewItem)this)});
        }
    }

    public int getItemCount() {
        return this.items.size();
    }

    public IViewItem[] getItems() {
        return this.items.toArray(new IViewItem[this.items.size()]);
    }

    public IViewItem getParent() {
        return null;
    }

    public ChartView getParentView() {
        return this.parent;
    }

    public IAdaptable[] getValues() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IChartObject[].class)) {
            return this.rootChart.toArray(new IChartObject[this.rootChart.size()]);
        }
        if (adapter.isAssignableFrom(IDataSeries.class)) {
            return this.rootDataSeries;
        }
        if (adapter.isAssignableFrom(this.parent.getClass())) {
            return this.parent;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public void accept(IViewItemVisitor visitor) {
        IViewItem[] child;
        if (visitor.visit((IViewItem)this) && (child = this.getItems()) != null) {
            int i = 0;
            while (i < child.length) {
                child[i].accept(visitor);
                ++i;
            }
        }
    }

    public IChartSection getTemplate() {
        ChartSection template = new ChartSection(this.id, this.name);
        ElementSection[] element = new ElementSection[this.items.size()];
        int i = 0;
        while (i < element.length) {
            IChartObjectFactory factory = this.items.get(i).getFactory();
            if (factory.getId() != null) {
                element[i] = new ElementSection(this.items.get(i).getId(), factory.getId());
                IChartParameters parameters = factory.getParameters();
                if (parameters != null) {
                    String[] name = parameters.getParameterNames();
                    IParameter[] elementParam = new IParameter[name.length];
                    int ii = 0;
                    while (ii < elementParam.length) {
                        elementParam[ii] = new Parameter(name[ii], parameters.getString(name[ii]));
                        ++ii;
                    }
                    element[i].setParameters(elementParam);
                }
            }
            ++i;
        }
        template.setElements((IElementSection[])element);
        return template;
    }
}

