/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipsetrader.ui.charts.IAxis;
import org.eclipsetrader.ui.charts.IGraphics;

public class Graphics
implements IGraphics {
    private GC gc;
    private IAxis horizontalAxis;
    private IAxis verticalAxis;
    private Point location;
    private Rectangle bounds;
    private RGB foregroundColor;
    private RGB backgroundColor;
    private Map<RGB, Color> colorMap;
    private List<Map<String, Object>> stack;

    public Graphics(Drawable drawable, Point location, IAxis horizontalAxis, IAxis verticalAxis) {
        this.gc = new GC(drawable);
        this.horizontalAxis = horizontalAxis;
        this.verticalAxis = verticalAxis;
        this.location = location;
        if (drawable instanceof Image) {
            this.bounds = ((Image)drawable).getBounds();
        }
        if (drawable instanceof Control) {
            this.bounds = ((Control)drawable).getBounds();
        }
        this.foregroundColor = this.gc.getForeground().getRGB();
        this.backgroundColor = this.gc.getBackground().getRGB();
        this.colorMap = new HashMap<RGB, Color>();
        this.stack = new ArrayList<Map<String, Object>>();
    }

    public void dispose() {
        for (Color c : this.colorMap.values()) {
            c.dispose();
        }
        this.colorMap.clear();
        this.gc.dispose();
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.gc.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawPolyline(Point[] pointArray) {
        if (pointArray == null) {
            SWT.error((int)4);
        }
        int[] array = new int[pointArray.length * 2];
        int i = 0;
        int index = 0;
        while (i < array.length) {
            int n = i;
            array[n] = array[n] + pointArray[index].x;
            int n2 = i + 1;
            array[n2] = array[n2] + pointArray[index].y;
            i += 2;
            ++index;
        }
        this.gc.drawPolyline(array);
    }

    @Override
    public void drawRectangle(int x, int y, int width, int height) {
        this.gc.drawRectangle(x, y, width, height);
    }

    @Override
    public void drawRectangle(Rectangle rect) {
        this.gc.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height) {
        this.gc.fillRectangle(x, y, width, height);
    }

    @Override
    public void fillRectangle(Rectangle rect) {
        this.gc.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void fillPolygon(int[] pointArray) {
        this.gc.fillPolygon(pointArray);
    }

    @Override
    public void setLineStyle(int lineStyle) {
        if (lineStyle == 2) {
            int[] dashes = new int[]{3, 3};
            this.gc.setLineDash(dashes);
        } else if (lineStyle == 3) {
            int[] dashes = new int[]{1, 2};
            this.gc.setLineDash(dashes);
        } else {
            this.gc.setLineStyle(lineStyle);
        }
    }

    @Override
    public void setLineDash(int[] dash) {
        this.gc.setLineDash(dash);
    }

    @Override
    public void drawString(String s, int x, int y) {
        this.gc.drawString(s, x, y, true);
    }

    @Override
    public Point stringExtent(String s) {
        return this.gc.stringExtent(s);
    }

    @Override
    public Point mapToPoint(Object xValue, Object yValue) {
        return new Point(this.horizontalAxis.mapToAxis(xValue) - this.location.x, this.verticalAxis.mapToAxis(yValue));
    }

    @Override
    public int mapToHorizontalAxis(Object value) {
        return this.horizontalAxis.mapToAxis(value) - this.location.x;
    }

    @Override
    public Object mapToHorizontalValue(int x) {
        return this.horizontalAxis.mapToValue(x + this.location.x);
    }

    @Override
    public int mapToVerticalAxis(Object value) {
        return this.verticalAxis.mapToAxis(value);
    }

    @Override
    public Object mapToVerticalValue(int y) {
        return this.verticalAxis.mapToValue(y);
    }

    @Override
    public RGB getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(RGB rgb) {
        if (rgb == null) {
            return;
        }
        this.backgroundColor = rgb;
        Color c = this.colorMap.get(rgb);
        if (c == null) {
            c = new Color(this.gc.getDevice(), rgb);
            this.colorMap.put(rgb, c);
        }
        this.gc.setBackground(c);
    }

    @Override
    public RGB getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public void setForegroundColor(RGB rgb) {
        if (rgb == null) {
            return;
        }
        this.foregroundColor = rgb;
        Color c = this.colorMap.get(rgb);
        if (c == null) {
            c = new Color(this.gc.getDevice(), rgb);
            this.colorMap.put(rgb, c);
        }
        this.gc.setForeground(c);
    }

    @Override
    public Font getFont() {
        return this.gc.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.gc.setFont(font);
    }

    @Override
    public void setLineWidth(int lineWidth) {
        this.gc.setLineWidth(lineWidth == 1 ? 0 : lineWidth);
    }

    @Override
    public void popState() {
        if (this.stack.size() != 0) {
            Map<String, Object> state = this.stack.get(0);
            this.stack.remove(0);
            this.setForegroundColor((RGB)state.get("foreground-color"));
            this.setBackgroundColor((RGB)state.get("background-color"));
            this.gc.setLineStyle(((Integer)state.get("line-style")).intValue());
            this.gc.setLineDash((int[])state.get("line-dash"));
            this.gc.setLineWidth(((Integer)state.get("line-width")).intValue());
        }
    }

    @Override
    public void pushState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("foreground-color", this.getForegroundColor());
        state.put("background-color", this.getBackgroundColor());
        state.put("line-style", this.gc.getLineStyle());
        state.put("line-dash", this.gc.getLineDash());
        state.put("line-width", new Integer(this.gc.getLineWidth()));
        this.stack.add(0, state);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gc.drawArc(x, y, width, height, startAngle, arcAngle);
    }
}

