/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.DataBounds;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.IGraphics;
import org.eclipsetrader.ui.charts.ISummaryBarDecorator;
import org.eclipsetrader.ui.charts.OHLCField;
import org.eclipsetrader.ui.charts.SummaryDateItem;
import org.eclipsetrader.ui.charts.SummaryNumberItem;
import org.eclipsetrader.ui.charts.SummaryOHLCItem;
import org.eclipsetrader.ui.charts.Util;

public class HistogramAreaChart
implements IChartObject,
ISummaryBarDecorator,
IAdaptable {
    private IDataSeries dataSeries;
    private OHLCField field;
    private IAdaptable[] values;
    private List<Polygon> pointArray = new ArrayList<Polygon>(2048);
    private boolean valid;
    private boolean focus;
    private RGB color = new RGB(0, 0, 0);
    private RGB fillColor;
    private SummaryDateItem dateItem;
    private SummaryOHLCItem ohlcItem;
    private SummaryNumberItem numberItem;
    private DateFormat dateFormat = DateFormat.getDateInstance();
    private NumberFormat numberFormat = NumberFormat.getInstance();

    public HistogramAreaChart(IDataSeries dataSeries, RGB color) {
        this(dataSeries, OHLCField.Close, color);
    }

    public HistogramAreaChart(IDataSeries dataSeries, OHLCField field, RGB color) {
        this.dataSeries = dataSeries;
        this.field = field;
        if (color != null) {
            this.color = color;
        }
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setMinimumIntegerDigits(1);
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(4);
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    @Override
    public void setDataBounds(DataBounds dataBounds) {
        ArrayList<IAdaptable> l = new ArrayList<IAdaptable>(2048);
        IAdaptable[] iAdaptableArray = this.dataSeries.getValues();
        int n = iAdaptableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable value = iAdaptableArray[n2];
            Date date = (Date)value.getAdapter(Date.class);
            if (!(dataBounds.first != null && date.before(dataBounds.first) || dataBounds.last != null && date.after(dataBounds.last))) {
                l.add(value);
            }
            ++n2;
        }
        this.values = l.toArray(new IAdaptable[l.size()]);
        this.valid = false;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public void paint(IGraphics graphics) {
        if (!this.valid && this.values != null) {
            int zero = graphics.mapToVerticalAxis(0.0);
            double[] inReal = Util.getValuesForField(this.values, this.field);
            int i = 0;
            while (i < this.values.length - 1) {
                Polygon candle;
                Date date1 = (Date)this.values[i].getAdapter(Date.class);
                Date date2 = (Date)this.values[i + 1].getAdapter(Date.class);
                int x1 = graphics.mapToHorizontalAxis(date1);
                int y1 = graphics.mapToVerticalAxis(inReal[i]);
                int x2 = graphics.mapToHorizontalAxis(date2);
                int y2 = graphics.mapToVerticalAxis(inReal[i + 1]);
                if (i < this.pointArray.size()) {
                    candle = this.pointArray.get(i);
                } else {
                    candle = new Polygon();
                    this.pointArray.add(candle);
                }
                candle.setBounds(zero, x1, y1, x2, y2);
                candle.setValue(this.values[i]);
                ++i;
            }
            while (this.pointArray.size() > this.values.length - 1) {
                this.pointArray.remove(this.pointArray.size() - 1);
            }
        }
        if (this.fillColor == null) {
            this.fillColor = Util.blend(this.color, graphics.getBackgroundColor(), 25);
        }
        graphics.pushState();
        graphics.setLineWidth(this.hasFocus() ? 2 : 1);
        for (Polygon c : this.pointArray) {
            c.paint(graphics);
        }
        graphics.popState();
    }

    @Override
    public void paintScale(Graphics graphics) {
    }

    @Override
    public boolean containsPoint(int x, int y) {
        for (Polygon c : this.pointArray) {
            if (!c.containsPoint(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDataSeries getDataSeries() {
        return this.dataSeries;
    }

    @Override
    public String getToolTip() {
        if (this.dataSeries.getLast() != null) {
            IOHLC ohlc = (IOHLC)this.dataSeries.getLast().getAdapter(IOHLC.class);
            if (ohlc != null) {
                return String.valueOf(this.dateFormat.format(ohlc.getDate())) + " O:" + this.numberFormat.format(ohlc.getOpen()) + " H:" + this.numberFormat.format(ohlc.getHigh()) + " L:" + this.numberFormat.format(ohlc.getLow()) + " C:" + this.numberFormat.format(ohlc.getHigh());
            }
            return String.valueOf(this.dataSeries.getName()) + ": " + this.numberFormat.format(this.dataSeries.getLast().getAdapter(Number.class));
        }
        return this.dataSeries.getName();
    }

    @Override
    public String getToolTip(int x, int y) {
        for (Polygon c : this.pointArray) {
            if (!c.containsPoint(x, y)) continue;
            return c.getToolTip();
        }
        return null;
    }

    @Override
    public void handleFocusGained(ChartObjectFocusEvent event) {
        this.focus = true;
    }

    @Override
    public void handleFocusLost(ChartObjectFocusEvent event) {
        this.focus = false;
    }

    protected boolean hasFocus() {
        return this.focus;
    }

    @Override
    public void accept(IChartObjectVisitor visitor) {
        visitor.visit(this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ISummaryBarDecorator.class)) {
            return this;
        }
        return null;
    }

    @Override
    public void createDecorator(Composite parent) {
        IAdaptable[] values = this.dataSeries.getValues();
        if (values.length == 0) {
            return;
        }
        IOHLC ohlc = (IOHLC)(values.length > 0 ? values[values.length - 1].getAdapter(IOHLC.class) : null);
        if (ohlc != null) {
            IOHLC previousOhlc = (IOHLC)(values.length > 1 ? values[values.length - 2].getAdapter(IOHLC.class) : null);
            this.dateItem = new SummaryDateItem(parent, 32);
            this.dateItem.setDate(ohlc != null ? ohlc.getDate() : null);
            this.ohlcItem = new SummaryOHLCItem(parent, 0);
            this.ohlcItem.setOHLC(ohlc, previousOhlc);
        } else {
            Number value = (Number)(values.length > 0 ? values[values.length - 1].getAdapter(Number.class) : null);
            this.numberItem = new SummaryNumberItem(parent, 0);
            this.numberItem.setValue(String.valueOf(this.dataSeries.getName()) + ": ", value);
            if (this.color != null) {
                this.numberItem.setForeground(this.color);
            }
        }
    }

    @Override
    public void updateDecorator(int x, int y) {
        if (this.pointArray != null) {
            int i = 0;
            while (i < this.pointArray.size()) {
                if (this.pointArray.get(i).containsPoint(x, y)) {
                    Number value;
                    if (this.numberItem != null && (value = (Number)this.values[i].getAdapter(Number.class)) != null) {
                        this.numberItem.setValue(String.valueOf(this.dataSeries.getName()) + ": ", value);
                    }
                    if (this.dateItem != null && this.ohlcItem != null) {
                        IOHLC ohlc = (IOHLC)this.values[i].getAdapter(IOHLC.class);
                        IOHLC previousOhlc = (IOHLC)(i >= 1 ? this.values[i - 1].getAdapter(IOHLC.class) : null);
                        this.dateItem.setDate(ohlc.getDate());
                        this.ohlcItem.setOHLC(ohlc, previousOhlc);
                    }
                }
                ++i;
            }
        }
    }

    public class Polygon {
        int x1;
        int x2;
        int y1;
        int y2;
        int yZero;
        int[] polygon = new int[8];
        Point[] points = new Point[5];
        IAdaptable value;

        public void setBounds(int yZero, int x1, int y1, int x2, int y2) {
            this.yZero = yZero;
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
            this.points[0] = new Point(x1, yZero);
            this.points[1] = new Point(x1, y1);
            this.points[2] = new Point(x2, y2);
            this.points[3] = new Point(x2, yZero);
            this.points[4] = this.points[0];
            this.polygon[0] = x1;
            this.polygon[1] = yZero;
            this.polygon[2] = x1;
            this.polygon[3] = y1;
            this.polygon[4] = x2;
            this.polygon[5] = y2;
            this.polygon[6] = x2;
            this.polygon[7] = yZero;
        }

        public void setValue(IAdaptable value) {
            this.value = value;
        }

        public void paint(IGraphics graphics) {
            graphics.setBackgroundColor(HistogramAreaChart.this.fillColor);
            graphics.fillPolygon(this.polygon);
            graphics.setForegroundColor(HistogramAreaChart.this.color);
            graphics.drawLine(this.x1, this.y1, this.x2, this.y2);
            graphics.drawLine(this.x1, this.yZero, this.x2, this.yZero);
        }

        public boolean containsPoint(int x, int y) {
            if (y == -1) {
                return x >= this.x1 && x < this.x2;
            }
            int crossings = 0;
            int i = 0;
            while (i < this.points.length - 1) {
                boolean cond3;
                int div = this.points[i + 1].y - this.points[i].y;
                if (div == 0) {
                    div = 1;
                }
                double slope = (this.points[i + 1].x - this.points[i].x) / div;
                boolean cond1 = this.points[i].y <= y && y < this.points[i + 1].y;
                boolean cond2 = this.points[i + 1].y <= y && y < this.points[i].y;
                boolean bl = cond3 = (double)x < slope * (double)(y - this.points[i].y) + (double)this.points[i].x;
                if ((cond1 || cond2) && cond3) {
                    ++crossings;
                }
                ++i;
            }
            return crossings % 2 != 0;
        }

        public String getToolTip() {
            IOHLC ohlc = (IOHLC)this.value.getAdapter(IOHLC.class);
            if (ohlc != null) {
                return String.valueOf(HistogramAreaChart.this.dataSeries.getName()) + "\r\nD:" + HistogramAreaChart.this.dateFormat.format(ohlc.getDate()) + "\r\nO:" + HistogramAreaChart.this.numberFormat.format(ohlc.getOpen()) + "\r\nH:" + HistogramAreaChart.this.numberFormat.format(ohlc.getHigh()) + "\r\nL:" + HistogramAreaChart.this.numberFormat.format(ohlc.getLow()) + "\r\nC:" + HistogramAreaChart.this.numberFormat.format(ohlc.getHigh());
            }
            return String.valueOf(HistogramAreaChart.this.dataSeries.getName()) + ": " + HistogramAreaChart.this.numberFormat.format(this.value.getAdapter(Number.class));
        }
    }
}

