/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.DataBounds;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.IGraphics;
import org.eclipsetrader.ui.charts.ISummaryBarDecorator;
import org.eclipsetrader.ui.charts.SummaryNumberItem;

public class HistogramBarChart
implements IChartObject,
ISummaryBarDecorator,
IAdaptable {
    private IDataSeries dataSeries;
    private int width = 5;
    private RGB positiveColor = new RGB(0, 254, 0);
    private RGB negativeColor = new RGB(254, 0, 0);
    private IAdaptable[] values;
    private List<Bar> pointArray = new ArrayList<Bar>(2048);
    private boolean valid;
    private boolean hasFocus;
    private SummaryNumberItem numberItem;
    private NumberFormat numberFormat = NumberFormat.getInstance();

    public HistogramBarChart(IDataSeries dataSeries) {
        this.dataSeries = dataSeries;
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setMinimumIntegerDigits(1);
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(4);
    }

    @Override
    public void setDataBounds(DataBounds dataBounds) {
        ArrayList<IAdaptable> l = new ArrayList<IAdaptable>(2048);
        IAdaptable[] iAdaptableArray = this.dataSeries.getValues();
        int n = iAdaptableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable value = iAdaptableArray[n2];
            Date date = (Date)value.getAdapter(Date.class);
            if (!(dataBounds.first != null && date.before(dataBounds.first) || dataBounds.last != null && date.after(dataBounds.last))) {
                l.add(value);
            }
            ++n2;
        }
        this.values = l.toArray(new IAdaptable[l.size()]);
        this.width = dataBounds.horizontalSpacing - 1;
        this.valid = false;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public void paint(IGraphics graphics) {
        if (!(this.valid && this.pointArray != null || this.values == null)) {
            int zero = graphics.mapToVerticalAxis(0.0);
            RGB positiveOutlineColor = this.blend(this.positiveColor, graphics.getForegroundColor(), 75);
            RGB negativeOutlineColor = this.blend(this.negativeColor, graphics.getForegroundColor(), 75);
            int i = 0;
            while (i < this.values.length) {
                Bar bar;
                Date date = (Date)this.values[i].getAdapter(Date.class);
                Number value = (Number)this.values[i].getAdapter(Number.class);
                Number previousValue = i > 0 ? (Number)((Number)this.values[i - 1].getAdapter(Number.class)) : (Number)null;
                int x = graphics.mapToHorizontalAxis(date) - this.width / 2;
                int y = graphics.mapToVerticalAxis(value);
                if (i < this.pointArray.size()) {
                    bar = this.pointArray.get(i);
                } else {
                    bar = new Bar();
                    this.pointArray.add(bar);
                }
                bar.setBounds(x, y, Math.abs(y - zero));
                bar.setValue(value);
                if (previousValue != null) {
                    bar.setColor(previousValue.doubleValue() > value.doubleValue() ? this.negativeColor : this.positiveColor);
                    bar.setOutlineColor(previousValue.doubleValue() > value.doubleValue() ? negativeOutlineColor : positiveOutlineColor);
                } else {
                    bar.setColor(this.positiveColor);
                    bar.setOutlineColor(positiveOutlineColor);
                }
                ++i;
            }
            while (this.pointArray.size() > this.values.length) {
                this.pointArray.remove(this.pointArray.size() - 1);
            }
            this.valid = true;
        }
        graphics.pushState();
        graphics.setLineWidth(this.hasFocus() ? 2 : 1);
        for (Bar c : this.pointArray) {
            c.paint(graphics);
        }
        graphics.popState();
    }

    @Override
    public void paintScale(Graphics graphics) {
    }

    @Override
    public boolean containsPoint(int x, int y) {
        for (Bar c : this.pointArray) {
            if (!c.containsPoint(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDataSeries getDataSeries() {
        return this.dataSeries;
    }

    @Override
    public String getToolTip() {
        if (this.dataSeries.getLast() != null) {
            return String.valueOf(this.dataSeries.getName()) + ": " + this.numberFormat.format(this.dataSeries.getLast().getAdapter(Number.class));
        }
        return this.dataSeries.getName();
    }

    @Override
    public String getToolTip(int x, int y) {
        for (Bar c : this.pointArray) {
            if (!c.containsPoint(x, y)) continue;
            return c.getToolTip();
        }
        return null;
    }

    @Override
    public void handleFocusGained(ChartObjectFocusEvent event) {
        this.hasFocus = true;
    }

    @Override
    public void handleFocusLost(ChartObjectFocusEvent event) {
        this.hasFocus = false;
    }

    protected boolean hasFocus() {
        return this.hasFocus;
    }

    @Override
    public void accept(IChartObjectVisitor visitor) {
        visitor.visit(this);
    }

    private RGB blend(RGB c1, RGB c2, int ratio) {
        int r = this.blend(c1.red, c2.red, ratio);
        int g = this.blend(c1.green, c2.green, ratio);
        int b = this.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private int blend(int v1, int v2, int ratio) {
        return (ratio * v1 + (100 - ratio) * v2) / 100;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ISummaryBarDecorator.class)) {
            return this;
        }
        return null;
    }

    @Override
    public void createDecorator(Composite parent) {
        IAdaptable[] values = this.dataSeries.getValues();
        Number value = (Number)(values.length > 0 ? values[values.length - 1].getAdapter(Number.class) : null);
        this.numberItem = new SummaryNumberItem(parent, 0);
        this.numberItem.setValue(String.valueOf(this.dataSeries.getName()) + ": ", value);
    }

    @Override
    public void updateDecorator(int x, int y) {
        if (this.pointArray != null) {
            int i = 0;
            while (i < this.pointArray.size()) {
                Number value;
                if (this.pointArray.get(i).containsPoint(x, y) && (value = (Number)this.values[i].getAdapter(Number.class)) != null) {
                    this.numberItem.setValue(String.valueOf(this.dataSeries.getName()) + ": ", value);
                }
                ++i;
            }
        }
    }

    private class Bar {
        int x;
        int y;
        int height;
        Number value;
        RGB color;
        RGB outlineColor;

        public void setBounds(int x, int y, int height) {
            this.x = x;
            this.y = y;
            this.height = height;
            if (height < 0) {
                this.y += height;
                this.height = -height;
            }
        }

        public void setValue(Number value) {
            this.value = value;
        }

        public void setColor(RGB color) {
            this.color = color;
        }

        public void setOutlineColor(RGB outlineColor) {
            this.outlineColor = outlineColor;
        }

        public void paint(IGraphics graphics) {
            graphics.setForegroundColor(this.outlineColor);
            graphics.setBackgroundColor(this.color);
            graphics.fillRectangle(this.x, this.y, HistogramBarChart.this.width, this.height);
            graphics.drawRectangle(this.x, this.y, HistogramBarChart.this.width - 1, this.height - 1);
        }

        public boolean containsPoint(int x, int y) {
            if (y == -1) {
                return x >= this.x && x <= this.x + HistogramBarChart.this.width;
            }
            if (x >= this.x && x <= this.x + HistogramBarChart.this.width) {
                return y >= this.y && y <= this.y + this.height;
            }
            return false;
        }

        public String getToolTip() {
            return String.valueOf(HistogramBarChart.this.dataSeries.getName()) + ": " + HistogramBarChart.this.numberFormat.format(this.value);
        }
    }
}

