/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipsetrader.ui.charts.ChartCanvas;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.ISummaryBarDecorator;

public class SummaryBarDecorator
implements MouseListener,
MouseMoveListener,
MouseTrackListener,
DisposeListener {
    private Point location;
    private boolean mouseDown;
    private List<ChartCanvas> decoratedCanvas = new ArrayList<ChartCanvas>();
    private IChartObjectVisitor summaryLabelVisitor = new IChartObjectVisitor(){

        @Override
        public boolean visit(IChartObject object) {
            ISummaryBarDecorator factory = null;
            if (object instanceof IAdaptable && (factory = (ISummaryBarDecorator)((IAdaptable)object).getAdapter(ISummaryBarDecorator.class)) != null) {
                factory.updateDecorator(SummaryBarDecorator.this.location != null ? ((SummaryBarDecorator)SummaryBarDecorator.this).location.x : -1, -1);
            }
            return true;
        }
    };

    public void decorateCanvas(ChartCanvas canvas) {
        canvas.getCanvas().addMouseListener((MouseListener)this);
        canvas.getCanvas().addMouseMoveListener((MouseMoveListener)this);
        canvas.getCanvas().addMouseTrackListener((MouseTrackListener)this);
        canvas.getCanvas().addDisposeListener((DisposeListener)this);
        this.decoratedCanvas.add(canvas);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        if (!this.mouseDown) {
            this.location = new Point(e.x, e.y);
            this.updateLabel();
            this.mouseDown = true;
        }
    }

    public void mouseUp(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        if (this.mouseDown) {
            this.location = null;
            this.updateLabel();
            this.mouseDown = false;
        }
    }

    private void updateLabel() {
        for (ChartCanvas canvas : this.decoratedCanvas) {
            canvas.accept(this.summaryLabelVisitor);
        }
    }

    public void mouseEnter(MouseEvent e) {
        if (this.mouseDown) {
            this.location = new Point(e.x, e.y);
            this.updateLabel();
        }
    }

    public void mouseExit(MouseEvent e) {
        if (this.location != null) {
            this.location = null;
        }
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseMove(MouseEvent e) {
        if (this.mouseDown) {
            this.location = new Point(e.x, e.y);
            this.updateLabel();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        for (ChartCanvas canvas : this.decoratedCanvas) {
            if (canvas.getCanvas() != e.widget) continue;
            this.decoratedCanvas.remove(canvas);
            break;
        }
    }
}

