/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.text.NumberFormat;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipsetrader.ui.charts.Messages;

public class SummaryNumberItem {
    private Label label;
    private Color color;
    private NumberFormat numberFormat = NumberFormat.getInstance();

    public SummaryNumberItem(Composite parent, int style) {
        this.label = new Label(parent, 0);
        this.label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SummaryNumberItem.this.color != null) {
                    SummaryNumberItem.this.color.dispose();
                }
            }
        });
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(4);
        this.numberFormat.setGroupingUsed(true);
    }

    public void setValue(String text, Number number) {
        this.label.setText(NLS.bind((String)Messages.SummaryNumberItem_Label, (Object[])new Object[]{text, number != null ? this.numberFormat.format(number) : ""}));
        this.label.getParent().layout();
    }

    public void setForeground(Color color) {
        this.label.setForeground(color);
    }

    public void setBackground(Color color) {
        this.label.setBackground(color);
    }

    public void setForeground(RGB rgb) {
        if (this.color != null) {
            this.color.dispose();
        }
        this.color = new Color((Device)this.label.getDisplay(), rgb);
        this.label.setForeground(this.color);
    }
}

