/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.text.NumberFormat;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipsetrader.core.feed.IOHLC;

public class SummaryOHLCItem {
    Label label;
    Label changeLabel;
    NumberFormat numberFormat = NumberFormat.getInstance();
    NumberFormat percentFormat = NumberFormat.getInstance();
    Color foreground;
    Color positiveForeground;
    Color negativeForeground;

    public SummaryOHLCItem(Composite parent, int style) {
        this.changeLabel = new Label(parent, 0);
        this.label = new Label(parent, 0);
        this.foreground = parent.getDisplay().getSystemColor(9);
        this.positiveForeground = parent.getDisplay().getSystemColor(5);
        this.negativeForeground = parent.getDisplay().getSystemColor(3);
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(4);
        this.numberFormat.setGroupingUsed(true);
        this.percentFormat.setMinimumFractionDigits(2);
        this.percentFormat.setMaximumFractionDigits(2);
        this.percentFormat.setGroupingUsed(false);
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getPositiveForeground() {
        return this.positiveForeground;
    }

    public void setPositiveForeground(Color positiveColor) {
        this.positiveForeground = positiveColor;
    }

    public Color getNegativeForeground() {
        return this.negativeForeground;
    }

    public void setNegativeForeground(Color negativeColor) {
        this.negativeForeground = negativeColor;
    }

    public void setOHLC(IOHLC currentOHLC, IOHLC previousOHLC) {
        if (currentOHLC != null) {
            this.label.setText(NLS.bind((String)"O={0} H={1} L={2} C={3}", (Object[])new Object[]{this.numberFormat.format(currentOHLC.getOpen()), this.numberFormat.format(currentOHLC.getHigh()), this.numberFormat.format(currentOHLC.getLow()), this.numberFormat.format(currentOHLC.getClose())}));
            if (previousOHLC != null) {
                double change = (currentOHLC.getClose() - previousOHLC.getClose()) / previousOHLC.getClose() * 100.0;
                this.changeLabel.setText(NLS.bind((String)"{0}%", (Object[])new Object[]{String.valueOf(change > 0.0 ? "+" : "") + this.percentFormat.format(change)}));
                if (change > 0.0) {
                    this.changeLabel.setForeground(this.positiveForeground);
                } else if (change < 0.0) {
                    this.changeLabel.setForeground(this.negativeForeground);
                } else {
                    this.changeLabel.setForeground(null);
                }
            }
        } else {
            this.label.setText("");
            this.changeLabel.setText("");
            this.changeLabel.setForeground(null);
        }
        this.label.setForeground(this.foreground);
        this.label.getParent().layout();
    }
}

