/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IStartup;
import org.eclipsetrader.core.ILauncher;
import org.eclipsetrader.ui.internal.UIActivator;

public class LaunchersStartup
implements IStartup {
    public static final String LAUNCHERS_EXTENSION_ID = "org.eclipsetrader.core.launchers";

    public void earlyStartup() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(LAUNCHERS_EXTENSION_ID);
        if (extensionPoint != null) {
            IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
            HashSet<String> set = new HashSet<String>(Arrays.asList(UIActivator.getDefault().getPreferenceStore().getString("STARTUP_LAUNCHERS").split(";")));
            int j = 0;
            while (j < configElements.length) {
                String id = configElements[j].getAttribute("id");
                if (set.contains(id)) {
                    try {
                        ILauncher launcher = (ILauncher)configElements[j].createExecutableExtension("class");
                        if (launcher != null) {
                            launcher.launch((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error launching " + id, (Throwable)e);
                        UIActivator.getDefault().getLog().log((IStatus)status);
                    }
                }
                ++j;
            }
        }
    }
}

