/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal;

import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.UUID;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.ui.INotificationService;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.internal.Messages;
import org.eclipsetrader.ui.internal.NotificationService;
import org.eclipsetrader.ui.internal.adapters.MarketAdapterFactory;
import org.eclipsetrader.ui.internal.adapters.RepositoryAdapterFactory;
import org.eclipsetrader.ui.internal.adapters.SecurityAdapterFactory;
import org.eclipsetrader.ui.internal.adapters.WatchListAdapterFactory;
import org.eclipsetrader.ui.internal.navigator.NavigatorViewItem;
import org.eclipsetrader.ui.internal.navigator.NavigatorViewItemAdapterFactory;
import org.eclipsetrader.ui.internal.repositories.RepositoryViewItem;
import org.eclipsetrader.ui.internal.repositories.RepositoryViewItemAdapterFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class UIActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipsetrader.ui";
    public static final String INDICATORS_EXTENSION_ID = "org.eclipsetrader.ui.indicators";
    public static final String PREFS_SHOW_SCALE_TOOLTIPS = "SHOW_SCALE_TOOLTIPS";
    public static final String PREFS_CROSSHAIR_ACTIVATION = "CROSSHAIR_ACTIVATION";
    public static final String PREFS_CROSSHAIR_SUMMARY_TOOLTIP = "CROSSHAIR_SUMMARY_TOOLTIP";
    public static final String PREFS_SHOW_TOOLTIPS = "SHOW_TOOLTIPS";
    public static final String PREFS_INITIAL_BACKFILL_METHOD = "INITIAL_BACKFILL_METHOD";
    public static final String PREFS_INITIAL_BACKFILL_START_DATE = "INITIAL_BACKFILL_START_DATE";
    public static final String PREFS_INITIAL_BACKFILL_YEARS = "INITIAL_BACKFILL_YEARS";
    public static final String PREFS_WATCHLIST_ALTERNATE_BACKGROUND = "WATCHLIST_ALTERNATE_BACKGROUND";
    public static final String PREFS_WATCHLIST_ENABLE_TICK_DECORATORS = "WATCHLIST_ENABLE_TICK_DECORATORS";
    public static final String PREFS_WATCHLIST_POSITIVE_TICK_COLOR = "WATCHLIST_POSITIVE_TICK_COLOR";
    public static final String PREFS_WATCHLIST_NEGATIVE_TICK_COLOR = "WATCHLIST_NEGATIVE_TICK_COLOR";
    public static final String PREFS_WATCHLIST_DRAW_TICK_OUTLINE = "WATCHLIST_DRAW_TICK_OUTLINE";
    public static final String PREFS_WATCHLIST_FADE_TO_BACKGROUND = "WATCHLIST_FADE_TO_BACKGROUND";
    public static final String PREFS_TEXT_EDITOR_FONT = "TEXT_EDITOR_FONT";
    public static final String PREFS_CHART_PERIODS = "CHART_PERIODS";
    public static final String PREFS_CHART_BARS = "CHART_BARS";
    public static final String ALERT_NOTIFICATION_IMAGE = "alert_notification_image";
    public static final String ALERT_ADD_IMAGE = "alert_add_image";
    public static final String ALERT_DELETE_IMAGE = "alert_delete_image";
    public static final String ALERT_WIZARD_IMAGE = "alert_wizard_image";
    public static final String IMG_STRATEGY = "strategy";
    public static final String IMG_FOLDER = "folder";
    public static final String IMG_INSTRUMENT = "instrument";
    public static final String IMG_SCRIPT_FOLDER = "script-folder";
    public static final String IMG_SCRIPT_INCLUDE = "script-include";
    public static final String IMG_MAIN_SCRIPT = "main-script";
    public static final String IMG_REMOVE_ICON = "remove";
    public static final String IMG_REMOVE_DISABLED_ICON = "remove-disabled";
    public static final String IMG_DELETE_ICON = "delete";
    public static final String IMG_DELETE_DISABLED_ICON = "delete-disabled";
    public static final String IMG_TRADING_SYSTEM = "trading-system";
    public static final String K_VIEWS_SECTION = "Views";
    public static final String K_URI = "uri";
    private static UIActivator plugin;
    private ServiceRegistration notificationServiceRegistration;
    private IRepositoryService repositoryService;
    private IMarketService marketService;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        AdapterManager.getDefault().registerAdapters((IAdapterFactory)new SecurityAdapterFactory(), ISecurity.class);
        AdapterManager.getDefault().registerAdapters((IAdapterFactory)new WatchListAdapterFactory(), IWatchList.class);
        AdapterManager.getDefault().registerAdapters((IAdapterFactory)new MarketAdapterFactory(), IMarket.class);
        AdapterManager.getDefault().registerAdapters((IAdapterFactory)new RepositoryAdapterFactory(), IRepository.class);
        AdapterManager.getDefault().registerAdapters((IAdapterFactory)new NavigatorViewItemAdapterFactory(), NavigatorViewItem.class);
        AdapterManager.getDefault().registerAdapters((IAdapterFactory)new RepositoryViewItemAdapterFactory(), RepositoryViewItem.class);
        NotificationService notificationService = new NotificationService();
        this.notificationServiceRegistration = context.registerService(new String[]{INotificationService.class.getName(), NotificationService.class.getName()}, (Object)notificationService, new Hashtable());
    }

    public void stop(BundleContext context) throws Exception {
        if (this.notificationServiceRegistration != null) {
            this.notificationServiceRegistration.unregister();
        }
        plugin = null;
        super.stop(context);
    }

    public static UIActivator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Image getImageFromRegistry(String key) {
        if (plugin == null || plugin.getImageRegistry() == null) {
            return null;
        }
        return plugin.getImageRegistry().get(key);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put("blank_obj", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/blank_obj.gif")));
        reg.put("folder_obj", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/fldr_obj.png")));
        reg.put("market_obj", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/market.png")));
        reg.put("market_fldr", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/market_fldr.png")));
        reg.put("repository", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/repository.png")));
        reg.put("repository_fldr", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/repository_fldr.png")));
        reg.put("repository_object_fldr", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/repository_object_fldr.png")));
        reg.put("repository_object", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/repository_object.png")));
        reg.put(IMG_DELETE_ICON, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/elcl16/delete.gif")));
        reg.put("delete_disabled", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/dlcl16/delete.gif")));
        reg.put("cut_edit", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/etool16/cut_edit.gif")));
        reg.put("cut_edit_disabled", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/dtool16/cut_edit.gif")));
        reg.put("copy_edit", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/etool16/copy_edit.gif")));
        reg.put("copy_edit_disabled", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/dtool16/copy_edit.gif")));
        reg.put("paste_edit", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/etool16/paste_edit.gif")));
        reg.put("paste_edit_disabled", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/dtool16/paste_edit.gif")));
        reg.put("delete_edit", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/etool16/delete_edit.gif")));
        reg.put("delete_edit_disabled", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/dtool16/delete_edit.gif")));
        reg.put("refresh", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/elcl16/refresh.gif")));
        reg.put("collapseall", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/elcl16/collapseall.gif")));
        reg.put("expandall", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/elcl16/expandall.gif")));
        reg.put("trend_stable", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/trend_stable.gif")));
        reg.put("trend_up", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/trend_up.gif")));
        reg.put("trend_down", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/trend_down.gif")));
        reg.put("toolbar-arrow-down.gif", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/etool16/toolbar-arrow-down.gif")));
        reg.put("toolbar-arrow-right.gif", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/etool16/toolbar-arrow-right.gif")));
        reg.put(ALERT_NOTIFICATION_IMAGE, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/eview16/bell.png")));
        reg.put(ALERT_WIZARD_IMAGE, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/wizban/newfile_wiz.gif")));
        reg.put(ALERT_ADD_IMAGE, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/elcl16/bell_add.png")));
        reg.put(ALERT_DELETE_IMAGE, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/elcl16/delete.gif")));
        reg.put(IMG_FOLDER, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/folder.png")));
        reg.put(IMG_INSTRUMENT, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/shape_square.png")));
        reg.put(IMG_SCRIPT_FOLDER, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/folder_page_white.png")));
        reg.put(IMG_MAIN_SCRIPT, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/page_white_code.png")));
        reg.put(IMG_SCRIPT_INCLUDE, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/script_link.png")));
        reg.put(IMG_REMOVE_ICON, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/etool16/remove_exc.gif")));
        reg.put(IMG_REMOVE_DISABLED_ICON, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/dtool16/remove_exc.gif")));
        reg.put(IMG_DELETE_ICON, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/etool16/delete.gif")));
        reg.put(IMG_DELETE_DISABLED_ICON, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/dtool16/delete.gif")));
        reg.put(IMG_TRADING_SYSTEM, ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/obj16/cog.png")));
    }

    public IRepositoryService getRepositoryService() {
        BundleContext context;
        ServiceReference serviceReference;
        if (this.repositoryService == null && (serviceReference = (context = this.getBundle().getBundleContext()).getServiceReference(IRepositoryService.class.getName())) != null) {
            this.repositoryService = (IRepositoryService)context.getService(serviceReference);
        }
        return this.repositoryService;
    }

    public IMarketService getMarketService() {
        BundleContext context;
        ServiceReference serviceReference;
        if (this.marketService == null && (serviceReference = (context = this.getBundle().getBundleContext()).getServiceReference(IMarketService.class.getName())) != null) {
            this.marketService = (IMarketService)context.getService(serviceReference);
        }
        return this.marketService;
    }

    public IDialogSettings getDialogSettingsForView(URI uri) {
        String uriString = uri.toString();
        IDialogSettings rootSettings = this.getDialogSettings().getSection(K_VIEWS_SECTION);
        if (rootSettings == null) {
            rootSettings = this.getDialogSettings().addNewSection(K_VIEWS_SECTION);
        }
        IDialogSettings[] sections = rootSettings.getSections();
        int i = 0;
        while (i < sections.length) {
            if (uriString.equals(sections[i].get(K_URI))) {
                return sections[i];
            }
            ++i;
        }
        String uuid = UUID.randomUUID().toString();
        IDialogSettings dialogSettings = rootSettings.addNewSection(uuid);
        dialogSettings.put(K_URI, uriString);
        return dialogSettings;
    }

    public static void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        } else {
            System.err.println(status);
        }
    }

    public static void log(String message, Throwable throwable) {
        Status status = new Status(4, PLUGIN_ID, message, throwable);
        if (plugin != null) {
            plugin.getLog().log((IStatus)status);
        } else {
            System.err.println(status);
        }
    }

    public IChartObjectFactory getChartObjectFactory(String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(INDICATORS_EXTENSION_ID);
        if (extensionPoint == null) {
            return null;
        }
        IConfigurationElement targetElement = null;
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            String strID = configElements[j].getAttribute("id");
            if (targetID.equals(strID)) {
                targetElement = configElements[j];
                break;
            }
            ++j;
        }
        if (targetElement == null) {
            return null;
        }
        try {
            return (IChartObjectFactory)targetElement.createExecutableExtension("class");
        }
        catch (Exception e) {
            Status status = new Status(2, PLUGIN_ID, 0, String.valueOf(Messages.ChartsUIActivator_IndicatorErrorMessage) + targetID, (Throwable)e);
            this.getLog().log((IStatus)status);
            return null;
        }
    }

    public IConfigurationElement getChartObjectConfiguration(String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(INDICATORS_EXTENSION_ID);
        if (extensionPoint == null) {
            return null;
        }
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            String strID = configElements[j].getAttribute("id");
            if (targetID.equals(strID)) {
                return configElements[j];
            }
            ++j;
        }
        return null;
    }

    public static ImageDescriptor imageDescriptorFromPlugin(String imageFilePath) {
        return UIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imageFilePath);
    }
}

