/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.monitor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.views.Column;
import org.eclipsetrader.core.views.IColumn;
import org.eclipsetrader.ui.internal.ats.ViewColumn;
import org.eclipsetrader.ui.internal.ats.monitor.Messages;
import org.eclipsetrader.ui.internal.ats.monitor.TradingSystemsViewModel;
import org.eclipsetrader.ui.internal.views.ColumnsViewer;

public class ColumnsProperties
extends PropertyPage
implements IWorkbenchPropertyPage {
    private ColumnsViewer providers;

    public ColumnsProperties() {
        this.setTitle(Messages.ColumnsProperties_Columns);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        this.providers = new ColumnsViewer(content);
        this.providers.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.providers.setInput(CoreActivator.getDefault().getDataProviderFactories());
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        TradingSystemsViewModel resource = (TradingSystemsViewModel)((Object)this.getElement().getAdapter(TradingSystemsViewModel.class));
        List<ViewColumn> columns = resource.getDataProviders();
        Column[] selectedColumns = new Column[columns.size()];
        int i = 0;
        while (i < selectedColumns.length) {
            selectedColumns[i] = new Column(columns.get(i).getName(), columns.get(i).getDataProviderFactory());
            ++i;
        }
        this.providers.setSelectedColumns((IColumn[])selectedColumns);
        super.performDefaults();
    }

    protected void applyChanges() {
        TradingSystemsViewModel resource = (TradingSystemsViewModel)((Object)this.getElement().getAdapter(TradingSystemsViewModel.class));
        ArrayList<ViewColumn> c = new ArrayList<ViewColumn>();
        IColumn[] iColumnArray = this.providers.getSelection();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn column = iColumnArray[n2];
            c.add(new ViewColumn(column.getName(), column.getDataProviderFactory()));
            ++n2;
        }
        resource.setDataProviders(c);
    }

    protected void performApply() {
        this.applyChanges();
        super.performApply();
    }

    public boolean performOk() {
        if (this.getControl() != null) {
            this.applyChanges();
        }
        return super.performOk();
    }
}

