/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.monitor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipsetrader.core.ats.ITradingSystemInstrument;
import org.eclipsetrader.ui.NullRealm;
import org.eclipsetrader.ui.internal.ats.ViewItem;
import org.eclipsetrader.ui.internal.ats.monitor.TradingSystemItem;

public class TradingSystemInstrumentItem
implements ViewItem {
    public static final int STATUS_NORMAL = 0;
    public static final int STATUS_ADDED = 1;
    public static final int STATUS_REMOVED = 2;
    public static final String PROP_STATUS = "status";
    final TradingSystemItem parent;
    final ITradingSystemInstrument instrument;
    private int status = 0;
    private final WritableMap observableValues = new WritableMap(NullRealm.getInstance(), String.class, Object.class);
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private final PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TradingSystemInstrumentItem.this.parent.getModel().updateValues(TradingSystemInstrumentItem.this);
        }
    };

    public TradingSystemInstrumentItem(TradingSystemItem parent, ITradingSystemInstrument instrument) {
        this.parent = parent;
        this.instrument = instrument;
        this.observableValues.put((Object)"_label_", (Object)this.toString());
        PropertyChangeSupport changeSupport = (PropertyChangeSupport)instrument.getAdapter(PropertyChangeSupport.class);
        if (changeSupport != null) {
            changeSupport.addPropertyChangeListener(this.changeListener);
        }
    }

    public ITradingSystemInstrument getInstrument() {
        return this.instrument;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        this.changeSupport.firePropertyChange(PROP_STATUS, this.status, this.status);
    }

    @Override
    public Object getValue(String name) {
        return this.observableValues.get((Object)name);
    }

    @Override
    public void putValue(String name, Object value) {
        Object oldValue = this.observableValues.get((Object)name);
        if (oldValue != null && value != null && oldValue.equals(value)) {
            return;
        }
        this.observableValues.put((Object)name, value);
        this.changeSupport.firePropertyChange(name, oldValue, value);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public ViewItem getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public ObservableList getItems() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.instrument.getClass())) {
            return this.instrument;
        }
        Object result = this.instrument.getAdapter(adapter);
        if (result != null) {
            return result;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public String toString() {
        return this.instrument.getInstrument().getName();
    }
}

