/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.monitor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipsetrader.core.ats.ITradingSystem;
import org.eclipsetrader.core.ats.ITradingSystemInstrument;
import org.eclipsetrader.ui.NullRealm;
import org.eclipsetrader.ui.internal.ats.ViewItem;
import org.eclipsetrader.ui.internal.ats.monitor.TradingSystemInstrumentItem;
import org.eclipsetrader.ui.internal.ats.monitor.TradingSystemsViewModel;

public class TradingSystemItem
implements ViewItem {
    private final TradingSystemsViewModel model;
    final ITradingSystem tradingSystem;
    private final List<TradingSystemInstrumentItem> list = new ArrayList<TradingSystemInstrumentItem>();
    private final WritableList childs = new WritableList(this.list, TradingSystemInstrumentItem.class);
    private final WritableMap observableValues = new WritableMap(NullRealm.getInstance(), String.class, Object.class);
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("instruments".equals(evt.getPropertyName())) {
                ITradingSystemInstrument[] instrument = (ITradingSystemInstrument[])evt.getNewValue();
                int i = 0;
                while (i < instrument.length) {
                    if (!TradingSystemItem.this.hasInstrument(instrument[i])) {
                        TradingSystemInstrumentItem instrumentItem = new TradingSystemInstrumentItem(TradingSystemItem.this, instrument[i]);
                        if (TradingSystemItem.this.tradingSystem.getStatus() != 4) {
                            instrumentItem.setStatus(1);
                        }
                        TradingSystemItem.this.model.updateValues(instrumentItem);
                        TradingSystemItem.this.childs.add((Object)instrumentItem);
                    }
                    ++i;
                }
                if (TradingSystemItem.this.tradingSystem.getStatus() != 2) {
                    TradingSystemItem.this.cleanUp();
                }
            } else if ("status".equals(evt.getPropertyName()) && TradingSystemItem.this.tradingSystem.getStatus() == 4) {
                TradingSystemItem.this.cleanUp();
            }
        }
    };

    public TradingSystemItem(TradingSystemsViewModel model, ITradingSystem tradingSystem) {
        this.model = model;
        this.tradingSystem = tradingSystem;
        ITradingSystemInstrument[] iTradingSystemInstrumentArray = tradingSystem.getInstruments();
        int n = iTradingSystemInstrumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITradingSystemInstrument instrument = iTradingSystemInstrumentArray[n2];
            this.list.add(new TradingSystemInstrumentItem(this, instrument));
            ++n2;
        }
        PropertyChangeSupport changeSupport = (PropertyChangeSupport)tradingSystem.getAdapter(PropertyChangeSupport.class);
        if (changeSupport != null) {
            changeSupport.addPropertyChangeListener(this.changeListener);
        }
        this.observableValues.put((Object)"_label_", (Object)this.toString());
    }

    public ITradingSystem getTradingSystem() {
        return this.tradingSystem;
    }

    public List<TradingSystemInstrumentItem> getList() {
        return this.list;
    }

    public TradingSystemsViewModel getModel() {
        return this.model;
    }

    private boolean hasInstrument(ITradingSystemInstrument instrument) {
        for (TradingSystemInstrumentItem instrumentItem : this.list) {
            if (instrumentItem.getInstrument() != instrument) continue;
            return true;
        }
        return false;
    }

    private void cleanUp() {
        for (TradingSystemInstrumentItem instrumentItem : this.list) {
            instrumentItem.setStatus(0);
        }
        this.childs.getRealm().exec(new Runnable(){

            @Override
            public void run() {
                HashSet<ITradingSystemInstrument> set = new HashSet<ITradingSystemInstrument>(Arrays.asList(TradingSystemItem.this.tradingSystem.getInstruments()));
                for (TradingSystemInstrumentItem instrumentItem : new ArrayList(TradingSystemItem.this.list)) {
                    if (set.contains(instrumentItem.getInstrument())) continue;
                    TradingSystemItem.this.childs.remove((Object)instrumentItem);
                }
            }
        });
    }

    @Override
    public Object getValue(String name) {
        return this.observableValues.get((Object)name);
    }

    @Override
    public void putValue(String name, Object value) {
        Object oldValue = this.observableValues.get((Object)name);
        if (oldValue != null && value != null && oldValue.equals(value)) {
            return;
        }
        this.observableValues.put((Object)name, value);
        this.changeSupport.firePropertyChange(name, oldValue, value);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public ViewItem getParent() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public ObservableList getItems() {
        return this.childs;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.tradingSystem.getClass())) {
            return this.tradingSystem;
        }
        Object result = this.tradingSystem.getAdapter(adapter);
        if (result != null) {
            return result;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public String toString() {
        return this.tradingSystem.getStrategy().getName();
    }
}

