/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.internal.ats.TimeSpanDialog;
import org.eclipsetrader.ui.internal.ats.wizards.Messages;

public class BarsPage
extends WizardPage {
    private ListViewer viewer;
    private Button add;
    private Button remove;
    private List<TimeSpan> list = new ArrayList<TimeSpan>();

    public BarsPage() {
        super("bars", Messages.BarsPage_Bars, null);
        this.setDescription(Messages.BarsPage_SetBarTimespan);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)content);
        this.initializeDialogUnits((Control)content);
        this.list.add(TimeSpan.days((int)1));
        this.viewer = new ListViewer(content, 2050);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                TimeSpan timeSpan = (TimeSpan)element;
                return NLS.bind((String)"{0} {1}", (Object[])new Object[]{String.valueOf(timeSpan.getLength()), timeSpan.getUnits()});
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TimeSpan ts1 = (TimeSpan)e1;
                TimeSpan ts2 = (TimeSpan)e2;
                if (ts1.higherThan(ts2)) {
                    return 1;
                }
                if (ts2.higherThan(ts1)) {
                    return -1;
                }
                return 0;
            }
        });
        this.viewer.setInput(this.list);
        Composite buttons = new Composite(content, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.add = new Button(buttons, 8);
        this.add.setText(Messages.BarsPage_Add);
        this.add.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeSpanDialog dlg = new TimeSpanDialog(BarsPage.this.getShell());
                if (dlg.open() == 0) {
                    BarsPage.this.list.add(dlg.getSelection());
                    BarsPage.this.viewer.refresh();
                }
            }
        });
        this.remove = new Button(buttons, 8);
        this.remove.setText(Messages.BarsPage_Remove);
        this.remove.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)BarsPage.this.viewer.getSelection();
                BarsPage.this.list.removeAll(selection.toList());
                BarsPage.this.viewer.refresh();
            }
        });
        this.remove.setEnabled(false);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BarsPage.this.remove.setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    public TimeSpan[] getValues() {
        return this.list.toArray(new TimeSpan[this.list.size()]);
    }
}

