/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.ats.IStrategy;
import org.eclipsetrader.core.ats.ScriptStrategy;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.internal.ats.SaveAdaptableHelper;
import org.eclipsetrader.ui.internal.ats.TimeSpanDialog;
import org.eclipsetrader.ui.internal.ats.wizards.Messages;

public class BarsProperties
extends PropertyPage
implements IWorkbenchPropertyPage {
    private ListViewer viewer;
    private Button add;
    private Button remove;
    private List<TimeSpan> list = new ArrayList<TimeSpan>();

    public BarsProperties() {
        this.setTitle(Messages.BarsProperties_Bars);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        this.viewer = new ListViewer(content, 2050);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                TimeSpan timeSpan = (TimeSpan)element;
                return NLS.bind((String)"{0} {1}", (Object[])new Object[]{String.valueOf(timeSpan.getLength()), timeSpan.getUnits()});
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TimeSpan ts1 = (TimeSpan)e1;
                TimeSpan ts2 = (TimeSpan)e2;
                if (ts1.higherThan(ts2)) {
                    return 1;
                }
                if (ts2.higherThan(ts1)) {
                    return -1;
                }
                return 0;
            }
        });
        this.viewer.setInput(this.list);
        Composite buttons = new Composite(content, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.add = new Button(buttons, 8);
        this.add.setText(Messages.BarsProperties_Add);
        this.add.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeSpanDialog dlg = new TimeSpanDialog(BarsProperties.this.getShell());
                if (dlg.open() == 0) {
                    BarsProperties.this.list.add(dlg.getSelection());
                    BarsProperties.this.viewer.refresh();
                }
            }
        });
        this.remove = new Button(buttons, 8);
        this.remove.setText(Messages.BarsProperties_Remove);
        this.remove.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)BarsProperties.this.viewer.getSelection();
                BarsProperties.this.list.removeAll(selection.toList());
                BarsProperties.this.viewer.refresh();
            }
        });
        this.remove.setEnabled(false);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BarsProperties.this.remove.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        IStrategy strategy = (IStrategy)this.getElement().getAdapter(IStrategy.class);
        this.list.clear();
        this.list.addAll(Arrays.asList(strategy.getBarsTimeSpan()));
        this.viewer.refresh();
        super.performDefaults();
    }

    protected void applyChanges() {
        ScriptStrategy strategy = (ScriptStrategy)this.getElement().getAdapter(ScriptStrategy.class);
        if (strategy != null) {
            strategy.setBarsTimeSpan(this.list.toArray(new TimeSpan[this.list.size()]));
        }
    }

    public boolean isValid() {
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        return true;
    }

    public boolean performOk() {
        if (this.getControl() != null) {
            this.applyChanges();
        }
        return super.performOk();
    }

    protected void performApply() {
        this.applyChanges();
        SaveAdaptableHelper.save(this.getElement());
        super.performApply();
    }
}

