/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.wizards;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.ats.IStrategy;
import org.eclipsetrader.core.ats.ScriptStrategy;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.ats.SaveAdaptableHelper;
import org.eclipsetrader.ui.internal.ats.wizards.Messages;

public class GeneralProperties
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Text name;
    private ComboViewer repository;
    private IRepository targetRepository;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            GeneralProperties.this.setValid(GeneralProperties.this.isValid());
        }
    };

    public GeneralProperties() {
        this.setTitle(Messages.GeneralProperties_General);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        Label label = new Label(content, 0);
        label.setText(Messages.GeneralProperties_Name);
        this.name = new Text(content, 2048);
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        label = new Label(content, 0);
        label.setText(Messages.GeneralProperties_TargetRepository);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.repository = new ComboViewer(content, 8);
        this.repository.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.repository.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.repository.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.repository.setSorter(new ViewerSorter());
        this.repository.setInput((Object)this.getRepositoryService().getRepositories());
        this.repository.setSelection((ISelection)new StructuredSelection((Object)this.getRepositoryService().getRepository("local")));
        this.performDefaults();
        this.name.addModifyListener(this.modifyListener);
        return content;
    }

    protected void performDefaults() {
        IStrategy strategy = (IStrategy)this.getElement().getAdapter(IStrategy.class);
        this.name.setText(strategy.getName());
        IStoreObject storeObject = (IStoreObject)strategy.getAdapter(IStoreObject.class);
        this.repository.setSelection((ISelection)new StructuredSelection((Object)storeObject.getStore().getRepository()));
        super.performDefaults();
    }

    protected void applyChanges() {
        ScriptStrategy strategy = (ScriptStrategy)this.getElement().getAdapter(ScriptStrategy.class);
        if (strategy != null) {
            strategy.setName(this.name.getText());
        }
        this.targetRepository = (IRepository)((IStructuredSelection)this.repository.getSelection()).getFirstElement();
    }

    public boolean isValid() {
        if (this.name.getText().equals("")) {
            this.setErrorMessage(Messages.GeneralProperties_StrategyMustHaveName);
            return false;
        }
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        return true;
    }

    public boolean performOk() {
        if (this.getControl() != null) {
            this.applyChanges();
        }
        return super.performOk();
    }

    protected void performApply() {
        this.applyChanges();
        SaveAdaptableHelper.save(this.getElement(), this.targetRepository);
        super.performApply();
    }

    public IRepository getRepository() {
        return this.targetRepository;
    }

    protected IRepositoryService getRepositoryService() {
        return UIActivator.getDefault().getRepositoryService();
    }
}

