/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.wizards;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipsetrader.core.ats.ScriptStrategy;
import org.eclipsetrader.ui.PriorityPreferenceNode;
import org.eclipsetrader.ui.internal.ats.SaveAdaptableHelper;
import org.eclipsetrader.ui.internal.ats.wizards.BarsProperties;
import org.eclipsetrader.ui.internal.ats.wizards.GeneralProperties;
import org.eclipsetrader.ui.internal.ats.wizards.InstrumentsProperties;
import org.eclipsetrader.ui.internal.ats.wizards.Messages;

public class StrategyPropertiesHandler
extends AbstractHandler {
    private GeneralProperties generalProperties;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchSite site = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty()) {
            Object target = selection.getFirstElement();
            if (target instanceof IAdaptable) {
                target = ((IAdaptable)target).getAdapter(ScriptStrategy.class);
            }
            if (target instanceof ScriptStrategy) {
                this.openPropertiesDialog(site.getShell(), this.getWrappedElement(target));
            }
        }
        return null;
    }

    protected void openPropertiesDialog(Shell shell, final IAdaptable adaptableElement) {
        PropertyPageManager pageManager = new PropertyPageManager();
        this.generalProperties = new GeneralProperties();
        pageManager.addToRoot((IPreferenceNode)new PriorityPreferenceNode("org.eclipsetrader.ui.propertypages.general", (IPreferencePage)this.generalProperties, -1));
        pageManager.addToRoot((IPreferenceNode)new PriorityPreferenceNode("org.eclipsetrader.ui.propertypages.instruments", (IPreferencePage)new InstrumentsProperties(), 0));
        pageManager.addToRoot((IPreferenceNode)new PriorityPreferenceNode("org.eclipsetrader.ui.propertypages.bars", (IPreferencePage)new BarsProperties(), 0));
        PropertyPageContributorManager.getManager().contribute(pageManager, (Object)adaptableElement);
        for (Object nodeObj : pageManager.getElements(0)) {
            IPreferenceNode node = (IPreferenceNode)nodeObj;
            if (!(node.getPage() instanceof PropertyPage)) continue;
            ((PropertyPage)node.getPage()).setElement(adaptableElement);
        }
        FilteredPreferenceDialog dlg = new FilteredPreferenceDialog(shell, (PreferenceManager)pageManager){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                ScriptStrategy element = (ScriptStrategy)adaptableElement.getAdapter(ScriptStrategy.class);
                newShell.setText(String.valueOf(Messages.StrategyPropertiesHandler_PropertiesFor) + element.getName());
            }
        };
        dlg.setHelpAvailable(false);
        if (dlg.open() == 0) {
            SaveAdaptableHelper.save(adaptableElement, this.generalProperties.getRepository());
        }
    }

    protected IAdaptable getWrappedElement(final Object element) {
        if (element instanceof IAdaptable) {
            return (IAdaptable)element;
        }
        return new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter.isAssignableFrom(element.getClass())) {
                    return element;
                }
                return null;
            }
        };
    }
}

