/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipsetrader.core.feed.History;
import org.eclipsetrader.core.feed.HistoryDay;
import org.eclipsetrader.core.feed.IConnectorOverride;
import org.eclipsetrader.core.feed.IDividend;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.ISplit;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.instruments.Stock;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.charts.Messages;

public class DataImportJob
extends Job {
    public static final int FULL = 0;
    public static final int INCREMENTAL = 1;
    public static final int FULL_INCREMENTAL = 2;
    private ISecurity[] securities;
    private int mode;
    private TimeSpan[] timeSpan;
    private Date fromDate;
    private Date toDate;
    private List<IStatus> results = new ArrayList<IStatus>();
    IPreferenceStore preferences;

    public DataImportJob(ISecurity security, int mode, Date fromDate, Date toDate, TimeSpan[] timeSpan) {
        super(Messages.DataImportJob_Name);
        this.securities = new ISecurity[]{security};
        this.mode = mode;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.timeSpan = timeSpan;
    }

    public DataImportJob(ISecurity[] securities, int mode, Date fromDate, Date toDate, TimeSpan[] timeSpan) {
        super(Messages.DataImportJob_Name);
        this.securities = securities;
        this.mode = mode;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.timeSpan = timeSpan;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        block54: {
            block53: {
                block56: {
                    block55: {
                        block51: {
                            block52: {
                                filteredList = this.getFilteredSecurities(this.securities);
                                monitor.beginTask(this.getName(), filteredList.length);
                                this.preferences = UIActivator.getDefault().getPreferenceStore();
                                defaultBackfillConnector = CoreActivator.getDefault().getDefaultBackfillConnector();
                                defaultIntradayBackfillConnector = CoreActivator.getDefault().getDefaultBackfillConnector();
                                repositoryService = UIActivator.getDefault().getRepositoryService();
                                marketService = UIActivator.getDefault().getMarketService();
                                var10_8 = filteredList;
                                var9_9 = filteredList.length;
                                var8_10 = 0;
lbl12:
                                // 2 sources

                                while (var8_10 < var9_9) {
                                    security = var10_8[var8_10];
                                    if (monitor.isCanceled()) {
                                        if (this.results.size() == 0) break block51;
                                        var34_50 = new MultiStatus("org.eclipsetrader.ui", 0, this.results.toArray(new IStatus[this.results.size()]), Messages.DataImportJob_DownloadErrorMessage, null);
                                        break block52;
                                    }
                                    ** GOTO lbl-1000
                                }
                                break block53;
                            }
                            monitor.done();
                            return var34_50;
                        }
                        ** try [egrp 1[TRYBLOCK] [4, 9 : 152->157)] { 
lbl27:
                        // 1 sources

                        return Status.CANCEL_STATUS;
lbl28:
                        // 2 sources

                        catch (Exception e) {
                            status = new Status(4, "org.eclipsetrader.ui", 0, Messages.DataImportJob_DataErrorMessage, (Throwable)e);
                            this.results.add((IStatus)status);
                            break block54;
                        }
lbl-1000:
                        // 1 sources

                        {
                            monitor.subTask(security.getName().replace("&", "&&"));
                            try {
                                storeObject = (IStoreObject)security.getAdapter(IStoreObject.class);
                                defaultRepository = storeObject.getStore().getRepository();
                                identifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class);
                                backfillConnector = defaultBackfillConnector;
                                intradayBackfillConnector = defaultIntradayBackfillConnector;
                                market = marketService.getMarketForSecurity(security);
                                if (market != null && market.getBackfillConnector() != null) {
                                    backfillConnector = market.getBackfillConnector();
                                    v0 = intradayBackfillConnector = market.getIntradayBackfillConnector() != null ? market.getIntradayBackfillConnector() : market.getBackfillConnector();
                                }
                                if ((override = (IConnectorOverride)AdapterManager.getDefault().getAdapter((Object)security, IConnectorOverride.class)) != null) {
                                    if (override.getBackfillConnector() != null) {
                                        backfillConnector = override.getBackfillConnector();
                                        intradayBackfillConnector = override.getBackfillConnector();
                                    }
                                    if (override.getIntradayBackfillConnector() != null) {
                                        intradayBackfillConnector = override.getIntradayBackfillConnector();
                                    }
                                }
                                beginDate = this.fromDate;
                                endDate = this.toDate;
                                if (beginDate == null) {
                                    beginDate = this.getDefaultStartDate();
                                }
                                if (endDate == null) {
                                    endDate = new Date();
                                }
                                history = repositoryService.getHistoryFor(security);
                                dailyDataMap = new HashMap<Date, IOHLC>(2048);
                                if (history != null && this.mode != 0) {
                                    var25_31 = history.getOHLC();
                                    var24_29 = var25_31.length;
                                    var23_25 = 0;
                                    while (var23_25 < var24_29) {
                                        d = var25_31[var23_25];
                                        dailyDataMap.put(d.getDate(), d);
                                        ++var23_25;
                                    }
                                    if (this.mode == 1) {
                                        if (history.getLast() != null) {
                                            beginDate = history.getLast().getDate();
                                        }
                                        endDate = Calendar.getInstance().getTime();
                                    }
                                }
                                dataMap = new HashMap<TimeSpan, IOHLC[]>();
                                var26_35 = this.timeSpan;
                                var25_32 = this.timeSpan.length;
                                var24_29 = 0;
lbl76:
                                // 2 sources

                                while (var24_29 < var25_32) {
                                    currentTimeSpan = var26_35[var24_29];
                                    if (!monitor.isCanceled()) ** GOTO lbl-1000
                                    if (this.results.size() != 0) {
                                        var34_52 = new MultiStatus("org.eclipsetrader.ui", 0, this.results.toArray(new IStatus[this.results.size()]), Messages.DataImportJob_DownloadErrorMessage, null);
                                        break block55;
                                    }
                                    ** GOTO lbl-1000
                                }
                                ** GOTO lbl116
                            }
                            catch (Exception e) {
                                status = new Status(4, "org.eclipsetrader.ui", 0, String.valueOf(Messages.DataImportJob_SecurityDownloadErrorMessage) + security.getName(), (Throwable)e);
                                this.results.add((IStatus)status);
                                break block56;
                            }
                        }
                    }
                    monitor.done();
                    return var34_52;
lbl-1000:
                    // 1 sources

                    {
                        var34_53 = Status.CANCEL_STATUS;
                    }
                    monitor.done();
                    return var34_53;
lbl-1000:
                    // 1 sources

                    {
                        block57: {
                            if (currentTimeSpan.equals((Object)TimeSpan.days((int)1))) {
                                ohlc = backfillConnector.backfillHistory(identifier, beginDate, endDate, currentTimeSpan);
                                if (ohlc != null && ohlc.length != 0) {
                                    dataMap.put(currentTimeSpan, ohlc);
                                }
                            } else if (intradayBackfillConnector.canBackfill(identifier, currentTimeSpan)) {
                                ohlc = intradayBackfillConnector.backfillHistory(identifier, beginDate, endDate, currentTimeSpan);
                                if (ohlc != null && ohlc.length != 0) {
                                    dataMap.put(currentTimeSpan, ohlc);
                                }
                            } else {
                                dataMap.put(currentTimeSpan, null);
                            }
                            if (!dataMap.containsKey(currentTimeSpan)) {
                                message = NLS.bind((String)Messages.DataImportJob_DownloadDataErrorMessage, (Object[])new Object[]{currentTimeSpan.toString(), security.getName()});
                                status = new Status(4, "org.eclipsetrader.ui", 0, message, null);
                                this.results.add((IStatus)status);
                            }
                            ++var24_29;
                            ** GOTO lbl76
lbl116:
                            // 1 sources

                            if (dataMap.size() != this.timeSpan.length) break block56;
                            var24_30 = dataMap.keySet().iterator();
                            while (true) {
                                if (!var24_30.hasNext()) {
                                    if (!(security instanceof Stock) || (dividends = backfillConnector.backfillDividends(identifier, beginDate, endDate)) == null || dividends.length == 0) break block56;
                                    dividendsMap = new HashMap<Date, Object>();
                                    currentDividends = ((Stock)security).getDividends();
                                    if (currentDividends != null && this.mode != 0) {
                                        var29_45 = currentDividends;
                                        var28_44 = currentDividends.length;
                                        var27_40 = 0;
                                        break;
                                    }
                                    break block57;
                                }
                                currentTimeSpan = (TimeSpan)var24_30.next();
                                ohlc = (IOHLC[])dataMap.get(currentTimeSpan);
                                if (ohlc == null) continue;
                                if (currentTimeSpan.equals((Object)TimeSpan.days((int)1))) {
                                    block58: {
                                        var29_45 = ohlc;
                                        status = ohlc.length;
                                        message = 0;
                                        while (true) {
                                            if (message >= status) {
                                                ohlc = dailyDataMap.values().toArray(new IOHLC[dailyDataMap.values().size()]);
                                                if (history != null) break;
                                                history = new History(security, ohlc);
                                                break block58;
                                            }
                                            d = var29_45[message];
                                            dailyDataMap.put(d.getDate(), d);
                                            ++message;
                                        }
                                        if (history instanceof History) {
                                            ((History)history).setOHLC(ohlc);
                                        }
                                    }
                                    if (security instanceof Stock && history instanceof History && (splits = backfillConnector.backfillSplits(identifier, beginDate, endDate)) != null && splits.length != 0) {
                                        splitsMap = new HashMap<Date, ISplit>();
                                        currentSplits = history.getSplits();
                                        if (currentSplits != null && this.mode != 0) {
                                            var32_49 = currentSplits;
                                            var31_48 = currentSplits.length;
                                            var30_47 = 0;
                                            while (var30_47 < var31_48) {
                                                s = var32_49[var30_47];
                                                splitsMap.put(s.getDate(), s);
                                                ++var30_47;
                                            }
                                        }
                                        i = 0;
                                        while (true) {
                                            if (i >= splits.length) {
                                                c = splitsMap.values();
                                                ((History)history).setSplits(c.toArray(new ISplit[c.size()]));
                                                break;
                                            }
                                            splitsMap.put(splits[i].getDate(), splits[i]);
                                            ++i;
                                        }
                                    }
                                    repositoryService.saveAdaptable((IAdaptable[])new IHistory[]{history}, defaultRepository);
                                    continue;
                                }
                                if (history == null) {
                                    history = new History(security, ohlc);
                                    intradayHistory = history.getSubset(beginDate, endDate, currentTimeSpan);
                                    if (intradayHistory instanceof HistoryDay) {
                                        ((HistoryDay)intradayHistory).setOHLC(ohlc);
                                    }
                                    repositoryService.saveAdaptable((IAdaptable[])new IHistory[]{history, intradayHistory}, defaultRepository);
                                    continue;
                                }
                                intradayHistory = history.getSubset(beginDate, endDate, currentTimeSpan);
                                if (intradayHistory instanceof HistoryDay) {
                                    ((HistoryDay)intradayHistory).setOHLC(ohlc);
                                }
                                repositoryService.saveAdaptable((IAdaptable[])new IHistory[]{intradayHistory}, defaultRepository);
                            }
                            while (var27_40 < var28_44) {
                                d = var29_45[var27_40];
                                dividendsMap.put(d.getExDate(), d);
                                ++var27_40;
                            }
                        }
                        i = 0;
                        while (true) {
                            if (i >= dividends.length) {
                                if (dividendsMap.size() == 0) break;
                                ((Stock)security).setDividends(dividendsMap.values().toArray(new IDividend[dividendsMap.values().size()]));
                                repositoryService.saveAdaptable((IAdaptable[])new ISecurity[]{security});
                                break;
                            }
                            dividendsMap.put(dividends[i].getExDate(), dividends[i]);
                            ++i;
                        }
                    }
                }
                monitor.worked(1);
                ++var8_10;
                ** GOTO lbl12
lbl209:
                // 1 sources

                finally {
                    monitor.done();
                }
            }
            monitor.done();
        }
        if (this.results.size() == 0) return Status.OK_STATUS;
        return new MultiStatus("org.eclipsetrader.ui", 0, this.results.toArray(new IStatus[this.results.size()]), Messages.DataImportJob_DownloadErrorMessage, null);
    }

    Date getDefaultStartDate() throws ParseException {
        int method = this.preferences.getInt("INITIAL_BACKFILL_METHOD");
        if (method == 0) {
            String s = this.preferences.getString("INITIAL_BACKFILL_START_DATE");
            return new SimpleDateFormat("yyyyMMdd").parse(s);
        }
        if (method == 1) {
            Calendar c = Calendar.getInstance();
            c.set(14, 0);
            c.add(1, -this.preferences.getInt("INITIAL_BACKFILL_YEARS"));
            return c.getTime();
        }
        throw new IllegalArgumentException("Invalid initial backfill method " + method);
    }

    protected ISecurity[] getFilteredSecurities(ISecurity[] list) {
        ArrayList<ISecurity> l = new ArrayList<ISecurity>();
        ISecurity[] iSecurityArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            ISecurity security = iSecurityArray[n2];
            IFeedIdentifier identifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class);
            if (identifier != null) {
                l.add(security);
            }
            ++n2;
        }
        Collections.sort(l, new Comparator<ISecurity>(){

            @Override
            public int compare(ISecurity o1, ISecurity o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return l.toArray(new ISecurity[l.size()]);
    }
}

