/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.charts.views.Messages;

public class ChartLoadJob
extends Job {
    ISecurity security;
    TimeSpan timeSpan;
    TimeSpan resolutionTimeSpan;
    IHistory history;
    IHistory subsetHistory;

    public ChartLoadJob(ISecurity security) {
        super("");
        this.security = security;
    }

    public void setTimeSpan(TimeSpan timeSpan) {
        this.timeSpan = timeSpan;
    }

    public void setResolutionTimeSpan(TimeSpan resolutionTimeSpan) {
        this.resolutionTimeSpan = resolutionTimeSpan;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(this.getName(), -1);
        try {
            try {
                this.buildHistory();
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipsetrader.ui", 0, String.valueOf(Messages.ChartLoadJob_ExceptionMessage) + this.security.getName(), (Throwable)e);
                UIActivator.log((IStatus)status);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    void buildHistory() {
        this.history = this.subsetHistory = this.getHistoryFor(this.security);
        if (this.timeSpan != null) {
            Calendar c = Calendar.getInstance();
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            c.set(14, 999);
            if (this.timeSpan.getUnits() == TimeSpan.Units.Days) {
                int index = this.history.getOHLC().length - this.timeSpan.getLength();
                if (index < 0) {
                    index = 0;
                }
                Date firstDate = this.history.getOHLC()[index].getDate();
                this.subsetHistory = this.history.getSubset(firstDate, null, this.resolutionTimeSpan);
            } else {
                c = Calendar.getInstance();
                if (this.history.getLast() != null) {
                    c.setTime(this.history.getLast().getDate());
                } else {
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                }
                switch (this.timeSpan.getUnits()) {
                    case Months: {
                        c.add(2, -this.timeSpan.getLength());
                        if (this.resolutionTimeSpan != null) {
                            this.subsetHistory = this.history.getSubset(c.getTime(), null, this.resolutionTimeSpan);
                            break;
                        }
                        this.subsetHistory = this.history.getSubset(c.getTime(), null);
                        break;
                    }
                    case Years: {
                        c.add(1, -this.timeSpan.getLength());
                        this.subsetHistory = this.history.getSubset(c.getTime(), null);
                    }
                }
            }
        }
    }

    IHistory getHistoryFor(ISecurity security) {
        IRepositoryService repository = UIActivator.getDefault().getRepositoryService();
        return repository.getHistoryFor(security);
    }

    public IHistory getHistory() {
        return this.history;
    }

    public IHistory getSubsetHistory() {
        return this.subsetHistory;
    }

    public TimeSpan getResolutionTimeSpan() {
        return this.resolutionTimeSpan;
    }
}

