/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.OHLCDataSeries;
import org.eclipsetrader.core.charts.repository.IChartTemplate;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.charts.repository.ChartTemplate;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.views.IViewChangeListener;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.ViewEvent;
import org.eclipsetrader.ui.charts.BaseChartViewer;
import org.eclipsetrader.ui.charts.ChartCanvas;
import org.eclipsetrader.ui.charts.ChartObjectFactoryTransfer;
import org.eclipsetrader.ui.charts.ChartRowViewItem;
import org.eclipsetrader.ui.charts.ChartView;
import org.eclipsetrader.ui.charts.ChartViewItem;
import org.eclipsetrader.ui.charts.IChartEditorListener;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.charts.DataImportJob;
import org.eclipsetrader.ui.internal.charts.ImportDataPage;
import org.eclipsetrader.ui.internal.charts.Period;
import org.eclipsetrader.ui.internal.charts.PeriodList;
import org.eclipsetrader.ui.internal.charts.views.ChartLoadJob;
import org.eclipsetrader.ui.internal.charts.views.ChartViewDropTarget;
import org.eclipsetrader.ui.internal.charts.views.ChartViewItemFinder;
import org.eclipsetrader.ui.internal.charts.views.CurrentBookFactory;
import org.eclipsetrader.ui.internal.charts.views.CurrentPriceLineFactory;
import org.eclipsetrader.ui.internal.charts.views.MainChartFactory;
import org.eclipsetrader.ui.internal.charts.views.Messages;
import org.eclipsetrader.ui.internal.charts.views.SelectionProvider;
import org.eclipsetrader.ui.internal.charts.views.ToolAction;
import org.osgi.framework.Bundle;

public class ChartViewPart
extends ViewPart
implements ISaveablePart {
    public static final String VIEW_ID = "org.eclipsetrader.ui.chart";
    public static final String K_VIEWS = "Views";
    public static final String K_URI = "uri";
    public static final String K_TEMPLATE = "template";
    public static final String K_PRIVATE_TEMPLATE = "private-template";
    public static final String K_PERIOD = "period";
    public static final String K_RESOLUTION = "resolution";
    public static final String K_SHOW_TOOLTIPS = "show-tooltips";
    public static final String K_ZOOM_FACTOR = "zoom-factor";
    public static final String K_SHOW_CURRENT_PRICE = "show-current-price";
    public static final String K_SHOW_CURRENT_BOOK = "show-current-book";
    private URI uri;
    private ISecurity security;
    private IChartTemplate template;
    private BaseChartViewer viewer;
    private ChartView view;
    private IHistory history;
    private IHistory subsetHistory;
    private ChartViewDropTarget dropListener;
    private boolean dirty;
    private IDialogSettings dialogSettings;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action deleteAction;
    private Action propertiesAction;
    private Action zoomOutAction;
    private Action zoomInAction;
    private Action zoomResetAction;
    private Action updateAction;
    private Action periodAllAction;
    private ContributionItem[] periodActions;
    private Action currentPriceLineAction;
    private CurrentPriceLineFactory currentPriceLineFactory;
    private Action currentBookAction;
    private CurrentBookFactory currentBookFactory;
    IMemento memento;
    IPreferenceStore preferenceStore;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(java.beans.PropertyChangeEvent evt) {
            if ("bars".equals(evt.getPropertyName())) {
                TimeSpan resolution = TimeSpan.fromString((String)ChartViewPart.this.dialogSettings.get(ChartViewPart.K_RESOLUTION));
                ChartViewPart.this.view.setRootDataSeries((IDataSeries)new OHLCDataSeries(ChartViewPart.this.security.getName(), ChartViewPart.this.subsetHistory.getAdjustedOHLC(), resolution));
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ChartViewPart.this.viewer.getControl().isDisposed()) {
                            ChartViewPart.this.refreshChart();
                        }
                    }
                });
            }
        }
    };
    private IViewChangeListener viewChangeListener = new IViewChangeListener(){

        public void viewChanged(ViewEvent event) {
            ChartViewPart.this.scheduleLoadJob();
            ChartViewPart.this.setDirty();
        }
    };
    private IPropertyChangeListener preferenceChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            IPreferenceStore preferences = (IPreferenceStore)event.getSource();
            if ("SHOW_TOOLTIPS".equals(event.getProperty())) {
                ChartViewPart.this.viewer.setShowTooltips(preferences.getBoolean("SHOW_TOOLTIPS"));
            }
            if ("SHOW_SCALE_TOOLTIPS".equals(event.getProperty())) {
                ChartViewPart.this.viewer.setShowScaleTooltips(preferences.getBoolean("SHOW_SCALE_TOOLTIPS"));
            }
            if ("CROSSHAIR_ACTIVATION".equals(event.getProperty())) {
                ChartViewPart.this.viewer.setCrosshairMode(preferences.getInt("CROSSHAIR_ACTIVATION"));
            }
            if ("CROSSHAIR_SUMMARY_TOOLTIP".equals(event.getProperty())) {
                ChartViewPart.this.viewer.setDecoratorSummaryTooltips(preferences.getBoolean("CROSSHAIR_SUMMARY_TOOLTIP"));
            }
            if ("CHART_PERIODS".equals(event.getProperty())) {
                ChartViewPart.this.updatePeriodActions();
            }
        }
    };
    private Action printAction = new Action(Messages.ChartViewPart_PrintAction){

        public void run() {
            PrintDialog dialog = new PrintDialog(ChartViewPart.this.getViewSite().getShell(), 0);
            PrinterData data = dialog.open();
            if (data == null) {
                return;
            }
            if (data.printToFile) {
                data.fileName = "print.out";
            }
            Printer printer = new Printer(data);
            try {
                try {
                    Rectangle printerBounds = printer.getClientArea();
                    Rectangle trimBounds = printer.computeTrim(printerBounds.x, printerBounds.y, printerBounds.width, printerBounds.height);
                    System.out.println(printerBounds + ", " + trimBounds);
                    if (printer.startJob(ChartViewPart.this.getPartName())) {
                        ChartViewPart.this.viewer.print(printer);
                        printer.endJob();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    printer.dispose();
                }
            }
            finally {
                printer.dispose();
            }
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
        this.preferenceStore = UIActivator.getDefault().getPreferenceStore();
        try {
            this.dialogSettings = UIActivator.getDefault().getDialogSettings().getSection(K_VIEWS).getSection(site.getSecondaryId());
            this.uri = new URI(this.dialogSettings.get(K_URI));
            IRepositoryService repositoryService = UIActivator.getDefault().getRepositoryService();
            this.security = repositoryService.getSecurityFromURI(this.uri);
            String privateTemplate = this.dialogSettings.get(K_PRIVATE_TEMPLATE);
            if (privateTemplate != null) {
                this.template = this.unmarshal(privateTemplate);
            }
            if (this.template == null) {
                Path templatePath = new Path("data");
                templatePath = this.dialogSettings.get(K_TEMPLATE) != null ? templatePath.append(this.dialogSettings.get(K_TEMPLATE)) : templatePath.append("basic-template.xml");
                InputStream stream = FileLocator.openStream((Bundle)UIActivator.getDefault().getBundle(), (IPath)templatePath, (boolean)false);
                this.template = this.unmarshal(stream);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui", String.valueOf(Messages.ChartViewPart_LoadingErrorMessage) + site.getSecondaryId(), (Throwable)e);
            UIActivator.getDefault().getLog().log((IStatus)status);
        }
        site.setSelectionProvider((ISelectionProvider)new SelectionProvider());
        this.createActions();
        this.createPeriodActions();
        IActionBars actionBars = site.getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IContributionItem)new Separator("periods.top"));
        menuManager.add((IContributionItem)new Separator("periods"));
        menuManager.add((IContributionItem)new Separator("periods.bottom"));
        menuManager.add((IAction)this.currentPriceLineAction);
        menuManager.add((IAction)this.currentBookAction);
        menuManager.appendToGroup("periods.top", (IAction)this.periodAllAction);
        if (this.periodActions != null) {
            int i = 0;
            while (i < this.periodActions.length) {
                menuManager.appendToGroup("periods", (IContributionItem)this.periodActions[i]);
                ++i;
            }
        }
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IAction)this.updateAction);
        TimeSpan periodTimeSpan = TimeSpan.fromString((String)this.dialogSettings.get(K_PERIOD));
        TimeSpan resolutionTimeSpan = TimeSpan.fromString((String)this.dialogSettings.get(K_RESOLUTION));
        this.setPeriodActionSelection(periodTimeSpan, resolutionTimeSpan);
        actionBars.setGlobalActionHandler(this.cutAction.getId(), (IAction)this.cutAction);
        actionBars.setGlobalActionHandler(this.copyAction.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(this.pasteAction.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(this.deleteAction.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)this.printAction);
        ToolAction toolAction = new ToolAction(Messages.ChartViewPart_LineAction, (IViewPart)this, "org.eclipsetrader.ui.charts.tools.line");
        actionBars.setGlobalActionHandler(toolAction.getId(), (IAction)toolAction);
        toolAction = new ToolAction(Messages.ChartViewPart_FiboLineAction, (IViewPart)this, "org.eclipsetrader.ui.charts.tools.fiboline");
        actionBars.setGlobalActionHandler(toolAction.getId(), (IAction)toolAction);
        toolAction = new ToolAction(Messages.ChartViewPart_FanLineAction, (IViewPart)this, "org.eclipsetrader.ui.charts.tools.fanline");
        actionBars.setGlobalActionHandler(toolAction.getId(), (IAction)toolAction);
        toolAction = new ToolAction(Messages.ChartViewPart_FiboArcAction, (IViewPart)this, "org.eclipsetrader.ui.charts.tools.fiboarc");
        actionBars.setGlobalActionHandler(toolAction.getId(), (IAction)toolAction);
        actionBars.setGlobalActionHandler(this.zoomInAction.getActionDefinitionId(), (IAction)this.zoomInAction);
        actionBars.setGlobalActionHandler(this.zoomOutAction.getActionDefinitionId(), (IAction)this.zoomOutAction);
        actionBars.setGlobalActionHandler(this.zoomResetAction.getActionDefinitionId(), (IAction)this.zoomResetAction);
        actionBars.setGlobalActionHandler(this.propertiesAction.getId(), (IAction)this.propertiesAction);
        actionBars.updateActionBars();
    }

    public void saveState(IMemento memento) {
        memento.putInteger(K_ZOOM_FACTOR, this.viewer.getZoomFactor());
        int[] weights = this.viewer.getWeights();
        if (weights.length > 1) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < weights.length) {
                if (i != 0) {
                    sb.append(";");
                }
                sb.append(weights[i]);
                ++i;
            }
            memento.putString("weights", sb.toString());
        }
        super.saveState(memento);
    }

    protected void createActions() {
        ISharedImages sharedImages = this.getViewSite().getWorkbenchWindow().getWorkbench().getSharedImages();
        this.zoomInAction = new Action(Messages.ChartViewPart_ZoomInAction){

            public void run() {
                int factor = ChartViewPart.this.viewer.getZoomFactor();
                ChartViewPart.this.viewer.setZoomFactor(factor + 1);
                ChartViewPart.this.zoomOutAction.setEnabled(true);
                ChartViewPart.this.zoomResetAction.setEnabled(true);
            }
        };
        this.zoomInAction.setId("zoomIn");
        this.zoomInAction.setActionDefinitionId("org.eclipsetrader.ui.charts.zoomIn");
        this.zoomOutAction = new Action(Messages.ChartViewPart_ZoomOutAction){

            public void run() {
                int factor = ChartViewPart.this.viewer.getZoomFactor();
                if (factor > 0) {
                    ChartViewPart.this.viewer.setZoomFactor(factor - 1);
                }
                ChartViewPart.this.zoomOutAction.setEnabled(factor != 1);
                ChartViewPart.this.zoomResetAction.setEnabled(factor != 1);
            }
        };
        this.zoomOutAction.setId("zoomOut");
        this.zoomOutAction.setActionDefinitionId("org.eclipsetrader.ui.charts.zoomOut");
        this.zoomResetAction = new Action(Messages.ChartViewPart_NormalSizeAction){

            public void run() {
                ChartViewPart.this.viewer.setZoomFactor(0);
                ChartViewPart.this.zoomOutAction.setEnabled(false);
                ChartViewPart.this.zoomResetAction.setEnabled(false);
            }
        };
        this.zoomResetAction.setId("zoomReset");
        this.zoomResetAction.setActionDefinitionId("org.eclipsetrader.ui.charts.zoomReset");
        this.zoomOutAction.setEnabled(false);
        this.zoomResetAction.setEnabled(false);
        this.periodAllAction = new Action(Messages.ChartViewPart_AllPeriodAction, 8){

            public void run() {
                ChartViewPart.this.setPeriod(null, TimeSpan.days((int)1));
            }
        };
        this.cutAction = new Action(Messages.ChartViewPart_CutAction){

            public void run() {
            }
        };
        this.cutAction.setId("cut");
        this.cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.cutAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.cutAction.setEnabled(false);
        this.copyAction = new Action(Messages.ChartViewPart_CopyAction){

            public void run() {
            }
        };
        this.copyAction.setId("copy");
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setEnabled(false);
        this.pasteAction = new Action(Messages.ChartViewPart_PasteAction){

            public void run() {
            }
        };
        this.pasteAction.setId("copy");
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setEnabled(false);
        this.deleteAction = new Action(Messages.ChartViewPart_DeleteAction){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)ChartViewPart.this.getViewSite().getSelectionProvider().getSelection();
                if (!selection.isEmpty() && MessageDialog.openConfirm((Shell)ChartViewPart.this.getViewSite().getShell(), (String)ChartViewPart.this.getPartName(), (String)Messages.ChartViewPart_DeleteConfirmMessage)) {
                    ChartViewItem viewItem = (ChartViewItem)((Object)selection.getFirstElement());
                    ChartRowViewItem rowViewItem = (ChartRowViewItem)viewItem.getParent();
                    if (rowViewItem.getItemCount() == 1) {
                        rowViewItem.getParentView().removeRow(rowViewItem);
                    } else {
                        rowViewItem.removeChildItem(viewItem);
                    }
                }
            }
        };
        this.deleteAction.setId("delete");
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setEnabled(false);
        this.updateAction = new Action(Messages.ChartViewPart_UpdateAction){

            public void run() {
                ChartViewPart.this.doUpdate();
            }
        };
        this.updateAction.setId("update");
        this.updateAction.setImageDescriptor(UIActivator.getImageDescriptor("icons/etool16/refresh.gif"));
        this.updateAction.setEnabled(true);
        this.propertiesAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getViewSite().getShell()), this.getSite().getSelectionProvider()){

            public void run() {
                PreferenceDialog dialog = this.createDialog();
                if (dialog != null && dialog.open() == 0) {
                    IStructuredSelection selection = (IStructuredSelection)ChartViewPart.this.getSite().getSelectionProvider().getSelection();
                    ChartViewItem viewItem = (ChartViewItem)((Object)selection.getFirstElement());
                    ((ChartRowViewItem)viewItem.getParent()).refresh();
                    ChartViewPart.this.refreshChart();
                    ChartViewPart.this.setDirty();
                }
            }
        };
        this.propertiesAction.setId(ActionFactory.PROPERTIES.getId());
        this.propertiesAction.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.propertiesAction.setEnabled(false);
        this.currentPriceLineAction = new Action(Messages.ChartViewPart_ShowCurrentPriceAction, 2){

            public void run() {
                ChartViewPart.this.currentPriceLineFactory.setEnable(this.isChecked());
                ChartViewPart.this.dialogSettings.put(ChartViewPart.K_SHOW_CURRENT_PRICE, this.isChecked());
            }
        };
        this.currentBookAction = new Action(Messages.ChartViewPart_ShowBookAction, 2){

            public void run() {
                ChartViewPart.this.currentBookFactory.setEnable(this.isChecked());
                ChartViewPart.this.dialogSettings.put(ChartViewPart.K_SHOW_CURRENT_BOOK, this.isChecked());
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.viewer = new BaseChartViewer(parent, 0);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChartViewPart.this.handleSelectionChanged((IStructuredSelection)event.getSelection());
                ChartViewPart.this.handleActionsEnablement();
            }
        });
        this.viewer.getEditor().addListener(new IChartEditorListener(){

            @Override
            public void applyEditorValue() {
                ChartViewPart.this.refreshChart();
                ChartViewPart.this.setDirty();
            }

            @Override
            public void cancelEditor() {
            }
        });
        Transfer[] transferTypes = new Transfer[]{ChartObjectFactoryTransfer.getInstance()};
        DropTarget dropTarget = new DropTarget(this.viewer.getControl(), 3);
        dropTarget.setTransfer(transferTypes);
        this.dropListener = new ChartViewDropTarget(this.viewer);
        dropTarget.addDropListener((DropTargetListener)this.dropListener);
        this.viewer.setShowTooltips(this.preferenceStore.getBoolean("SHOW_TOOLTIPS"));
        this.viewer.setShowScaleTooltips(this.preferenceStore.getBoolean("SHOW_SCALE_TOOLTIPS"));
        this.viewer.setCrosshairMode(this.preferenceStore.getInt("CROSSHAIR_ACTIVATION"));
        this.viewer.setDecoratorSummaryTooltips(this.preferenceStore.getBoolean("CROSSHAIR_SUMMARY_TOOLTIP"));
        this.preferenceStore.addPropertyChangeListener(this.preferenceChangeListener);
        if (this.memento != null && this.memento.getString(K_ZOOM_FACTOR) != null) {
            int factor = this.memento.getInteger(K_ZOOM_FACTOR);
            this.viewer.setZoomFactor(factor);
            this.zoomOutAction.setEnabled(factor != 0);
            this.zoomResetAction.setEnabled(factor != 0);
        }
        this.createContextMenu();
        this.currentPriceLineFactory = new CurrentPriceLineFactory();
        this.currentPriceLineFactory.setSecurity(this.security);
        this.currentPriceLineFactory.setEnable(this.dialogSettings.getBoolean(K_SHOW_CURRENT_PRICE));
        this.currentPriceLineAction.setChecked(this.dialogSettings.getBoolean(K_SHOW_CURRENT_PRICE));
        this.currentBookFactory = new CurrentBookFactory();
        this.currentBookFactory.setSecurity(this.security);
        this.currentBookFactory.setEnable(this.dialogSettings.getBoolean(K_SHOW_CURRENT_BOOK));
        this.currentBookAction.setChecked(this.dialogSettings.getBoolean(K_SHOW_CURRENT_BOOK));
        if (this.security != null && this.template != null) {
            this.setPartName(NLS.bind((String)"{0} - {1}", (Object[])new Object[]{this.security.getName(), this.template.getName()}));
            this.view = new ChartView(this.template);
            ChartRowViewItem rowItem = (ChartRowViewItem)this.view.getItems()[0];
            ChartViewItem viewItem = new ChartViewItem(rowItem, this.currentPriceLineFactory);
            rowItem.addChildItem(0, viewItem);
            viewItem = new ChartViewItem(rowItem, this.currentBookFactory);
            rowItem.addChildItem(0, viewItem);
            this.view.addViewChangeListener(this.viewChangeListener);
            this.scheduleLoadJob();
        }
    }

    void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("top"));
                menuManager.add((IAction)ChartViewPart.this.cutAction);
                menuManager.add((IAction)ChartViewPart.this.copyAction);
                menuManager.add((IAction)ChartViewPart.this.pasteAction);
                menuManager.add((IContributionItem)new Separator());
                menuManager.add((IAction)ChartViewPart.this.deleteAction);
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IAction)ChartViewPart.this.propertiesAction);
            }
        });
        this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
    }

    void scheduleLoadJob() {
        PropertyChangeSupport propertyChangeSupport;
        final Display display = this.viewer.getControl().getDisplay();
        if (this.subsetHistory != null && (propertyChangeSupport = (PropertyChangeSupport)this.subsetHistory.getAdapter(PropertyChangeSupport.class)) != null) {
            propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
        }
        ChartLoadJob job = new ChartLoadJob(this.security);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ChartLoadJob job = (ChartLoadJob)event.getJob();
                ChartViewPart.this.history = job.getHistory();
                ChartViewPart.this.subsetHistory = job.getSubsetHistory();
                ChartViewPart.this.view.setRootDataSeries((IDataSeries)new OHLCDataSeries(ChartViewPart.this.security.getName(), ChartViewPart.this.subsetHistory.getAdjustedOHLC(), job.getResolutionTimeSpan()));
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ChartViewPart.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        if ((this).ChartViewPart.this.memento == null) {
                            (this).ChartViewPart.this.memento = XMLMemento.createWriteRoot((String)"root");
                        }
                        ChartViewPart.this.saveState((this).ChartViewPart.this.memento);
                        TimeSpan resolutionTimeSpan = TimeSpan.fromString((String)ChartViewPart.this.dialogSettings.get(ChartViewPart.K_RESOLUTION));
                        if (resolutionTimeSpan == null) {
                            resolutionTimeSpan = TimeSpan.days((int)1);
                        }
                        ChartViewPart.this.viewer.setResolutionTimeSpan(resolutionTimeSpan);
                        ChartViewPart.this.dropListener.setView(ChartViewPart.this.view);
                        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)ChartViewPart.this.subsetHistory.getAdapter(PropertyChangeSupport.class);
                        if (propertyChangeSupport != null) {
                            propertyChangeSupport.addPropertyChangeListener(ChartViewPart.this.propertyChangeListener);
                        }
                        ChartViewPart.this.refreshChart();
                    }
                });
            }
        });
        job.setTimeSpan(TimeSpan.fromString((String)this.dialogSettings.get(K_PERIOD)));
        job.setResolutionTimeSpan(TimeSpan.fromString((String)this.dialogSettings.get(K_RESOLUTION)));
        job.setName(String.valueOf(Messages.ChartViewPart_LoadingText) + this.getPartName());
        job.setUser(true);
        job.schedule();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        PropertyChangeSupport propertyChangeSupport;
        this.view.removeViewChangeListener(this.viewChangeListener);
        if (this.subsetHistory != null && (propertyChangeSupport = (PropertyChangeSupport)this.subsetHistory.getAdapter(PropertyChangeSupport.class)) != null) {
            propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (UIActivator.getDefault() != null) {
            IPreferenceStore preferences = UIActivator.getDefault().getPreferenceStore();
            preferences.removePropertyChangeListener(this.preferenceChangeListener);
        }
        super.dispose();
    }

    protected void handleSelectionChanged(IStructuredSelection selection) {
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof IChartObject)) {
            this.getViewSite().getSelectionProvider().setSelection((ISelection)StructuredSelection.EMPTY);
            return;
        }
        ChartViewItemFinder finder = new ChartViewItemFinder((IChartObject)selection.getFirstElement());
        this.view.accept(finder);
        if (finder.getViewItem() == null) {
            this.getViewSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)this.view));
        } else {
            this.getViewSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)finder.getViewItem()));
        }
    }

    protected void handleActionsEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewSite().getSelectionProvider().getSelection();
        IViewItem viewItem = (IViewItem)selection.getFirstElement();
        this.cutAction.setEnabled(!selection.isEmpty() && viewItem != null && viewItem.getAdapter(MainChartFactory.class) == null);
        this.copyAction.setEnabled(!selection.isEmpty() && viewItem != null && viewItem.getAdapter(MainChartFactory.class) == null);
        this.deleteAction.setEnabled(!selection.isEmpty() && viewItem != null && viewItem.getAdapter(MainChartFactory.class) == null);
        this.propertiesAction.setEnabled(!selection.isEmpty());
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            String privateTemplate = this.marshal(this.view.getTemplate());
            this.dialogSettings.put(K_PRIVATE_TEMPLATE, privateTemplate);
            this.clearDirty();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
    }

    protected void setDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.firePropertyChange(257);
        }
    }

    protected void clearDirty() {
        if (this.dirty) {
            this.dirty = false;
            this.firePropertyChange(257);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.dirty;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(BaseChartViewer.class)) {
            return this.viewer;
        }
        if (adapter.isAssignableFrom(ChartCanvas.class)) {
            return this.viewer.getSelectedChartCanvas();
        }
        if (adapter.isAssignableFrom(ChartView.class)) {
            return this.view;
        }
        if (adapter.isAssignableFrom(IChartTemplate.class)) {
            return this.template;
        }
        if (adapter.isAssignableFrom(ISecurity.class)) {
            return this.security;
        }
        if (adapter.isAssignableFrom(IDialogSettings.class)) {
            return this.dialogSettings;
        }
        return super.getAdapter(adapter);
    }

    private String marshal(IChartTemplate object) throws Exception {
        StringWriter string = new StringWriter();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ChartTemplate.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)object, (Writer)string);
        return string.toString();
    }

    private ChartTemplate unmarshal(String string) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ChartTemplate.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (ChartTemplate)unmarshaller.unmarshal((Reader)new StringReader(string));
    }

    private ChartTemplate unmarshal(InputStream stream) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ChartTemplate.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (ChartTemplate)unmarshaller.unmarshal(stream);
    }

    protected void refreshChart() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ChartRowViewItem[] rowViewItem = (ChartRowViewItem[])ChartViewPart.this.view.getAdapter(ChartRowViewItem[].class);
                if (rowViewItem != null) {
                    IChartObject[][] input = new IChartObject[rowViewItem.length][];
                    int i = 0;
                    while (i < input.length) {
                        input[i] = (IChartObject[])rowViewItem[i].getAdapter(IChartObject[].class);
                        ++i;
                    }
                    ChartViewPart.this.viewer.setInput(input);
                    if (ChartViewPart.this.memento != null && ChartViewPart.this.memento.getString("weights") != null) {
                        String[] s = ChartViewPart.this.memento.getString("weights").split(";");
                        int[] weights = ChartViewPart.this.viewer.getWeights();
                        int i2 = 0;
                        while (i2 < weights.length && i2 < s.length) {
                            weights[i2] = Integer.valueOf(s[i2]);
                            ++i2;
                        }
                        ChartViewPart.this.viewer.setWeights(weights);
                    }
                }
            }
        });
    }

    public void setPeriod(TimeSpan period, TimeSpan resolution) {
        this.dialogSettings.put(K_PERIOD, period != null ? period.toString() : null);
        this.dialogSettings.put(K_RESOLUTION, resolution != null ? resolution.toString() : null);
        this.periodAllAction.setChecked(period == null);
        this.setPeriodActionSelection(period, resolution);
        this.scheduleLoadJob();
    }

    protected void doUpdate() {
        String[] s;
        TimeSpan[] aggregation = new TimeSpan[]{TimeSpan.days((int)1), TimeSpan.minutes((int)1)};
        IDialogSettings dialogSettings = UIActivator.getDefault().getDialogSettings().getSection(ImportDataPage.class.getName());
        if (dialogSettings != null && (s = dialogSettings.getArray("AGGREGATION")) != null && s.length != 0) {
            aggregation = new TimeSpan[s.length];
            int i = 0;
            while (i < aggregation.length) {
                aggregation[i] = TimeSpan.fromString((String)s[i]);
                ++i;
            }
        }
        DataImportJob job = new DataImportJob(this.security, 1, null, null, aggregation);
        job.setUser(true);
        job.schedule();
    }

    protected void updatePeriodActions() {
        int i;
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        if (this.periodActions != null) {
            i = 0;
            while (i < this.periodActions.length) {
                menuManager.remove((IContributionItem)this.periodActions[i]);
                this.periodActions[i].dispose();
                ++i;
            }
            this.periodActions = null;
        }
        this.createPeriodActions();
        if (this.periodActions != null) {
            i = 0;
            while (i < this.periodActions.length) {
                menuManager.appendToGroup("periods", (IContributionItem)this.periodActions[i]);
                ++i;
            }
        }
        TimeSpan periodTimeSpan = TimeSpan.fromString((String)this.dialogSettings.get(K_PERIOD));
        TimeSpan resolutionTimeSpan = TimeSpan.fromString((String)this.dialogSettings.get(K_RESOLUTION));
        this.setPeriodActionSelection(periodTimeSpan, resolutionTimeSpan);
        actionBars.updateActionBars();
    }

    public void createPeriodActions() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PeriodList.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader stream = new StringReader(UIActivator.getDefault().getPreferenceStore().getString("CHART_PERIODS"));
            PeriodList list = (PeriodList)unmarshaller.unmarshal((Reader)stream);
            Collections.sort(list, new Comparator<Period>(){

                @Override
                public int compare(Period o1, Period o2) {
                    if (o1.getPeriod().higherThan(o2.getPeriod())) {
                        return -1;
                    }
                    if (o2.getPeriod().higherThan(o1.getPeriod())) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.periodActions = new ContributionItem[list.size()];
            int i = 0;
            while (i < this.periodActions.length) {
                this.periodActions[i] = new ContributionItem(list.get(i));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPeriodActionSelection(TimeSpan period, TimeSpan resolution) {
        if (this.periodActions != null) {
            int i = 0;
            while (i < this.periodActions.length) {
                this.periodActions[i].getAction().setChecked(this.periodActions[i].getPeriod().equalsTo(period, resolution));
                ++i;
            }
        }
    }

    private class ContributionItem
    extends ActionContributionItem {
        private final Period period;

        public ContributionItem(final Period period) {
            super((IAction)new Action(period.getDescription(), 8){

                public void run() {
                    ChartViewPart.this.setPeriod(period.getPeriod(), period.getResolution());
                }
            });
            this.period = period;
        }

        public Period getPeriod() {
            return this.period;
        }
    }
}

