/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.text.NumberFormat;
import java.util.Observable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.feed.IBook;
import org.eclipsetrader.core.feed.IBookEntry;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.DataBounds;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.IGraphics;
import org.eclipsetrader.ui.charts.Util;

public class CurrentBook
extends Observable
implements IChartObject,
IAdaptable {
    ITrade trade;
    IBook book;
    int width;
    int height;
    int boxWidth = 100;
    long biggestQuantity;
    RGB bidForeground = new RGB(255, 0, 0);
    RGB askForeground = new RGB(0, 255, 0);
    RGB bidBackground;
    RGB askBackground;
    NumberFormat numberFormat = NumberFormat.getInstance();

    public CurrentBook() {
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setMinimumIntegerDigits(1);
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(4);
    }

    public void setBook(IBook book) {
        this.book = book;
        this.setChanged();
        this.notifyObservers();
    }

    public void setTrade(ITrade trade) {
        this.trade = trade;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void accept(IChartObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return false;
    }

    @Override
    public IDataSeries getDataSeries() {
        return null;
    }

    @Override
    public String getToolTip() {
        return null;
    }

    @Override
    public String getToolTip(int x, int y) {
        return null;
    }

    @Override
    public void handleFocusGained(ChartObjectFocusEvent event) {
    }

    @Override
    public void handleFocusLost(ChartObjectFocusEvent event) {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void paint(IGraphics graphics) {
        int x;
        int w;
        if (this.book == null) {
            return;
        }
        IBookEntry[] bidEntry = this.book.getBidProposals();
        IBookEntry[] askEntry = this.book.getAskProposals();
        if (bidEntry.length == 0 && askEntry.length == 0) {
            return;
        }
        this.calculateBiggestQuantity();
        if (this.biggestQuantity == 0L) {
            return;
        }
        int verticalCenter = 0;
        if (this.trade != null && this.trade.getPrice() != null) {
            verticalCenter = graphics.mapToVerticalAxis(this.trade.getPrice());
        } else if (bidEntry.length != 0 && askEntry.length != 0) {
            double middle = (askEntry[0].getPrice() + bidEntry[0].getPrice()) / 2.0;
            verticalCenter = graphics.mapToVerticalAxis(middle);
        } else if (bidEntry.length != 0) {
            verticalCenter = graphics.mapToVerticalAxis(bidEntry[0].getPrice());
        } else if (askEntry.length != 0) {
            verticalCenter = graphics.mapToVerticalAxis(askEntry[0].getPrice());
        }
        this.bidBackground = Util.blend(this.bidForeground, graphics.getBackgroundColor(), 25);
        this.askBackground = Util.blend(this.askForeground, graphics.getBackgroundColor(), 25);
        Point extents = graphics.stringExtent(this.numberFormat.format(this.biggestQuantity));
        int y = verticalCenter + extents.y + 2;
        int i = 0;
        while (i < 5 && i < bidEntry.length) {
            w = this.getBarWidth(bidEntry[i]);
            x = this.width - w - 10;
            graphics.setForegroundColor(this.bidForeground);
            graphics.setBackgroundColor(this.bidBackground);
            graphics.fillRectangle(x, y - extents.y + 2, w, extents.y - 4);
            graphics.drawRectangle(x, y - extents.y + 2, w, extents.y - 4);
            y += extents.y + 4;
            ++i;
        }
        y = verticalCenter - 2;
        i = 0;
        while (i < 5 && i < askEntry.length) {
            w = this.getBarWidth(askEntry[i]);
            x = this.width - w - 10;
            graphics.setForegroundColor(this.askForeground);
            graphics.setBackgroundColor(this.askBackground);
            graphics.fillRectangle(x, y - extents.y + 2, w, extents.y - 4);
            graphics.drawRectangle(x, y - extents.y + 2, w, extents.y - 4);
            y -= extents.y + 4;
            ++i;
        }
    }

    @Override
    public void paintScale(Graphics graphics) {
    }

    @Override
    public void setDataBounds(DataBounds bounds) {
        this.width = bounds.width;
        this.height = bounds.height;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    void calculateBiggestQuantity() {
        this.biggestQuantity = 0L;
        IBookEntry[] entry = this.book.getBidProposals();
        int i = 0;
        while (i < entry.length && i < 5) {
            this.biggestQuantity = Math.max(this.biggestQuantity, entry[i].getQuantity());
            ++i;
        }
        entry = this.book.getAskProposals();
        i = 0;
        while (i < entry.length && i < 5) {
            this.biggestQuantity = Math.max(this.biggestQuantity, entry[i].getQuantity());
            ++i;
        }
    }

    int getBarWidth(IBookEntry entry) {
        return (int)(entry.getQuantity().doubleValue() / (double)this.biggestQuantity * 100.0);
    }
}

