/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;

public class DataViewerLabelProvider
extends ObservableMapLabelProvider {
    private DateFormat dateFormat;
    private NumberFormat decimalNumberFormat = NumberFormat.getInstance();
    private NumberFormat integerNumberFormat = NumberFormat.getInstance();

    public DataViewerLabelProvider(IObservableMap attributeMap) {
        this(new IObservableMap[]{attributeMap});
    }

    public DataViewerLabelProvider(IObservableMap[] attributeMaps) {
        super(attributeMaps);
        this.decimalNumberFormat.setGroupingUsed(true);
        this.decimalNumberFormat.setMinimumIntegerDigits(1);
        this.decimalNumberFormat.setMinimumFractionDigits(1);
        this.decimalNumberFormat.setMaximumFractionDigits(4);
        this.integerNumberFormat.setGroupingUsed(true);
        this.integerNumberFormat.setMinimumIntegerDigits(1);
        this.integerNumberFormat.setMinimumFractionDigits(0);
        this.integerNumberFormat.setMaximumFractionDigits(0);
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (columnIndex < this.attributeMaps.length) {
            Object result = this.attributeMaps[columnIndex].get(element);
            if (result instanceof Date) {
                text = this.dateFormat.format(result);
            } else if (result instanceof Long || result instanceof Integer) {
                text = this.integerNumberFormat.format(result);
            } else if (result instanceof Number) {
                text = this.decimalNumberFormat.format(result);
            } else if (result != null) {
                text = result.toString();
            }
        }
        return text;
    }
}

