/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.ui.internal.charts.views.HistoryDataEditorModel;
import org.eclipsetrader.ui.internal.charts.views.HistoryDataElement;

public class HistoryDataDetailEditorModel {
    private IHistory[] history;
    private PropertyChangeListener[] dataChangeListener;
    private final Map<IHistory, HistoryDataEditorModel> map = new HashMap<IHistory, HistoryDataEditorModel>();
    private final WritableList list = new WritableList();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private final IListChangeListener listChangeListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            event.diff.accept(new ListDiffVisitor(){

                public void handleRemove(int index, Object element) {
                    PropertyChangeListener[] listeners = HistoryDataDetailEditorModel.this.changeSupport.getPropertyChangeListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        ((HistoryDataElement)element).removePropertyChangeListener(listeners[i]);
                        ++i;
                    }
                }

                public void handleAdd(int index, Object element) {
                    PropertyChangeListener[] listeners = HistoryDataDetailEditorModel.this.changeSupport.getPropertyChangeListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        ((HistoryDataElement)element).addPropertyChangeListener(listeners[i]);
                        ++i;
                    }
                }
            });
        }
    };

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void set(IHistory[] history) {
        this.history = history;
        this.dataChangeListener = new PropertyChangeListener[history.length];
        int i = 0;
        while (i < history.length) {
            final HistoryDataEditorModel model = new HistoryDataEditorModel(history[i].getTimeSpan());
            model.set(history[i].getOHLC());
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)history[i].getAdapter(PropertyChangeSupport.class);
            if (propertyChangeSupport != null) {
                this.dataChangeListener[i] = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("bars".equals(evt.getPropertyName())) {
                            final IOHLC[] newBars = (IOHLC[])evt.getNewValue();
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    model.merge(newBars);
                                }
                            });
                        }
                    }
                };
                propertyChangeSupport.addPropertyChangeListener(this.dataChangeListener[i]);
            }
            model.getList().addListChangeListener(this.listChangeListener);
            this.map.put(history[i], model);
            ++i;
        }
        this.list.addAll(this.map.values());
    }

    public WritableList getList() {
        return this.list;
    }

    public Map<IHistory, HistoryDataEditorModel> getMap() {
        return this.map;
    }

    public void dispose() {
        int i = 0;
        while (i < this.history.length) {
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)this.history[i].getAdapter(PropertyChangeSupport.class);
            if (propertyChangeSupport != null) {
                propertyChangeSupport.removePropertyChangeListener(this.dataChangeListener[i]);
            }
            ++i;
        }
    }

    public HistoryDataEditorModel getParent(Object element) {
        for (HistoryDataEditorModel model : this.map.values()) {
            if (!model.getList().contains(element)) continue;
            return model;
        }
        return null;
    }
}

